/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.codeStyle.AllOccurrencesMatcher;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.FixingLayoutTypoTolerantMatcher;
import com.intellij.psi.codeStyle.MatcherWithFallback;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.PinyinMatcher;
import com.intellij.psi.codeStyle.PreferStartMatchMatcherWrapper;
import com.intellij.util.text.Matcher;
import com.intellij.util.text.NameUtilCore;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class NameUtil {
    private static final int MAX_LENGTH = 40;

    private NameUtil() {
    }

    @NotNull
    public static List<String> nameToWordsLowerCase(@NotNull String name) {
        String[] words = NameUtilCore.nameToWords(name);
        ArrayList<String> list = new ArrayList<String>(words.length);
        for (String word : words) {
            list.add(Strings.toLowerCase(word));
        }
        return list;
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        return NameUtil.buildRegexp(pattern, exactPrefixLen, allowToUpper, allowToLower, false, false);
    }

    @NotNull
    public static String buildRegexp(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower, boolean lowerCaseWords, boolean forCompletion) {
        boolean endsWithSpace;
        int eol = pattern.indexOf(10);
        if (eol != -1) {
            pattern = pattern.substring(0, eol);
        }
        if (pattern.length() >= 40) {
            pattern = pattern.substring(0, 40);
        }
        @NonNls StringBuilder buffer = new StringBuilder();
        boolean bl = endsWithSpace = !forCompletion && Strings.endsWithChar(pattern, ' ');
        if (!forCompletion) {
            pattern = pattern.trim();
        }
        exactPrefixLen = Math.min(exactPrefixLen, pattern.length());
        boolean prevIsUppercase = false;
        if (exactPrefixLen > 0) {
            char c = pattern.charAt(exactPrefixLen - 1);
            prevIsUppercase = Character.isUpperCase(c) || Character.isDigit(c);
        }
        for (int i = 0; i != exactPrefixLen; ++i) {
            char c = pattern.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                buffer.append(c);
                continue;
            }
            buffer.append("\\").append(c);
        }
        if (exactPrefixLen == 0) {
            buffer.append("_*");
        }
        boolean firstIdentifierLetter = exactPrefixLen == 0;
        boolean lastIsUppercase = false;
        for (int i = exactPrefixLen; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            lastIsUppercase = false;
            if (Character.isLetterOrDigit(c)) {
                prevIsUppercase = false;
                if (Character.isUpperCase(c) || Character.isDigit(c)) {
                    prevIsUppercase = true;
                    lastIsUppercase = true;
                    buffer.append('(');
                    if (!firstIdentifierLetter) {
                        buffer.append("[a-z\\s0-9\\$]*");
                    }
                    buffer.append(c);
                    if (allowToLower) {
                        buffer.append('|');
                        buffer.append(Character.toLowerCase(c));
                    }
                    if (!firstIdentifierLetter) {
                        buffer.append("|[A-Za-z\\s0-9\\$]*[_-]+[");
                        buffer.append(c);
                        buffer.append(Character.toLowerCase(c));
                        buffer.append("]");
                    }
                    buffer.append(')');
                } else if (Character.isLowerCase(c) && allowToUpper) {
                    buffer.append('[');
                    buffer.append(c);
                    buffer.append(Character.toUpperCase(c));
                    buffer.append(']');
                    if (lowerCaseWords) {
                        buffer.append("([a-z\\s0-9\\$]*[-_]+)?");
                    }
                } else {
                    buffer.append(c);
                }
                firstIdentifierLetter = false;
                continue;
            }
            if (c == '*') {
                buffer.append(".*");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == '.') {
                if (!firstIdentifierLetter) {
                    buffer.append("[a-z\\s0-9\\$]*\\.");
                } else {
                    buffer.append("\\.");
                }
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ' ') {
                buffer.append("([a-z\\s0-9\\$_-]*[\\ _-]+)+");
                firstIdentifierLetter = true;
                continue;
            }
            if (c == ':' || prevIsUppercase) {
                buffer.append("[A-Za-z\\s0-9\\$]*");
            }
            firstIdentifierLetter = true;
            buffer.append("\\").append(c);
        }
        if (!endsWithSpace) {
            buffer.append(".*");
        } else if (lastIsUppercase) {
            buffer.append("[a-z\\s0-9\\$]*");
        }
        return buffer.toString();
    }

    @NotNull
    public static List<String> getSuggestionsByName(@NotNull String name, @NotNull String prefix, @NotNull String suffix, boolean upperCaseStyle, boolean preferLongerNames, boolean isArray) {
        ArrayList<String> answer = new ArrayList<String>();
        String[] words = NameUtilCore.nameToWords(name);
        for (int step = 0; step < words.length; ++step) {
            int wordCount = preferLongerNames ? words.length - step : step + 1;
            String startWord = words[words.length - wordCount];
            char c = startWord.charAt(0);
            if (c == '_' || !Character.isJavaIdentifierStart(c)) continue;
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, true) + suffix);
            answer.add(NameUtil.compoundSuggestion(prefix, upperCaseStyle, words, wordCount, startWord, c, isArray, false) + suffix);
        }
        return answer;
    }

    @NotNull
    private static String compoundSuggestion(@NotNull String prefix, boolean upperCaseStyle, String @NotNull [] words, int wordCount, @NotNull String startWord, char c, boolean isArray, boolean skip_) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(prefix);
        startWord = upperCaseStyle ? Strings.toUpperCase(startWord) : (prefix.isEmpty() || Strings.endsWithChar(prefix, '_') ? Strings.toLowerCase(startWord) : Character.toUpperCase(c) + startWord.substring(1));
        buffer.append(startWord);
        for (int i = words.length - wordCount + 1; i < words.length; ++i) {
            String word = words[i];
            String prevWord = words[i - 1];
            if (upperCaseStyle) {
                word = Strings.toUpperCase(word);
                if (prevWord.charAt(prevWord.length() - 1) != '_' && word.charAt(0) != '_') {
                    word = "_" + word;
                }
            } else {
                if (prevWord.charAt(prevWord.length() - 1) == '_') {
                    word = Strings.toLowerCase(word);
                }
                if (skip_) {
                    if (word.equals("_")) continue;
                    if (prevWord.equals("_")) {
                        word = Strings.capitalize(word);
                    }
                }
            }
            buffer.append(word);
        }
        String suggestion = buffer.toString();
        if (isArray) {
            suggestion = Strings.pluralize(suggestion);
            if (upperCaseStyle) {
                suggestion = Strings.toUpperCase(suggestion);
            }
        }
        return suggestion;
    }

    public static String @NotNull [] splitNameIntoWords(@NotNull String name) {
        return NameUtilCore.splitNameIntoWords(name);
    }

    public static String @NotNull [] nameToWords(@NotNull String name) {
        return NameUtilCore.nameToWords(name);
    }

    public static Matcher buildMatcher(@NotNull String pattern, int exactPrefixLen, boolean allowToUpper, boolean allowToLower) {
        MatchingCaseSensitivity options = !allowToLower && !allowToUpper ? MatchingCaseSensitivity.ALL : (exactPrefixLen > 0 ? MatchingCaseSensitivity.FIRST_LETTER : MatchingCaseSensitivity.NONE);
        return NameUtil.buildMatcher(pattern, options);
    }

    @NotNull
    public static MatcherBuilder buildMatcher(@NotNull String pattern) {
        return new MatcherBuilder(pattern);
    }

    @NotNull
    public static MinusculeMatcher buildMatcher(@NotNull String pattern, @NotNull MatchingCaseSensitivity options) {
        return NameUtil.buildMatcher(pattern).withCaseSensitivity(options).build();
    }

    public static MinusculeMatcher buildMatcherWithFallback(@NotNull String pattern, @NotNull String fallbackPattern, @NotNull MatchingCaseSensitivity options) {
        return pattern.equals(fallbackPattern) ? NameUtil.buildMatcher(pattern, options) : new MatcherWithFallback(NameUtil.buildMatcher(pattern, options), NameUtil.buildMatcher(fallbackPattern, options));
    }

    @NotNull
    public static String capitalizeAndUnderscore(@NotNull String name) {
        return NameUtil.splitWords(name, '_', Strings::toUpperCase);
    }

    @NotNull
    public static String splitWords(@NotNull String text, char separator, @NotNull Function<? super String, String> transformWord) {
        String[] words = NameUtilCore.nameToWords(text);
        boolean insertSeparator = false;
        StringBuilder buf = new StringBuilder();
        for (String word : words) {
            if (!Character.isLetterOrDigit(word.charAt(0))) {
                buf.append(separator);
                insertSeparator = false;
                continue;
            }
            if (insertSeparator) {
                buf.append(separator);
            } else {
                insertSeparator = true;
            }
            buf.append(transformWord.apply(word));
        }
        return buf.toString();
    }

    public static enum MatchingCaseSensitivity {
        NONE,
        FIRST_LETTER,
        ALL;

    }

    public static class MatcherBuilder {
        private final String pattern;
        private String separators = "";
        private MatchingCaseSensitivity caseSensitivity = MatchingCaseSensitivity.NONE;
        private boolean typoTolerant = false;
        private boolean preferStartMatches = false;
        private boolean allOccurrences = false;

        public MatcherBuilder(String pattern) {
            this.pattern = pattern;
        }

        public MatcherBuilder withCaseSensitivity(MatchingCaseSensitivity caseSensitivity) {
            this.caseSensitivity = caseSensitivity;
            return this;
        }

        public MatcherBuilder withSeparators(String separators) {
            this.separators = separators;
            return this;
        }

        public MatcherBuilder typoTolerant() {
            this.typoTolerant = true;
            return this;
        }

        public MatcherBuilder preferringStartMatches() {
            this.preferStartMatches = true;
            return this;
        }

        public MatcherBuilder allOccurrences() {
            this.allOccurrences = true;
            return this;
        }

        public MinusculeMatcher build() {
            MinusculeMatcher matcher;
            MinusculeMatcher minusculeMatcher = this.typoTolerant ? FixingLayoutTypoTolerantMatcher.create(this.pattern, this.caseSensitivity, this.separators) : (matcher = this.allOccurrences ? AllOccurrencesMatcher.create(this.pattern, this.caseSensitivity, this.separators) : new FixingLayoutMatcher(this.pattern, this.caseSensitivity, this.separators));
            if (this.preferStartMatches) {
                matcher = new PreferStartMatchMatcherWrapper(matcher);
            }
            matcher = PinyinMatcher.create(matcher);
            return matcher;
        }
    }
}

