/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.util.containers.FList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MatcherWithFallback
extends MinusculeMatcher {
    @NotNull
    private final MinusculeMatcher myMainMatcher;
    @Nullable
    private final MinusculeMatcher myFallbackMatcher;

    MatcherWithFallback(@NotNull MinusculeMatcher mainMatcher, @Nullable MinusculeMatcher fallbackMatcher) {
        this.myMainMatcher = mainMatcher;
        this.myFallbackMatcher = fallbackMatcher;
    }

    @Override
    @NotNull
    public String getPattern() {
        return this.myMainMatcher.getPattern();
    }

    @Override
    public boolean matches(@NotNull String name) {
        return this.myMainMatcher.matches(name) || this.myFallbackMatcher != null && this.myFallbackMatcher.matches(name);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        FList<TextRange> mainRanges = this.myMainMatcher.matchingFragments(name);
        boolean useMainRanges = mainRanges != null && !mainRanges.isEmpty() || this.myFallbackMatcher == null;
        return useMainRanges ? mainRanges : this.myFallbackMatcher.matchingFragments(name);
    }

    @Override
    public int matchingDegree(@NotNull String name, boolean valueStartCaseMatch) {
        FList<TextRange> mainRanges = this.myMainMatcher.matchingFragments(name);
        boolean useMainRanges = mainRanges != null && !mainRanges.isEmpty() || this.myFallbackMatcher == null;
        return useMainRanges ? this.myMainMatcher.matchingDegree(name, valueStartCaseMatch, mainRanges) : this.myFallbackMatcher.matchingDegree(name, valueStartCaseMatch);
    }

    @Override
    public int matchingDegree(@NotNull String name, boolean valueStartCaseMatch, @Nullable FList<? extends TextRange> fragments) {
        FList<TextRange> mainRanges = this.myMainMatcher.matchingFragments(name);
        boolean useMainRanges = mainRanges != null && !mainRanges.isEmpty() || this.myFallbackMatcher == null;
        return useMainRanges ? this.myMainMatcher.matchingDegree(name, valueStartCaseMatch, fragments) : this.myFallbackMatcher.matchingDegree(name, valueStartCaseMatch, fragments);
    }

    public String toString() {
        return "MatcherWithFallback{myMainMatcher=" + this.myMainMatcher + ", myFallbackMatcher=" + this.myFallbackMatcher + '}';
    }
}

