/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.FixingLayoutMatcher;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.util.containers.FList;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AllOccurrencesMatcher
extends MinusculeMatcher {
    private final MinusculeMatcher delegate;

    private AllOccurrencesMatcher(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        this.delegate = new FixingLayoutMatcher(pattern, options, hardSeparators);
    }

    @Override
    @NotNull
    public String getPattern() {
        return this.delegate.getPattern();
    }

    @Override
    public int matchingDegree(@NotNull String name, boolean valueStartCaseMatch, @Nullable FList<? extends TextRange> fragments) {
        return this.delegate.matchingDegree(name, valueStartCaseMatch, fragments);
    }

    @Override
    @Nullable
    public FList<TextRange> matchingFragments(@NotNull String name) {
        FList<TextRange> match = this.delegate.matchingFragments(name);
        if (match != null && !match.isEmpty()) {
            ArrayList<FList<TextRange>> allMatchesReversed = new ArrayList<FList<TextRange>>();
            int lastOffset = 0;
            while (match != null && !match.isEmpty()) {
                FList<TextRange> reversedWithAbsoluteOffsets = FList.emptyList();
                for (TextRange r : match) {
                    reversedWithAbsoluteOffsets = reversedWithAbsoluteOffsets.prepend(r.shiftRight(lastOffset));
                }
                allMatchesReversed.add(reversedWithAbsoluteOffsets);
                lastOffset = ((TextRange)reversedWithAbsoluteOffsets.get(0)).getEndOffset();
                match = this.delegate.matchingFragments(name.substring(lastOffset));
            }
            match = FList.emptyList();
            for (int i = allMatchesReversed.size() - 1; i >= 0; --i) {
                for (TextRange range : (FList)allMatchesReversed.get(i)) {
                    match = match.prepend(range);
                }
            }
        }
        return match;
    }

    public String toString() {
        return "AllOccurrencesMatcher{delegate=" + this.delegate + '}';
    }

    public static MinusculeMatcher create(@NotNull String pattern, @NotNull NameUtil.MatchingCaseSensitivity options, String hardSeparators) {
        return new AllOccurrencesMatcher(pattern, options, hardSeparators);
    }
}

