/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiInvalidElementAccessException;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.WalkingState;
import org.jetbrains.annotations.NotNull;

public abstract class PsiWalkingState
extends WalkingState<PsiElement> {
    private static final Logger LOG = Logger.getInstance(PsiWalkingState.class);
    private final PsiElementVisitor myVisitor;

    protected PsiWalkingState(@NotNull PsiElementVisitor delegate) {
        this(delegate, PsiTreeGuide.instance);
    }

    protected PsiWalkingState(@NotNull PsiElementVisitor delegate, @NotNull WalkingState.TreeGuide<PsiElement> guide) {
        super(guide);
        this.myVisitor = delegate;
    }

    @Override
    public void visit(@NotNull PsiElement element) {
        element.accept(this.myVisitor);
    }

    @Override
    public void elementStarted(@NotNull PsiElement element) {
        if (!this.startedWalking && element instanceof PsiCompiledElement) {
            LOG.error(element + "; of class:" + element.getClass() + "; Do not use walking visitor inside compiled PSI since getNextSibling() is too slow there");
        }
        super.elementStarted(element);
    }

    private static class PsiTreeGuide
    implements WalkingState.TreeGuide<PsiElement> {
        private static final PsiTreeGuide instance = new PsiTreeGuide();

        private PsiTreeGuide() {
        }

        @Override
        public PsiElement getNextSibling(@NotNull PsiElement element) {
            return PsiTreeGuide.checkSanity(element, element.getNextSibling());
        }

        private static PsiElement checkSanity(PsiElement element, PsiElement sibling) {
            if (sibling == PsiUtilCore.NULL_PSI_ELEMENT) {
                throw new PsiInvalidElementAccessException(element, "Sibling of " + element + " is NULL_PSI_ELEMENT");
            }
            return sibling;
        }

        @Override
        public PsiElement getPrevSibling(@NotNull PsiElement element) {
            return PsiTreeGuide.checkSanity(element, element.getPrevSibling());
        }

        @Override
        public PsiElement getFirstChild(@NotNull PsiElement element) {
            return element.getFirstChild();
        }

        @Override
        public PsiElement getParent(@NotNull PsiElement element) {
            return element.getParent();
        }
    }
}

