/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.PluginAware;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.RequiredElement;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.ElementPatternBean;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReferenceProviderBean
implements KeyedLazyInstance<PsiReferenceProviderBean>,
PluginAware {
    public static final ExtensionPointName<PsiReferenceProviderBean> EP_NAME = new ExtensionPointName("com.intellij.psi.referenceProvider");
    @Attribute(value="language")
    public String language = Language.ANY.getID();
    @Attribute(value="providerClass")
    @RequiredElement
    public String className;
    @Tag(value="description")
    public String description;
    @Property(surroundWithTag=false)
    @XCollection
    @RequiredElement
    public ElementPatternBean[] patterns;
    private PluginDescriptor pluginDescriptor;

    public String getDescription() {
        return this.description;
    }

    public PsiReferenceProvider instantiate() {
        try {
            return (PsiReferenceProvider)ApplicationManager.getApplication().instantiateClass(this.className, this.pluginDescriptor);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Logger.getInstance(PsiReferenceProviderBean.class).error(e);
            return null;
        }
    }

    @Override
    @Transient
    public void setPluginDescriptor(@NotNull PluginDescriptor pluginDescriptor) {
        this.pluginDescriptor = pluginDescriptor;
    }

    @Nullable
    public ElementPattern<PsiElement> createElementPattern() {
        if (this.patterns.length > 1) {
            List<ElementPattern> result = new ArrayList(this.patterns.length);
            for (ElementPatternBean t : this.patterns) {
                ElementPattern<PsiElement> o = t.compilePattern();
                if (o == null) continue;
                result.add(o);
            }
            result = result.isEmpty() ? Collections.emptyList() : result;
            return StandardPatterns.or(result.toArray(new ElementPattern[0]));
        }
        if (this.patterns.length == 1) {
            return this.patterns[0].compilePattern();
        }
        Logger.getInstance(PsiReferenceProviderBean.class).error("At least one pattern should be specified");
        return null;
    }

    @Override
    @NotNull
    public String getKey() {
        return this.language;
    }

    @Override
    @NotNull
    public PsiReferenceProviderBean getInstance() {
        return this;
    }
}

