/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PsiRecursiveElementVisitor
extends PsiElementVisitor
implements PsiRecursiveVisitor {
    private final boolean myVisitAllFileRoots;

    protected PsiRecursiveElementVisitor() {
        this(false);
    }

    protected PsiRecursiveElementVisitor(boolean visitAllFileRoots) {
        this.myVisitAllFileRoots = visitAllFileRoots;
    }

    @Override
    public void visitElement(@NotNull PsiElement element) {
        ProgressIndicatorProvider.checkCanceled();
        element.acceptChildren(this);
    }

    @Override
    public void visitFile(@NotNull PsiFile file2) {
        FileViewProvider viewProvider;
        List<PsiFile> allFiles;
        if (this.myVisitAllFileRoots && (allFiles = (viewProvider = file2.getViewProvider()).getAllFiles()).size() > 1 && file2 == viewProvider.getPsi(viewProvider.getBaseLanguage())) {
            for (PsiFile lFile : allFiles) {
                ProgressIndicatorProvider.checkCanceled();
                lFile.acceptChildren(this);
            }
            return;
        }
        super.visitFile(file2);
    }
}

