/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.impl;

import com.intellij.pom.PomManager;
import com.intellij.pom.PomTransaction;
import com.intellij.pom.event.PomModelEvent;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class PomTransactionBase
implements PomTransaction {
    private final PsiElement myScope;
    private final PomModelEvent myAccumulatedEvent;

    public PomTransactionBase(@NotNull PsiElement scope) {
        this.myScope = scope;
        this.myAccumulatedEvent = new PomModelEvent(PomManager.getModel(scope.getProject()), null);
    }

    @Override
    @NotNull
    public PomModelEvent getAccumulatedEvent() {
        return this.myAccumulatedEvent;
    }

    @Override
    public void run() throws IncorrectOperationException {
        this.myAccumulatedEvent.merge(this.runInner());
    }

    @NotNull
    public abstract PomModelEvent runInner() throws IncorrectOperationException;

    @Override
    @NotNull
    public PsiElement getChangeScope() {
        return this.myScope;
    }
}

