/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.event;

import com.intellij.pom.PomModel;
import com.intellij.pom.PomModelAspect;
import com.intellij.pom.event.PomChangeSet;
import java.util.Collections;
import java.util.EventObject;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PomModelEvent
extends EventObject {
    private PomChangeSet myChangeSet;

    @ApiStatus.Internal
    public PomModelEvent(@NotNull PomModel source, @Nullable PomChangeSet changeSet) {
        super(source);
        this.myChangeSet = changeSet;
    }

    @NotNull
    public Set<PomModelAspect> getChangedAspects() {
        if (this.myChangeSet != null) {
            return Collections.singleton(this.myChangeSet.getAspect());
        }
        return Collections.emptySet();
    }

    public PomChangeSet getChangeSet(@NotNull PomModelAspect aspect) {
        return this.myChangeSet == null || !aspect.equals(this.myChangeSet.getAspect()) ? null : this.myChangeSet;
    }

    public void merge(@NotNull PomModelEvent event) {
        if (event.myChangeSet != null && this.myChangeSet != null) {
            this.myChangeSet.merge(event.myChangeSet);
        } else if (this.myChangeSet == null) {
            this.myChangeSet = event.myChangeSet;
        }
    }

    @Override
    public PomModel getSource() {
        return (PomModel)super.getSource();
    }

    public void beforeNestedTransaction() {
        if (this.myChangeSet != null) {
            this.myChangeSet.beforeNestedTransaction();
        }
    }
}

