/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.patterns;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PatternConditionPlus;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiNamePatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.TreeElementPattern;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.TokenType;
import com.intellij.psi.meta.PsiMetaData;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class PsiElementPattern<T extends PsiElement, Self extends PsiElementPattern<T, Self>>
extends TreeElementPattern<PsiElement, T, Self> {
    protected PsiElementPattern(Class<T> aClass) {
        super(aClass);
    }

    protected PsiElementPattern(@NotNull InitialPatternCondition<T> condition) {
        super(condition);
    }

    protected PsiElement[] getChildren(@NotNull PsiElement element) {
        return element.getChildren();
    }

    @Override
    protected PsiElement getParent(@NotNull PsiElement element) {
        if (element instanceof PsiFile && InjectedLanguageManager.getInstance(element.getProject()).isInjectedFragment((PsiFile)element)) {
            return element.getParent();
        }
        return element.getContext();
    }

    @NotNull
    public Self withElementType(IElementType type) {
        return this.withElementType((ElementPattern<IElementType>)PlatformPatterns.elementType().equalTo(type));
    }

    @NotNull
    public Self withElementType(TokenSet type) {
        return this.withElementType(PlatformPatterns.elementType().tokenSet(type));
    }

    @NotNull
    public Self afterLeaf(String ... withText) {
        return this.afterLeaf((ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withText(StandardPatterns.string().oneOf(withText)));
    }

    @NotNull
    public Self afterLeaf(@NotNull ElementPattern<? extends PsiElement> pattern) {
        return this.afterLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), pattern);
    }

    @NotNull
    public Self beforeLeaf(String ... withText) {
        return this.beforeLeaf((ElementPattern<? extends PsiElement>)PlatformPatterns.psiElement().withText(StandardPatterns.string().oneOf(withText)));
    }

    @NotNull
    public Self beforeLeaf(@NotNull ElementPattern<? extends PsiElement> pattern) {
        return this.beforeLeafSkipping((ElementPattern)PlatformPatterns.psiElement().whitespaceCommentEmptyOrError(), pattern);
    }

    @NotNull
    public Self whitespace() {
        return this.withElementType(TokenType.WHITE_SPACE);
    }

    @NotNull
    public Self whitespaceCommentOrError() {
        return (Self)((PsiElementPattern)this.andOr(new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiComment.class), PlatformPatterns.psiElement(PsiErrorElement.class)}));
    }

    @NotNull
    public Self whitespaceCommentEmptyOrError() {
        return (Self)((PsiElementPattern)this.andOr(new ElementPattern[]{PlatformPatterns.psiElement().whitespace(), PlatformPatterns.psiElement(PsiComment.class), PlatformPatterns.psiElement(PsiErrorElement.class), PlatformPatterns.psiElement().withText("")}));
    }

    @NotNull
    public Self withFirstNonWhitespaceChild(@NotNull ElementPattern<? extends PsiElement> pattern) {
        return (Self)((PsiElementPattern)this.withChildren(StandardPatterns.collection(PsiElement.class).filter(StandardPatterns.not(PlatformPatterns.psiElement().whitespace()), StandardPatterns.collection(PsiElement.class).first(pattern))));
    }

    @NotNull
    public Self withReference(final Class<? extends PsiReference> referenceClass) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withReference"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                for (PsiReference reference : t.getReferences()) {
                    if (!referenceClass.isInstance(reference)) continue;
                    return true;
                }
                return false;
            }
        }));
    }

    @NotNull
    public Self inFile(final @NotNull ElementPattern<? extends PsiFile> filePattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("inFile"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return filePattern.accepts(t.getContainingFile(), context);
            }
        }));
    }

    @NotNull
    public Self inVirtualFile(final @NotNull ElementPattern<? extends VirtualFile> filePattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("inVirtualFile"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return filePattern.accepts(t.getContainingFile().getViewProvider().getVirtualFile(), context);
            }
        }));
    }

    @Override
    @NotNull
    public Self equalTo(@NotNull T o) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("equalTo", (PsiElement)o){
            final /* synthetic */ PsiElement val$o;
            {
                this.val$o = psiElement;
                super(debugMethodName);
            }

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return t.getManager().areElementsEquivalent((PsiElement)t, this.val$o);
            }
        }));
    }

    @NotNull
    public Self withElementType(final ElementPattern<IElementType> pattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withElementType"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                ASTNode node = t.getNode();
                return node != null && pattern.accepts(node.getElementType());
            }
        }));
    }

    @NotNull
    public Self withText(@NotNull @NonNls String text) {
        return this.withText((ElementPattern)StandardPatterns.string().equalTo(text));
    }

    @NotNull
    public Self withoutText(@NotNull String text) {
        return this.withoutText((ElementPattern)StandardPatterns.string().equalTo(text));
    }

    @NotNull
    public Self withName(@NotNull @NonNls String name) {
        return this.withName((ElementPattern<String>)StandardPatterns.string().equalTo(name));
    }

    @NotNull
    public Self withName(String ... names) {
        return this.withName(StandardPatterns.string().oneOf(names));
    }

    @NotNull
    public Self withName(@NotNull ElementPattern<String> name) {
        return (Self)((PsiElementPattern)this.with(new PsiNamePatternCondition("withName", name)));
    }

    @NotNull
    public Self afterLeafSkipping(final @NotNull ElementPattern skip, final @NotNull ElementPattern pattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("afterLeafSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object element = t;
                while ((element = PsiTreeUtil.prevLeaf(element)) != null && element.getTextLength() == 0 || skip.accepts(element, context)) {
                }
                return pattern.accepts(element, context);
            }
        }));
    }

    @NotNull
    public Self beforeLeafSkipping(final @NotNull ElementPattern skip, final @NotNull ElementPattern pattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("beforeLeafSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                Object element = t;
                while ((element = PsiTreeUtil.nextLeaf(element)) != null && element.getTextLength() == 0 || skip.accepts(element, context)) {
                }
                return pattern.accepts(element, context);
            }
        }));
    }

    @NotNull
    public Self atStartOf(final @NotNull ElementPattern pattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("atStartOf"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                for (Object element = t; element != null; element = element.getContext()) {
                    if (!pattern.accepts(element, context)) continue;
                    return element.getTextRange().getStartOffset() == t.getTextRange().getStartOffset();
                }
                return false;
            }
        }));
    }

    @NotNull
    public Self withTextLength(@NotNull ElementPattern lengthPattern) {
        return (Self)((PsiElementPattern)this.with(new PatternConditionPlus<T, Integer>("withTextLength", lengthPattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<? super Integer, ? super ProcessingContext> integerProcessingContextPairProcessor) {
                return integerProcessingContextPairProcessor.process((Integer)t.getTextLength(), context);
            }
        }));
    }

    @NotNull
    public Self notEmpty() {
        return this.withTextLengthLongerThan(0);
    }

    @NotNull
    public Self withTextLengthLongerThan(final int minLength) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withTextLengthLongerThan"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return t.getTextLength() > minLength;
            }
        }));
    }

    @NotNull
    public Self withText(@NotNull ElementPattern text) {
        return (Self)((PsiElementPattern)this.with(this._withText(text)));
    }

    @NotNull
    private PatternCondition<T> _withText(ElementPattern pattern) {
        return new PatternConditionPlus<T, String>("_withText", pattern){

            @Override
            public boolean processValues(T t, ProcessingContext context, PairProcessor<? super String, ? super ProcessingContext> processor) {
                return processor.process(t.getText(), context);
            }
        };
    }

    @NotNull
    public Self withoutText(@NotNull ElementPattern text) {
        return (Self)((PsiElementPattern)this.without(this._withText(text)));
    }

    @NotNull
    public Self withLanguage(final @NotNull Language language) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withLanguage"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return t.getLanguage().equals(language);
            }
        }));
    }

    @NotNull
    public Self withMetaData(final ElementPattern<? extends PsiMetaData> metaDataPattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withMetaData"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return t instanceof PsiMetaOwner && metaDataPattern.accepts(((PsiMetaOwner)t).getMetaData(), context);
            }
        }));
    }

    @NotNull
    public Self referencing(final ElementPattern<? extends PsiElement> targetPattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("referencing"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                PsiReference[] references;
                for (PsiReference reference : references = t.getReferences()) {
                    if (targetPattern.accepts(reference.resolve(), context)) {
                        return true;
                    }
                    if (!(reference instanceof PsiPolyVariantReference)) continue;
                    for (ResolveResult result : ((PsiPolyVariantReference)reference).multiResolve(true)) {
                        if (!targetPattern.accepts(result.getElement(), context)) continue;
                        return true;
                    }
                }
                return false;
            }
        }));
    }

    @NotNull
    public Self compiled() {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("compiled"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return t instanceof PsiCompiledElement;
            }
        }));
    }

    @NotNull
    public Self withTreeParent(final ElementPattern<? extends PsiElement> ancestor) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withTreeParent"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                return ancestor.accepts(t.getParent(), context);
            }
        }));
    }

    @NotNull
    public Self insideStarting(final ElementPattern<? extends PsiElement> ancestor) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<PsiElement>("insideStarting"){

            @Override
            public boolean accepts(@NotNull PsiElement start, ProcessingContext context) {
                PsiElement element = PsiElementPattern.this.getParent(start);
                TextRange range = start.getTextRange();
                if (range == null) {
                    return false;
                }
                int startOffset = range.getStartOffset();
                while (element != null && element.getTextRange() != null && element.getTextRange().getStartOffset() == startOffset) {
                    if (ancestor.accepts(element, context)) {
                        return true;
                    }
                    element = PsiElementPattern.this.getParent(element);
                }
                return false;
            }
        }));
    }

    @NotNull
    public Self withLastChildSkipping(final @NotNull ElementPattern skip, final @NotNull ElementPattern pattern) {
        return (Self)((PsiElementPattern)this.with(new PatternCondition<T>("withLastChildSkipping"){

            @Override
            public boolean accepts(@NotNull T t, ProcessingContext context) {
                PsiElement last;
                for (last = t.getLastChild(); last != null && skip.accepts(last); last = last.getPrevSibling()) {
                }
                return pattern.accepts(last);
            }
        }));
    }

    public static class Capture<T extends PsiElement>
    extends PsiElementPattern<T, Capture<T>> {
        protected Capture(Class<T> aClass) {
            super(aClass);
        }

        protected Capture(@NotNull InitialPatternCondition<T> condition) {
            super(condition);
        }
    }
}

