/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.SavingRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VFileEvent {
    private final boolean myIsFromRefresh;
    private final Object myRequestor;
    private String myCachedPath;

    public VFileEvent(Object requestor, boolean isFromRefresh) {
        this.myRequestor = requestor;
        this.myIsFromRefresh = isFromRefresh;
    }

    public boolean isFromRefresh() {
        return this.myIsFromRefresh;
    }

    public boolean isFromSave() {
        return this.myRequestor instanceof SavingRequestor;
    }

    public Object getRequestor() {
        return this.myRequestor;
    }

    @NotNull
    public String getPath() {
        String path = this.myCachedPath;
        if (path == null) {
            this.myCachedPath = path = this.computePath();
        }
        return path;
    }

    @NotNull
    protected abstract String computePath();

    @Nullable
    public abstract VirtualFile getFile();

    @NotNull
    public abstract VirtualFileSystem getFileSystem();

    public abstract boolean isValid();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);
}

