/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.ChildInfo;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VFileCreateEvent
extends VFileEvent {
    @NotNull
    private final VirtualFile myParent;
    private final boolean myDirectory;
    private final FileAttributes myAttributes;
    private final String mySymlinkTarget;
    private final ChildInfo[] myChildren;
    private final int myChildNameId;
    private VirtualFile myCreatedFile;

    @ApiStatus.Internal
    public VFileCreateEvent(Object requestor, @NotNull VirtualFile parent, @NotNull String childName, boolean isDirectory, @Nullable(value="null means should read from the created file") @Nullable(value="null means should read from the created file") FileAttributes attributes, @Nullable String symlinkTarget, boolean isFromRefresh, ChildInfo @Nullable(value="null means children not available (e.g. the created file is not a directory) or unknown") [] children2) {
        super(requestor, isFromRefresh);
        this.myParent = parent;
        this.myDirectory = isDirectory;
        this.myAttributes = attributes;
        this.mySymlinkTarget = symlinkTarget;
        this.myChildren = children2;
        this.myChildNameId = VirtualFileManager.getInstance().storeName(childName);
    }

    @NotNull
    public String getChildName() {
        return VirtualFileManager.getInstance().getVFileName(this.myChildNameId).toString();
    }

    public boolean isDirectory() {
        return this.myDirectory;
    }

    @NotNull
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Nullable
    public FileAttributes getAttributes() {
        return this.myAttributes;
    }

    @Nullable
    public String getSymlinkTarget() {
        return this.mySymlinkTarget;
    }

    public boolean isEmptyDirectory() {
        return this.isDirectory() && this.myChildren != null && this.myChildren.length == 0;
    }

    @Override
    @NotNull
    protected String computePath() {
        String parentPath = this.myParent.getPath();
        return StringUtil.endsWithChar(parentPath, '/') ? parentPath + this.getChildName() : parentPath + "/" + this.getChildName();
    }

    @Override
    public VirtualFile getFile() {
        VirtualFile createdFile = this.myCreatedFile;
        if (createdFile == null && this.myParent.isValid()) {
            this.myCreatedFile = createdFile = this.myParent.findChild(this.getChildName());
        }
        return createdFile;
    }

    public ChildInfo @Nullable(value="null means children not available (e.g. the created file is not a directory) or unknown") [] getChildren() {
        return this.myChildren;
    }

    public void resetCache() {
        this.myCreatedFile = null;
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        return this.myParent.getFileSystem();
    }

    @Override
    public boolean isValid() {
        return this.myParent.isValid() && this.myParent.findChild(this.getChildName()) == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileCreateEvent event = (VFileCreateEvent)o;
        return this.myDirectory == event.myDirectory && this.getChildName().equals(event.getChildName()) && this.myParent.equals(event.myParent);
    }

    @Override
    public int hashCode() {
        int result = this.myParent.hashCode();
        result = 31 * result + (this.myDirectory ? 1 : 0);
        result = 31 * result + this.getChildName().hashCode();
        return result;
    }

    public String toString() {
        String kind = this.myDirectory ? (this.isEmptyDirectory() ? "(empty) " : "") + "dir " : "file ";
        return "VfsEvent[create " + kind + "'" + this.myParent.getUrl() + "/" + this.getChildName() + "']" + (this.myChildren == null ? "" : " with " + this.myChildren.length + " children");
    }

    public int getChildNameId() {
        return this.myChildNameId;
    }
}

