/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.impl.ArchiveHandler;
import com.intellij.util.ThrowableConsumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import org.jetbrains.annotations.NotNull;

public abstract class TempCopyArchiveHandler
extends ArchiveHandler {
    protected TempCopyArchiveHandler(@NotNull String path) {
        super(path);
    }

    protected abstract String getTempDir();

    @Override
    public void clearCaches() {
        super.clearCaches();
        this.removeTempCopy();
    }

    private void removeTempCopy() {
        FileUtil.delete(this.getTempFile());
    }

    @NotNull
    protected File getTempCopy(@NotNull ThrowableConsumer<? super File, ? extends IOException> initializer) throws IOException {
        File file2 = this.getFile();
        File copy = this.getTempFile();
        if (!copy.exists() || copy.lastModified() != file2.lastModified()) {
            FileUtil.createParentDirs(copy);
            initializer.consume((Object)copy);
            Files.setLastModifiedTime(copy.toPath(), Files.getLastModifiedTime(file2.toPath(), new LinkOption[0]));
        }
        return copy;
    }

    @NotNull
    private File getTempFile() {
        File file2 = this.getFile();
        String hash = Integer.toHexString(file2.getPath().hashCode());
        return new File(PathManager.getSystemPath() + '/' + this.getTempDir() + '/' + file2.getName() + '_' + hash);
    }
}

