/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.BufferExposingByteArrayInputStream;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.impl.AddonlyKeylessHash;
import com.intellij.reference.SoftReference;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Reference;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ArchiveHandler {
    public static final long DEFAULT_LENGTH = 0L;
    public static final long DEFAULT_TIMESTAMP = -1L;
    public static final FileAttributes DIRECTORY_ATTRIBUTES = new FileAttributes(true, false, false, false, 0L, -1L, false, FileAttributes.CaseSensitivity.SENSITIVE);
    private volatile File myPath;
    private final Object myLock = new Object();
    private volatile Reference<Map<String, EntryInfo>> myEntries = new SoftReference<Object>(null);
    private volatile Reference<AddonlyKeylessHash<EntryInfo, Object>> myChildrenEntries = new SoftReference<Object>(null);
    private boolean myCorrupted;
    private static final AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object> ourKeyValueMapper = new AddonlyKeylessHash.KeyValueMapper<EntryInfo, Object>(){

        @Override
        public int hash(EntryInfo info) {
            return System.identityHashCode(info);
        }

        @Override
        public EntryInfo key(Object o) {
            if (o instanceof EntryInfo) {
                return ((EntryInfo)o).parent;
            }
            return ((EntryInfo[])o)[0].parent;
        }
    };

    protected ArchiveHandler(@NotNull String path) {
        this.myPath = new File(path);
    }

    @NotNull
    public File getFile() {
        return this.myPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setFile(@NotNull File path) {
        Object object = this.myLock;
        synchronized (object) {
            assert (this.myEntries.get() == null && this.myChildrenEntries.get() == null && !this.myCorrupted) : "Archive already opened";
            this.myPath = path;
        }
    }

    @Nullable
    public FileAttributes getAttributes(@NotNull String relativePath) {
        if (!relativePath.isEmpty()) {
            EntryInfo e = this.getEntryInfo(relativePath);
            if (e != null) {
                return new FileAttributes(e.isDirectory, false, false, false, e.length, e.timestamp, false, FileAttributes.CaseSensitivity.SENSITIVE);
            }
        } else if (Files.exists(this.myPath.toPath(), new LinkOption[0])) {
            return DIRECTORY_ATTRIBUTES;
        }
        return null;
    }

    public String @NotNull [] list(@NotNull String relativePath) {
        EntryInfo entry = this.getEntryInfo(relativePath);
        if (entry == null || !entry.isDirectory) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        AddonlyKeylessHash<EntryInfo, Object> result = this.getParentChildrenMap();
        Object o = result.get(entry);
        if (o == null) {
            return ArrayUtil.EMPTY_STRING_ARRAY;
        }
        if (o instanceof EntryInfo) {
            return new String[]{((EntryInfo)o).shortName.toString()};
        }
        EntryInfo[] infos = (EntryInfo[])o;
        String[] names = new String[infos.length];
        for (int i = 0; i < infos.length; ++i) {
            names[i] = infos[i].shortName.toString();
        }
        return names;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AddonlyKeylessHash<EntryInfo, Object> getParentChildrenMap() {
        AddonlyKeylessHash<EntryInfo, Object> map = SoftReference.dereference(this.myChildrenEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = SoftReference.dereference(this.myChildrenEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = new AddonlyKeylessHash<EntryInfo, Object>(ourKeyValueMapper);
                    } else {
                        try {
                            map = this.createParentChildrenMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, e);
                            map = new AddonlyKeylessHash<EntryInfo, Object>(ourKeyValueMapper);
                        }
                    }
                    this.myChildrenEntries = new SoftReference<AddonlyKeylessHash<EntryInfo, Object>>(map);
                }
            }
        }
        return map;
    }

    private AddonlyKeylessHash<EntryInfo, Object> createParentChildrenMap() {
        HashMap map = new HashMap();
        for (EntryInfo info : this.getEntriesMap().values()) {
            if (info.isDirectory && !map.containsKey(info)) {
                map.put(info, new SmartList());
            }
            if (info.parent == null) continue;
            SmartList<EntryInfo> parentChildren = (SmartList<EntryInfo>)map.get(info.parent);
            if (parentChildren == null) {
                parentChildren = new SmartList<EntryInfo>();
                map.put(info.parent, parentChildren);
            }
            parentChildren.add(info);
        }
        AddonlyKeylessHash<EntryInfo, Object> result = new AddonlyKeylessHash<EntryInfo, Object>(map.size(), ourKeyValueMapper);
        for (List children2 : map.values()) {
            int numberOfChildren = children2.size();
            if (numberOfChildren == 1) {
                result.add(children2.get(0));
                continue;
            }
            if (numberOfChildren <= 1) continue;
            result.add(children2.toArray(new EntryInfo[numberOfChildren]));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.OverrideOnly
    public void clearCaches() {
        Object object = this.myLock;
        synchronized (object) {
            this.myEntries.clear();
            this.myChildrenEntries.clear();
            this.myCorrupted = false;
        }
    }

    @Nullable
    protected EntryInfo getEntryInfo(@NotNull String relativePath) {
        return this.getEntriesMap().get(relativePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected Map<String, EntryInfo> getEntriesMap() {
        Map<String, EntryInfo> map = SoftReference.dereference(this.myEntries);
        if (map == null) {
            Object object = this.myLock;
            synchronized (object) {
                map = SoftReference.dereference(this.myEntries);
                if (map == null) {
                    if (this.myCorrupted) {
                        map = Collections.emptyMap();
                    } else {
                        try {
                            map = this.createEntriesMap();
                        }
                        catch (Exception e) {
                            this.myCorrupted = true;
                            Logger.getInstance(this.getClass()).warn(e.getMessage() + ": " + this.myPath, e);
                            map = Collections.emptyMap();
                        }
                    }
                    this.myEntries = new SoftReference<Map<String, EntryInfo>>(map);
                    this.myChildrenEntries = new SoftReference<Object>(null);
                }
            }
        }
        return map;
    }

    @NotNull
    protected abstract Map<String, EntryInfo> createEntriesMap() throws IOException;

    @NotNull
    protected EntryInfo createRootEntry() {
        return new EntryInfo("", true, 0L, -1L, null);
    }

    protected final void processEntry(@NotNull Map<String, EntryInfo> map, @NotNull String entryName, @Nullable BiFunction<@NotNull EntryInfo, @NotNull String, ? extends @NotNull EntryInfo> entryFun) {
        this.processEntry(map, null, entryName, entryFun);
    }

    protected final void processEntry(@NotNull Map<String, EntryInfo> map, @Nullable Logger logger, @NotNull String entryName, @Nullable BiFunction<@NotNull EntryInfo, @NotNull String, ? extends @NotNull EntryInfo> entryFun) {
        String normalizedName = this.normalizeName(entryName);
        if (normalizedName.isEmpty() || normalizedName.contains("..") && ArrayUtil.contains("..", normalizedName.split("/"))) {
            if (logger != null) {
                logger.trace("invalid entry: " + this.getFile() + "!/" + entryName);
            }
            return;
        }
        if (entryFun == null) {
            this.directoryEntry(map, logger, normalizedName);
            return;
        }
        EntryInfo existing = map.get(normalizedName);
        if (existing != null) {
            if (logger != null) {
                logger.trace("duplicate entry: " + this.getFile() + "!/" + normalizedName);
            }
            return;
        }
        Pair<String, String> path = ArchiveHandler.split(normalizedName);
        EntryInfo parent = this.directoryEntry(map, logger, (String)path.first);
        map.put(normalizedName, entryFun.apply(parent, (String)path.second));
    }

    @NotNull
    protected String normalizeName(@NotNull String entryName) {
        return StringUtil.trimTrailing(StringUtil.trimLeading(FileUtil.normalize(entryName), '/'), '/');
    }

    private EntryInfo directoryEntry(Map<String, EntryInfo> map, @Nullable Logger logger, String normalizedName) {
        EntryInfo entry = map.get(normalizedName);
        if (entry == null || !entry.isDirectory) {
            if (logger != null && entry != null) {
                logger.trace("duplicate entry: " + this.getFile() + "!/" + normalizedName);
            }
            if (normalizedName.isEmpty()) {
                entry = this.createRootEntry();
            } else {
                Pair<String, String> path = ArchiveHandler.split(normalizedName);
                EntryInfo parent = this.directoryEntry(map, logger, (String)path.first);
                entry = new EntryInfo((CharSequence)path.second, true, 0L, -1L, parent);
            }
            map.put(normalizedName, entry);
        }
        return entry;
    }

    private static Pair<String, String> split(String normalizedName) {
        int p = normalizedName.lastIndexOf(47);
        String parentPath = p > 0 ? normalizedName.substring(0, p) : "";
        String shortName = p > 0 ? normalizedName.substring(p + 1) : normalizedName;
        return new Pair((Object)parentPath, (Object)shortName);
    }

    public abstract byte @NotNull [] contentsToByteArray(@NotNull String var1) throws IOException;

    @NotNull
    public InputStream getInputStream(@NotNull String relativePath) throws IOException {
        return new BufferExposingByteArrayInputStream(this.contentsToByteArray(relativePath));
    }

    protected static class EntryInfo {
        public final EntryInfo parent;
        public final CharSequence shortName;
        public final boolean isDirectory;
        public final long length;
        public final long timestamp;

        public EntryInfo(@NotNull CharSequence shortName, boolean isDirectory, long length, long timestamp, @Nullable EntryInfo parent) {
            this.parent = parent;
            this.shortName = shortName;
            this.isDirectory = isDirectory;
            this.length = length;
            this.timestamp = timestamp;
        }
    }
}

