/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.util.KeyedLazyInstance;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VirtualFileSystem {
    public static final ExtensionPointName<KeyedLazyInstance<VirtualFileSystem>> EP_NAME = ExtensionPointName.create("com.intellij.virtualFileSystem");

    protected VirtualFileSystem() {
    }

    @NonNls
    @NotNull
    public abstract String getProtocol();

    @Nullable
    public abstract VirtualFile findFileByPath(@NotNull @NonNls String var1);

    @NotNull
    public String extractPresentableUrl(@NotNull String path) {
        return path.replace('/', File.separatorChar);
    }

    public abstract void refresh(boolean var1);

    @Nullable
    public abstract VirtualFile refreshAndFindFileByPath(@NotNull String var1);

    public abstract void addVirtualFileListener(@NotNull VirtualFileListener var1);

    public final void addVirtualFileListener(@NotNull VirtualFileListener listener, @NotNull Disposable disposable) {
        this.addVirtualFileListener(listener);
        Disposer.register(disposable, () -> this.removeVirtualFileListener(listener));
    }

    public abstract void removeVirtualFileListener(@NotNull VirtualFileListener var1);

    protected abstract void deleteFile(Object var1, @NotNull VirtualFile var2) throws IOException;

    protected abstract void moveFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3) throws IOException;

    protected abstract void renameFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile createChildFile(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile createChildDirectory(Object var1, @NotNull VirtualFile var2, @NotNull String var3) throws IOException;

    @NotNull
    protected abstract VirtualFile copyFile(Object var1, @NotNull VirtualFile var2, @NotNull VirtualFile var3, @NotNull String var4) throws IOException;

    public abstract boolean isReadOnly();

    public boolean isCaseSensitive() {
        return true;
    }

    public boolean isValidName(@NotNull String name) {
        return !name.isEmpty() && name.indexOf(92) < 0 && name.indexOf(47) < 0;
    }

    @Nullable
    public Path getNioPath(@NotNull VirtualFile file2) {
        return null;
    }
}

