/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.vfs.SavingRequestor;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.EventObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualFileEvent
extends EventObject {
    private final Object myRequestor;
    private final VirtualFile myFile;
    private final VirtualFile myParent;
    private final long myOldModificationStamp;
    private final long myNewModificationStamp;

    public VirtualFileEvent(@Nullable Object requestor, @NotNull VirtualFile file2, @Nullable VirtualFile parent, long oldModificationStamp, long newModificationStamp) {
        super(file2);
        this.myRequestor = requestor;
        this.myFile = file2;
        this.myParent = parent;
        this.myOldModificationStamp = oldModificationStamp;
        this.myNewModificationStamp = newModificationStamp;
    }

    @NotNull
    public VirtualFile getFile() {
        return this.myFile;
    }

    @NotNull
    public String getFileName() {
        return this.myFile.getName();
    }

    @Nullable
    public VirtualFile getParent() {
        return this.myParent;
    }

    @Nullable
    public Object getRequestor() {
        return this.myRequestor;
    }

    public long getOldModificationStamp() {
        return this.myOldModificationStamp;
    }

    public long getNewModificationStamp() {
        return this.myNewModificationStamp;
    }

    public boolean isFromRefresh() {
        return this.myRequestor == null;
    }

    public boolean isFromSave() {
        return this.myRequestor instanceof SavingRequestor;
    }
}

