/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs;

import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import org.jetbrains.annotations.NotNull;

public final class StandardFileSystems {
    public static final String FILE_PROTOCOL = "file";
    public static final String FILE_PROTOCOL_PREFIX = "file://";
    public static final String JAR_PROTOCOL = "jar";
    public static final String JAR_PROTOCOL_PREFIX = "jar://";
    public static final String JRT_PROTOCOL = "jrt";
    public static final String JRT_PROTOCOL_PREFIX = "jrt://";
    private static final ClearableLazyValue<VirtualFileSystem> ourLocal = CachedSingletonsRegistry.markLazyValue(new ClearableLazyValue<VirtualFileSystem>(){

        @Override
        @NotNull
        protected VirtualFileSystem compute() {
            return VirtualFileManager.getInstance().getFileSystem(StandardFileSystems.FILE_PROTOCOL);
        }
    });
    private static final ClearableLazyValue<VirtualFileSystem> ourJar = CachedSingletonsRegistry.markLazyValue(new ClearableLazyValue<VirtualFileSystem>(){

        @Override
        @NotNull
        protected VirtualFileSystem compute() {
            return VirtualFileManager.getInstance().getFileSystem(StandardFileSystems.JAR_PROTOCOL);
        }
    });

    public static VirtualFileSystem local() {
        return ourLocal.getValue();
    }

    public static VirtualFileSystem jar() {
        return ourJar.getValue();
    }
}

