/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.CharFilter;
import com.intellij.openapi.util.text.Formats;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.LineColumn;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.LineSeparator;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.intellij.util.text.MergingCharSequence;
import java.beans.Introspector;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends StringUtilRt {
    public static final String ELLIPSIS = "\u2026";
    public static final String THREE_DOTS = "...";
    public static final String NON_BREAK_SPACE = "\u00a0";
    public static final Function<String, String> QUOTER = s -> "\"" + s + "\"";
    public static final Function<String, String> SINGLE_QUOTER = s -> "'" + s + "'";
    private static final String[] ourLowerCaseWords = new String[]{"a", "an", "and", "as", "at", "but", "by", "down", "for", "from", "in", "into", "near", "nor", "of", "on", "onto", "or", "out", "over", "per", "so", "the", "to", "until", "unto", "up", "upon", "via", "with"};
    private static final String[] ourOtherNonCapitalizableWords = new String[]{"iOS", "iPhone", "iPad", "iMac"};
    private static final List<String> MN_QUOTED = Arrays.asList("&&", "__");
    private static final List<String> MN_CHARS = Arrays.asList("&", "_");
    private static final Pattern UNICODE_CHAR = Pattern.compile("\\\\u[\\da-fA-F]{4}");

    @NotNull
    public static MergingCharSequence replaceSubSequence(@NotNull CharSequence charSeq, int start, int end, @NotNull CharSequence replacement) {
        return new MergingCharSequence(new MergingCharSequence(new CharSequenceSubSequence(charSeq, 0, start), replacement), new CharSequenceSubSequence(charSeq, end, charSeq.length()));
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> getWordsInStringLongestFirst(@NotNull String find) {
        List<String> words = StringUtil.getWordsIn(find);
        words.sort((o1, o2) -> o2.length() - o1.length());
        return words;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapePattern(@NotNull String text) {
        return StringUtil.replace(StringUtil.replace(text, "'", "''"), "{", "'{'");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    @Contract(pure=true)
    @NotNull
    public static <T> com.intellij.util.Function<T, String> createToStringFunction(@NotNull Class<T> cls) {
        return Object::toString;
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text, @NotNull String oldS, @NotNull String newS) {
        return StringUtil.replace(text, oldS, newS, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String replaceIgnoreCase(@NotNull String text, @NotNull String oldS, @NotNull String newS) {
        return StringUtil.replace(text, oldS, newS, true);
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static String replaceChar(@NotNull String buffer, char oldChar, char newChar) {
        return buffer.replace(oldChar, newChar);
    }

    @Contract(pure=true)
    public static String replace(@NotNull String text, @NotNull String oldS, @NotNull String newS, boolean ignoreCase) {
        if (text.length() < oldS.length()) {
            return text;
        }
        StringBuilder newText = null;
        int i = 0;
        while (i < text.length()) {
            int index;
            int n = index = ignoreCase ? StringUtil.indexOfIgnoreCase(text, oldS, i) : text.indexOf(oldS, i);
            if (index < 0) {
                if (i == 0) {
                    return text;
                }
                newText.append(text, i, text.length());
                break;
            }
            if (newText == null) {
                if (text.length() == oldS.length()) {
                    return newS;
                }
                newText = new StringBuilder(text.length() - i);
            }
            newText.append(text, i, index);
            newText.append(newS);
            i = index + oldS.length();
        }
        return newText != null ? newText.toString() : "";
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, @NotNull String what, int fromIndex) {
        return Strings.indexOfIgnoreCase(where, what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull CharSequence where, @NotNull CharSequence what, int fromIndex) {
        return Strings.indexOfIgnoreCase(where, what, fromIndex);
    }

    @Contract(pure=true)
    public static int indexOfIgnoreCase(@NotNull String where, char what, int fromIndex) {
        return Strings.indexOfIgnoreCase(where, what, fromIndex);
    }

    @Contract(pure=true)
    public static int lastIndexOfIgnoreCase(@NotNull String where, char c, int fromIndex) {
        for (int i = Math.min(fromIndex, where.length() - 1); i >= 0; --i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), c)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    public static boolean containsIgnoreCase(@NotNull String where, @NotNull String what) {
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    @Contract(pure=true)
    public static boolean endsWithIgnoreCase(@NotNull String str, @NotNull String suffix) {
        return Strings.endsWithIgnoreCase(str, suffix);
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NotNull String str, @NotNull String prefix) {
        return StringUtilRt.startsWithIgnoreCase((String)str, (String)prefix);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, boolean convertBreaks) {
        return StringUtil.stripHtml(html, convertBreaks ? "\n\n" : null);
    }

    @Contract(pure=true)
    @NotNull
    public static String stripHtml(@NotNull String html, @Nullable String breaks) {
        if (breaks != null) {
            html = html.replaceAll("<br/?>", breaks);
        }
        return html.replaceAll("<(.|\n)*?>", "");
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toLowerCase(@Nullable String str) {
        return Strings.toLowerCase(str);
    }

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public static String getPackageName(@NotNull String fqName) {
        return StringUtil.getPackageName(fqName, '.');
    }

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public static String getPackageName(@NotNull String fqName, char separator) {
        int lastPointIdx = fqName.lastIndexOf(separator);
        if (lastPointIdx >= 0) {
            return fqName.substring(0, lastPointIdx);
        }
        return "";
    }

    @Contract(pure=true)
    public static int getLineBreakCount(@NotNull CharSequence text) {
        int count = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                ++count;
                continue;
            }
            if (c != '\r') continue;
            if (i + 1 < text.length() && text.charAt(i + 1) == '\n') {
                ++i;
            }
            ++count;
        }
        return count;
    }

    @Contract(pure=true)
    public static boolean containsLineBreak(@NotNull CharSequence text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!StringUtil.isLineBreak(c)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isLineBreak(char c) {
        return c == '\n' || c == '\r';
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeLineBreak(@NotNull String text) {
        StringBuilder buffer = new StringBuilder(text.length());
        block4: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\n': {
                    buffer.append("\\n");
                    continue block4;
                }
                case '\r': {
                    buffer.append("\\r");
                    continue block4;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    @Contract(pure=true)
    public static boolean endsWithLineBreak(@NotNull CharSequence text) {
        int len = text.length();
        return len > 0 && StringUtil.isLineBreak(text.charAt(len - 1));
    }

    @Contract(pure=true)
    public static int lineColToOffset(@NotNull CharSequence text, int line, int col) {
        int curLine = 0;
        int offset = 0;
        while (line != curLine) {
            if (offset == text.length()) {
                return -1;
            }
            char c = text.charAt(offset);
            if (c == '\n') {
                ++curLine;
            } else if (c == '\r') {
                ++curLine;
                if (offset < text.length() - 1 && text.charAt(offset + 1) == '\n') {
                    ++offset;
                }
            }
            ++offset;
        }
        return offset + col;
    }

    @Contract(pure=true)
    public static int offsetToLineNumber(@NotNull CharSequence text, int offset) {
        LineColumn lineColumn = StringUtil.offsetToLineColumn(text, offset);
        return lineColumn != null ? lineColumn.line : -1;
    }

    @Contract(pure=true)
    public static LineColumn offsetToLineColumn(@NotNull CharSequence text, int offset) {
        int curLine = 0;
        int curLineStart = 0;
        for (int curOffset = 0; curOffset < offset; ++curOffset) {
            if (curOffset == text.length()) {
                return null;
            }
            char c = text.charAt(curOffset);
            if (c == '\n') {
                ++curLine;
                curLineStart = curOffset + 1;
                continue;
            }
            if (c != '\r') continue;
            ++curLine;
            if (curOffset < text.length() - 1 && text.charAt(curOffset + 1) == '\n') {
                ++curOffset;
            }
            curLineStart = curOffset + 1;
        }
        return LineColumn.of(curLine, offset - curLineStart);
    }

    @Contract(pure=true)
    public static int difference(@NotNull String s1, @NotNull String s2) {
        int i;
        int[][] a = new int[s1.length()][s2.length()];
        for (i = 0; i < s1.length(); ++i) {
            a[i][0] = i;
        }
        for (int j = 0; j < s2.length(); ++j) {
            a[0][j] = j;
        }
        for (i = 1; i < s1.length(); ++i) {
            for (int j = 1; j < s2.length(); ++j) {
                a[i][j] = Math.min(Math.min(a[i - 1][j - 1] + (s1.charAt(i) == s2.charAt(j) ? 0 : 1), a[i - 1][j] + 1), a[i][j - 1] + 1);
            }
        }
        return a[s1.length() - 1][s2.length() - 1];
    }

    @Contract(pure=true)
    @NotNull
    public static String wordsToBeginFromUpperCase(@NotNull String s) {
        return StringUtil.fixCapitalization(s, ourLowerCaseWords, true, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String wordsToBeginFromLowerCase(@NotNull String s) {
        return StringUtil.fixCapitalization(s, ArrayUtilRt.EMPTY_STRING_ARRAY, false, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String toTitleCase(@NotNull String s) {
        return StringUtil.fixCapitalization(s, ArrayUtilRt.EMPTY_STRING_ARRAY, true, false);
    }

    @NotNull
    private static String fixCapitalization(@NotNull String s, String @NotNull [] wordsToIgnore, boolean title, boolean mnemonics) {
        StringBuilder buffer = null;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            boolean lastWord;
            char prevPrevChar;
            char prevChar = i == 0 ? (char)' ' : (char)s.charAt(i - 1);
            char currChar = s.charAt(i);
            if (Character.isLetterOrDigit(prevChar) || prevChar == 39 || !Character.isLetterOrDigit(currChar) || !title && !Character.isUpperCase(currChar)) continue;
            int start = i++;
            while (i < length) {
                char c = s.charAt(i);
                if ((!mnemonics || c != '&' && c != '_') && !Character.isLetterOrDigit(c)) break;
                ++i;
            }
            if (!title && i > start + 1 && !Character.isLowerCase(s.charAt(start + 1))) continue;
            char c = prevPrevChar = start > 1 ? s.charAt(start - 2) : (char)'\u0000';
            if (prevChar == '.' && (prevPrevChar == ' ' || prevPrevChar == '*') || prevChar == '~' && prevPrevChar == ' ' || StringUtil.isPreposition(s, start, i - 1, ourOtherNonCapitalizableWords)) continue;
            boolean firstWord = start == 0 || StringUtil.isPunctuation(prevPrevChar);
            boolean bl = lastWord = i >= length - 1 || StringUtil.isPunctuation(s.charAt(i + 1));
            if (title && !firstWord && !lastWord && StringUtil.isPreposition(s, start, i - 1, wordsToIgnore)) continue;
            if (buffer == null) {
                buffer = new StringBuilder(s);
            }
            buffer.setCharAt(start, title ? StringUtil.toUpperCase(currChar) : StringUtil.toLowerCase(currChar));
        }
        return buffer == null ? s : buffer.toString();
    }

    private static boolean isPunctuation(char c) {
        return c == '.' || c == '!' || c == ':' || c == '?';
    }

    @Contract(pure=true)
    public static boolean isPreposition(@NotNull String s, int firstChar, int lastChar, String @NotNull [] prepositions) {
        block0: for (String preposition : prepositions) {
            if (lastChar - firstChar + 1 != preposition.length()) continue;
            for (int j = 0; j < preposition.length(); ++j) {
                if (StringUtil.toLowerCase(s.charAt(firstChar + j)) != StringUtil.toLowerCase(preposition.charAt(j))) continue block0;
            }
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    @NotNull
    public static NotNullFunction<String, String> escaper(boolean escapeSlash, @Nullable String additionalChars) {
        return dom -> {
            StringBuilder builder = new StringBuilder(dom.length());
            StringUtil.escapeStringCharacters(dom.length(), dom, additionalChars, escapeSlash, builder);
            return builder.toString();
        };
    }

    public static void escapeStringCharacters(int length, @NotNull String str, @NotNull StringBuilder buffer) {
        StringUtil.escapeStringCharacters(length, str, "\"", buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, @NotNull StringBuilder buffer) {
        return StringUtil.escapeStringCharacters(length, str, additionalChars, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, @NotNull StringBuilder buffer) {
        return StringUtil.escapeStringCharacters(length, str, additionalChars, escapeSlash, true, buffer);
    }

    @NotNull
    public static StringBuilder escapeStringCharacters(int length, @NotNull String str, @Nullable String additionalChars, boolean escapeSlash, boolean escapeUnicode, @NotNull StringBuilder buffer) {
        char prev = '\u0000';
        for (int idx = 0; idx < length; ++idx) {
            char ch = str.charAt(idx);
            switch (ch) {
                case '\b': {
                    buffer.append("\\b");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\f': {
                    buffer.append("\\f");
                    break;
                }
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                default: {
                    if (escapeSlash && ch == '\\') {
                        buffer.append("\\\\");
                        break;
                    }
                    if (additionalChars != null && additionalChars.indexOf(ch) > -1 && (escapeSlash || prev != '\\')) {
                        buffer.append("\\").append(ch);
                        break;
                    }
                    if (escapeUnicode && !StringUtil.isPrintableUnicode(ch)) {
                        String hexCode = StringUtil.toUpperCase(Integer.toHexString(ch));
                        buffer.append("\\u");
                        int paddingCount = 4 - hexCode.length();
                        while (paddingCount-- > 0) {
                            buffer.append(0);
                        }
                        buffer.append((CharSequence)hexCode);
                        break;
                    }
                    buffer.append(ch);
                }
            }
            prev = ch;
        }
        return buffer;
    }

    @Contract(pure=true)
    public static boolean isPrintableUnicode(char c) {
        int t = Character.getType(c);
        return t != 0 && t != 13 && t != 14 && t != 15 && t != 16 && t != 18 && t != 19;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeStringCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "\"", buffer);
        return buffer.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeCharCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.escapeStringCharacters(s.length(), s, "'", buffer);
        return buffer.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeStringCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        StringUtil.unescapeStringCharacters(s.length(), s, buffer);
        return buffer.toString();
    }

    private static boolean isQuoteAt(@NotNull String s, int ind) {
        char ch = s.charAt(ind);
        return ch == '\'' || ch == '\"';
    }

    @Contract(pure=true)
    public static boolean isQuotedString(@NotNull String s) {
        return StringUtilRt.isQuotedString((String)s);
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteString(@NotNull String s) {
        return StringUtilRt.unquoteString((String)s);
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteString(@NotNull String s, char quotationChar) {
        return StringUtilRt.unquoteString((String)s, (char)quotationChar);
    }

    private static void unescapeStringCharacters(int length, @NotNull String s, @NotNull StringBuilder buffer) {
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            int octalEscapeMaxLength = 2;
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'u': {
                    if (idx + 4 < length) {
                        try {
                            int code = Integer.parseInt(s.substring(idx + 1, idx + 5), 16);
                            idx += 4;
                            buffer.append((char)code);
                        }
                        catch (NumberFormatException e) {
                            buffer.append("\\u");
                        }
                        break;
                    }
                    buffer.append("\\u");
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': {
                    octalEscapeMaxLength = 3;
                }
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int escapeEnd;
                    for (escapeEnd = idx + 1; escapeEnd < length && escapeEnd < idx + octalEscapeMaxLength && StringUtil.isOctalDigit(s.charAt(escapeEnd)); ++escapeEnd) {
                    }
                    try {
                        buffer.append((char)Integer.parseInt(s.substring(idx, escapeEnd), 8));
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Couldn't parse " + s.substring(idx, escapeEnd), e);
                    }
                    idx = escapeEnd - 1;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
    }

    @NotNull
    public static String unescapeAnsiStringCharacters(@NotNull String s) {
        StringBuilder buffer = new StringBuilder();
        int length = s.length();
        int count = 0;
        int radix = 0;
        int suffixLen = 0;
        boolean decode = false;
        boolean escaped = false;
        for (int idx = 0; idx < length; ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '?': {
                    buffer.append('?');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                case 'a': {
                    buffer.append('\u0007');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'v': {
                    buffer.append('\u000b');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    count = 3;
                    radix = 8;
                    suffixLen = 0;
                    decode = true;
                    break;
                }
                case 'x': {
                    count = 2;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                case 'u': {
                    count = 4;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                case 'U': {
                    count = 8;
                    radix = 16;
                    suffixLen = 1;
                    decode = true;
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            if (decode) {
                decode = false;
                StringBuilder sb = new StringBuilder(count);
                for (int pos = idx + suffixLen; pos < length && count > 0; --count, ++pos) {
                    char chl = s.charAt(pos);
                    if (!(radix == 16 && StringUtil.isHexDigit(chl) || radix == 8 && StringUtil.isOctalDigit(chl))) break;
                    sb.append(chl);
                }
                if (sb.length() != 0) {
                    try {
                        long code = Long.parseLong(sb.toString(), radix);
                        idx += sb.length() + suffixLen - 1;
                        buffer.append((char)code);
                    }
                    catch (NumberFormatException e) {
                        buffer.append('\\').append(ch);
                    }
                } else {
                    buffer.append('\\').append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        return buffer.toString();
    }

    @Contract(pure=true)
    @NotNull
    @NonNls
    public static String pluralize(@NotNull @NonNls String word) {
        return Strings.pluralize(word);
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWords(@NotNull String text, boolean allWords) {
        return StringUtil.capitalizeWords(text, " \t\n\r\f([<", allWords, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWords(@NotNull String text, @NotNull String tokenizerDelimiters, boolean allWords, boolean leaveOriginalDelimiters) {
        StringTokenizer tokenizer = new StringTokenizer(text, tokenizerDelimiters, leaveOriginalDelimiters);
        StringBuilder out = new StringBuilder(text.length());
        boolean toCapitalize = true;
        while (tokenizer.hasMoreTokens()) {
            String word = tokenizer.nextToken();
            if (!leaveOriginalDelimiters && out.length() > 0) {
                out.append(' ');
            }
            out.append(toCapitalize ? StringUtil.capitalize(word) : word);
            if (allWords) continue;
            toCapitalize = false;
        }
        return out.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String decapitalize(@NotNull String s) {
        return Introspector.decapitalize(s);
    }

    @Contract(pure=true)
    public static boolean isVowel(char c) {
        return c == 'a' || c == 'e' || c == 'i' || c == 'o' || c == 'u' || c == 'y';
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalize(@NotNull String s) {
        return Strings.capitalize(s);
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isCapitalized(@Nullable String s) {
        return Strings.isCapitalized(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String capitalizeWithJavaBeanConvention(@NotNull String s) {
        if (s.length() > 1 && Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        return StringUtil.capitalize(s);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars) {
        return Strings.stringHashCode(chars);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to) {
        return Strings.stringHashCode(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCode(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        return Strings.stringHashCode(chars, from, to, prefixHash);
    }

    @Contract(pure=true)
    public static int stringHashCode(char[] chars, int from, int to) {
        return Strings.stringHashCode(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(char @NotNull [] chars, int from, int to) {
        return Strings.stringHashCodeInsensitive(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to) {
        return Strings.stringHashCodeInsensitive(chars, from, to);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars, int from, int to, int prefixHash) {
        return Strings.stringHashCodeInsensitive(chars, from, to, prefixHash);
    }

    @Contract(pure=true)
    public static int stringHashCodeInsensitive(@NotNull CharSequence chars) {
        return Strings.stringHashCodeInsensitive(chars);
    }

    @Contract(pure=true)
    public static int stringHashCodeIgnoreWhitespaces(@NotNull CharSequence chars) {
        return Strings.stringHashCodeIgnoreWhitespaces(chars);
    }

    @Contract(pure=true)
    public static boolean startsWithConcatenation(@NotNull String string2, String ... prefixes) {
        int offset = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string2.regionMatches(offset, prefix, 0, prefixLen)) {
                return false;
            }
            offset += prefixLen;
        }
        return true;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String trim(@Nullable String s) {
        return Strings.trim(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix) {
        return Strings.trimEnd(s, suffix);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, @NotNull String suffix, boolean ignoreCase) {
        return Strings.trimEnd(s, suffix, ignoreCase);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimEnd(@NotNull String s, char suffix) {
        return Strings.trimEnd(s, suffix);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLog(@NotNull String text, int limit) {
        if (limit > 5 && text.length() > limit) {
            return text.substring(0, limit - 5) + " ...\n";
        }
        return text;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLeading(@NotNull String string2) {
        return StringUtil.trimLeading((CharSequence)string2).toString();
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence trimLeading(@NotNull CharSequence string2) {
        int index;
        for (index = 0; index < string2.length() && Character.isWhitespace(string2.charAt(index)); ++index) {
        }
        return string2.subSequence(index, string2.length());
    }

    @Contract(pure=true)
    @NotNull
    public static String trimLeading(@NotNull String string2, char symbol) {
        int index;
        for (index = 0; index < string2.length() && string2.charAt(index) == symbol; ++index) {
        }
        return string2.substring(index);
    }

    @NotNull
    public static StringBuilder trimLeading(@NotNull StringBuilder builder, char symbol) {
        int index;
        for (index = 0; index < builder.length() && builder.charAt(index) == symbol; ++index) {
        }
        if (index > 0) {
            builder.delete(0, index);
        }
        return builder;
    }

    @Contract(pure=true)
    @NotNull
    public static String trimTrailing(@NotNull String string2) {
        return StringUtil.trimTrailing((CharSequence)string2).toString();
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence trimTrailing(@NotNull CharSequence string2) {
        int index;
        for (index = string2.length() - 1; index >= 0 && Character.isWhitespace(string2.charAt(index)); --index) {
        }
        return string2.subSequence(0, index + 1);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimTrailing(@NotNull String string2, char symbol) {
        int index;
        for (index = string2.length() - 1; index >= 0 && string2.charAt(index) == symbol; --index) {
        }
        return string2.substring(0, index + 1);
    }

    @NotNull
    public static StringBuilder trimTrailing(@NotNull StringBuilder builder, char symbol) {
        int index;
        for (index = builder.length() - 1; index >= 0 && builder.charAt(index) == symbol; --index) {
        }
        builder.setLength(index + 1);
        return builder;
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    @Nullable
    public static CharSequence trim(@Nullable CharSequence s) {
        int endIndex;
        int startIndex;
        if (s == null) {
            return null;
        }
        int length = s.length();
        if (length == 0) {
            return s;
        }
        for (startIndex = 0; startIndex < length && Character.isWhitespace(s.charAt(startIndex)); ++startIndex) {
        }
        if (startIndex == length) {
            return Strings.EMPTY_CHAR_SEQUENCE;
        }
        for (endIndex = length - 1; endIndex >= startIndex && Character.isWhitespace(s.charAt(endIndex)); --endIndex) {
        }
        if (startIndex > 0 || ++endIndex < length) {
            return s.subSequence(startIndex, endIndex);
        }
        return s;
    }

    @Contract(pure=true)
    public static boolean startsWithChar(@Nullable CharSequence s, char prefix) {
        return s != null && s.length() != 0 && s.charAt(0) == prefix;
    }

    @Contract(pure=true)
    public static boolean endsWithChar(@Nullable CharSequence s, char suffix) {
        return Strings.endsWithChar(s, suffix);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimStart(@NotNull String s, @NotNull String prefix) {
        return Strings.trimStart(s, prefix);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimExtensions(@NotNull String name) {
        int index = name.indexOf(46);
        return index < 0 ? name : name.substring(0, index);
    }

    @Contract(pure=true)
    @NotNull
    public static String pluralize(@NotNull String base, int count) {
        if (count == 1) {
            return base;
        }
        return StringUtil.pluralize(base);
    }

    public static void repeatSymbol(@NotNull Appendable buffer, char symbol, int times) {
        assert (times >= 0) : times;
        try {
            for (int i = 0; i < times; ++i) {
                buffer.append(symbol);
            }
        }
        catch (IOException e) {
            Logger.getInstance(StringUtil.class).error(e);
        }
    }

    @Contract(pure=true)
    public static String defaultIfEmpty(@Nullable String value, String defaultValue) {
        return StringUtil.isEmpty(value) ? defaultValue : value;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isNotEmpty(@Nullable String s) {
        return Strings.isNotEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable String s) {
        return Strings.isEmpty(s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmpty(@Nullable CharSequence cs) {
        return Strings.isEmpty(cs);
    }

    @Contract(pure=true)
    public static int length(@Nullable CharSequence cs) {
        return cs == null ? 0 : cs.length();
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s) {
        return Strings.notNullize(s);
    }

    @Contract(pure=true)
    @NotNull
    public static String notNullize(@Nullable String s, @NotNull String defaultValue) {
        return Strings.notNullize(s, defaultValue);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s) {
        return Strings.nullize(s, false);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, @Nullable String defaultValue) {
        return Strings.nullize(s, defaultValue);
    }

    @Contract(pure=true)
    @Nullable
    public static String nullize(@Nullable String s, boolean nullizeSpaces) {
        return Strings.nullize(s, nullizeSpaces);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable String s) {
        return StringUtil.isEmptyOrSpaces((CharSequence)s);
    }

    @Contract(value="null -> true", pure=true)
    public static boolean isEmptyOrSpaces(@Nullable CharSequence s) {
        return Strings.isEmptyOrSpaces(s);
    }

    @Contract(pure=true)
    public static boolean isWhiteSpace(char c) {
        return Strings.isWhiteSpace(c);
    }

    @Contract(pure=true)
    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable) {
        return ExceptionUtil.getThrowableText(aThrowable);
    }

    @Contract(pure=true)
    @Nullable
    public static String getMessage(@NotNull Throwable e) {
        return ExceptionUtil.getMessage(e);
    }

    @Contract(pure=true)
    @NotNull
    public static String repeatSymbol(char aChar, int count) {
        char[] buffer = new char[count];
        Arrays.fill(buffer, aChar);
        return new String(buffer);
    }

    @Contract(pure=true)
    @NotNull
    public static String repeat(@NotNull String s, int count) {
        if (count == 0) {
            return "";
        }
        assert (count >= 0) : count;
        StringBuilder sb = new StringBuilder(s.length() * count);
        for (int i = 0; i < count; ++i) {
            sb.append(s);
        }
        return sb.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        return StringUtilRt.splitHonorQuotes((String)s, (char)separator);
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator) {
        return StringUtil.split(s, separator, true);
    }

    @Contract(pure=true)
    @NotNull
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator) {
        return StringUtil.split(s, separator, true, true);
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator) {
        return StringUtil.split(s, separator, excludeSeparator, true);
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> split(@NotNull String s, @NotNull String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        return StringUtil.split((CharSequence)s, (CharSequence)separator, excludeSeparator, excludeEmptyStrings);
    }

    @Contract(pure=true)
    @NotNull
    public static List<CharSequence> split(@NotNull CharSequence s, @NotNull CharSequence separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (separator.length() == 0) {
            return Collections.singletonList(s);
        }
        ArrayList<CharSequence> result = new ArrayList<CharSequence>();
        int pos = 0;
        while ((index = StringUtil.indexOf(s, separator, pos)) != -1) {
            int nextPos = index + separator.length();
            CharSequence token = s.subSequence(pos, excludeSeparator ? index : nextPos);
            if (token.length() != 0 || !excludeEmptyStrings) {
                result.add(token);
            }
            pos = nextPos;
        }
        if (pos < s.length() || !excludeEmptyStrings && pos == s.length()) {
            result.add(s.subSequence(pos, s.length()));
        }
        return result;
    }

    @Contract(pure=true)
    @NotNull
    public static Iterable<String> tokenize(@NotNull String s, @NotNull String separators) {
        return StringUtil.tokenize(new StringTokenizer(s, separators));
    }

    @Contract(pure=true)
    @NotNull
    public static Iterable<String> tokenize(final @NotNull StringTokenizer tokenizer) {
        return () -> new Iterator<String>(){

            @Override
            public boolean hasNext() {
                return tokenizer.hasMoreTokens();
            }

            @Override
            public String next() {
                return tokenizer.nextToken();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> getWordsIn(@NotNull String text) {
        SmartList<String> result = null;
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            boolean isIdentifierPart = Character.isJavaIdentifierPart(c);
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1) {
                if (result == null) {
                    result = new SmartList();
                }
                result.add(text.substring(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            if (result == null) {
                result = new SmartList<String>();
            }
            result.add(text.substring(start, i));
            start = -1;
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Contract(pure=true)
    @NotNull
    public static List<TextRange> getWordIndicesIn(@NotNull String text) {
        return StringUtil.getWordIndicesIn(text, null);
    }

    @Contract(pure=true)
    @NotNull
    public static List<TextRange> getWordIndicesIn(@NotNull String text, @Nullable Set<Character> separatorsSet) {
        SmartList<TextRange> result = new SmartList<TextRange>();
        int start = -1;
        for (int i = 0; i < text.length(); ++i) {
            boolean isIdentifierPart;
            char c = text.charAt(i);
            boolean bl = separatorsSet == null ? Character.isJavaIdentifierPart(c) : (isIdentifierPart = !separatorsSet.contains(Character.valueOf(c)));
            if (isIdentifierPart && start == -1) {
                start = i;
            }
            if (isIdentifierPart && i == text.length() - 1) {
                result.add(new TextRange(start, i + 1));
                continue;
            }
            if (isIdentifierPart || start == -1) continue;
            result.add(new TextRange(start, i));
            start = -1;
        }
        return result;
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String @NotNull [] strings2, @NotNull String separator) {
        return StringUtil.join(strings2, 0, strings2.length, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String @NotNull [] strings2, int startIndex, int endIndex, @NotNull String separator) {
        StringBuilder result = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            if (i > startIndex) {
                result.append(separator);
            }
            result.append(strings2[i]);
        }
        return result.toString();
    }

    @Contract(pure=true)
    public static String @NotNull [] zip(String @NotNull [] strings1, String @NotNull [] strings2, String separator) {
        if (strings1.length != strings2.length) {
            throw new IllegalArgumentException();
        }
        String[] result = ArrayUtil.newStringArray(strings1.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = strings1[i] + separator + strings2[i];
        }
        return result;
    }

    @Contract(pure=true)
    public static String @NotNull [] surround(String @NotNull [] strings2, @NotNull String prefix, @NotNull String suffix) {
        String[] result = ArrayUtil.newStringArray(strings2.length);
        for (int i = 0; i < result.length; ++i) {
            result[i] = prefix + strings2[i] + suffix;
        }
        return result;
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(T @NotNull [] items, @NotNull com.intellij.util.Function<? super T, String> f, @NotNull String separator) {
        return Strings.join(items, f, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Collection<? extends T> items, @NotNull com.intellij.util.Function<? super T, String> f, @NotNull String separator) {
        return Strings.join(items, f, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Iterable<?> items, @NotNull String separator) {
        return Strings.join(items, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static <T> String join(@NotNull Iterable<? extends T> items, @NotNull com.intellij.util.Function<? super T, ? extends CharSequence> f, @NotNull String separator) {
        return Strings.join(items, f, separator);
    }

    public static <T> void join(@NotNull Iterable<? extends T> items, @NotNull com.intellij.util.Function<? super T, ? extends CharSequence> f, @NotNull String separator, @NotNull StringBuilder result) {
        Strings.join(items, f, separator, result);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(@NotNull Collection<String> strings2, @NotNull String separator) {
        return Strings.join(strings2, separator);
    }

    public static void join(@NotNull Collection<String> strings2, @NotNull String separator, @NotNull StringBuilder result) {
        Strings.join(strings2, separator, result);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(int @NotNull [] strings2, @NotNull String separator) {
        return Strings.join(strings2, separator);
    }

    @Contract(pure=true)
    @NotNull
    public static String join(String ... strings2) {
        return Strings.join(strings2);
    }

    @Contract(pure=true)
    @NotNull
    public static Collector<CharSequence, ?, String> joining() {
        return Collectors.joining(", ");
    }

    @Contract(pure=true)
    @NotNull
    public static String stripQuotesAroundValue(@NotNull String text) {
        int len = text.length();
        if (len > 0) {
            int to;
            int from = StringUtil.isQuoteAt(text, 0) ? 1 : 0;
            int n = to = len > 1 && StringUtil.isQuoteAt(text, len - 1) ? len - 1 : len;
            if (from > 0 || to < len) {
                return text.substring(from, to);
            }
        }
        return text;
    }

    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize) {
        return Formats.formatFileSize(fileSize);
    }

    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize, @NotNull String unitSeparator) {
        return Formats.formatFileSize(fileSize, unitSeparator);
    }

    @Contract(pure=true)
    @NotNull
    @NonNls
    public static String formatDuration(long duration) {
        return Formats.formatDuration(duration);
    }

    @Contract(pure=true)
    @NotNull
    @NonNls
    public static String formatDuration(@NotNull Duration duration) {
        return Formats.formatDuration(duration);
    }

    @Deprecated
    @Contract(pure=true)
    @ApiStatus.ScheduledForRemoval
    @NotNull
    @NonNls
    public static String formatDuration(long duration, @NotNull String unitSeparator) {
        return Formats.formatDuration(duration, unitSeparator);
    }

    @Contract(pure=true)
    @Nullable
    public static String unpluralize(@NotNull String word) {
        return Strings.unpluralize(word);
    }

    @Contract(pure=true)
    public static boolean containsAlphaCharacters(@NotNull String value) {
        for (int i = 0; i < value.length(); ++i) {
            if (!Character.isLetter(value.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull @NonNls String chars) {
        return Strings.containsAnyChar(value, chars);
    }

    @Contract(pure=true)
    public static boolean containsAnyChar(@NotNull String value, @NotNull String chars, int start, int end) {
        return Strings.containsAnyChar(value, chars, start, end);
    }

    @Contract(pure=true)
    public static boolean containsChar(@NotNull String value, char ch) {
        return Strings.containsChar(value, ch);
    }

    @Contract(pure=true)
    @NotNull
    public static String strip(@NotNull String s, @NotNull CharFilter filter) {
        StringBuilder result = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            result.append(ch);
        }
        return result.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String trim(@NotNull String s, @NotNull CharFilter filter) {
        char ch;
        int start;
        int end = s.length();
        for (start = 0; start < end && !filter.accept(ch = s.charAt(start)); ++start) {
        }
        while (start < end && !filter.accept(ch = s.charAt(end - 1))) {
            --end;
        }
        return s.substring(start, end);
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern) {
        return StringUtil.findMatches(s, pattern, 1);
    }

    @Contract(pure=true)
    @NotNull
    public static List<String> findMatches(@NotNull String s, @NotNull Pattern pattern, int groupIndex) {
        SmartList<String> result = new SmartList<String>();
        Matcher m = pattern.matcher(s);
        while (m.find()) {
            String group = m.group(groupIndex);
            if (group == null) continue;
            result.add(group);
        }
        return result;
    }

    @Contract(pure=true)
    public static int findFirst(@NotNull CharSequence s, @NotNull CharFilter filter) {
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (!filter.accept(ch)) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    @NotNull
    public static String replaceSubstring(@NotNull String string2, @NotNull TextRange range, @NotNull String replacement) {
        return range.replace(string2, replacement);
    }

    @Contract(pure=true)
    public static boolean startsWithWhitespace(@NotNull String text) {
        return !text.isEmpty() && Character.isWhitespace(text.charAt(0));
    }

    @Contract(pure=true)
    public static boolean isChar(CharSequence seq, int index, char c) {
        return index >= 0 && index < seq.length() && seq.charAt(index) == c;
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, @NotNull CharSequence prefix) {
        return StringUtilRt.startsWith((CharSequence)text, (CharSequence)prefix);
    }

    @Contract(pure=true)
    public static boolean startsWith(@NotNull CharSequence text, int startIndex, @NotNull CharSequence prefix) {
        return Strings.startsWith(text, startIndex, prefix);
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, @NotNull CharSequence suffix) {
        return Strings.endsWith(text, suffix);
    }

    @Contract(pure=true)
    public static boolean endsWith(@NotNull CharSequence text, int start, int end, @NotNull CharSequence suffix) {
        if (start < 0 || end > text.length()) {
            throw new IllegalArgumentException("invalid offsets: start=" + start + "; end=" + end + "; text.length()=" + text.length());
        }
        int suffixLen = suffix.length();
        int delta = end - suffixLen;
        if (delta < start) {
            return false;
        }
        for (int i = 0; i < suffixLen; ++i) {
            if (text.charAt(delta + i) == suffix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static String commonPrefix(@NotNull String s1, @NotNull String s2) {
        return s1.substring(0, StringUtil.commonPrefixLength(s1, s2));
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        return StringUtil.commonPrefixLength(s1, s2, false);
    }

    @Contract(pure=true)
    public static int commonPrefixLength(@NotNull CharSequence s1, @NotNull CharSequence s2, boolean ignoreCase) {
        int i;
        int minLength = Math.min(s1.length(), s2.length());
        for (i = 0; i < minLength && Strings.charsMatch(s1.charAt(i), s2.charAt(i), ignoreCase); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    @NotNull
    public static String commonSuffix(@NotNull String s1, @NotNull String s2) {
        return s1.substring(s1.length() - StringUtil.commonSuffixLength(s1, s2));
    }

    @Contract(pure=true)
    public static int commonSuffixLength(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        int i;
        int s1Length = s1.length();
        int s2Length = s2.length();
        if (s1Length == 0 || s2Length == 0) {
            return 0;
        }
        for (i = 0; i < s1Length && i < s2Length && s1.charAt(s1Length - i - 1) == s2.charAt(s2Length - i - 1); ++i) {
        }
        return i;
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence s, int start, int end, char c) {
        return Strings.contains(s, start, end, c);
    }

    @Contract(pure=true)
    public static boolean containsWhitespaces(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c) {
        return Strings.indexOf(s, c);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start) {
        return Strings.indexOf(s, c, start);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end) {
        return Strings.indexOf(s, c, start, end);
    }

    @Contract(pure=true)
    public static boolean contains(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        return Strings.contains(sequence, infix);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix) {
        return Strings.indexOf(sequence, infix);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start) {
        return Strings.indexOf(sequence, infix, start);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence sequence, @NotNull CharSequence infix, int start, int end) {
        return Strings.indexOf(sequence, infix, start, end);
    }

    @Contract(pure=true)
    public static int indexOf(@NotNull CharSequence s, char c, int start, int end, boolean caseSensitive) {
        return Strings.indexOf(s, c, start, end, caseSensitive);
    }

    public static int indexOf(char @NotNull [] s, char c, int start, int end, boolean caseSensitive) {
        return Strings.indexOf(s, c, start, end, caseSensitive);
    }

    @Contract(pure=true)
    public static int indexOfSubstringEnd(@NotNull String text, @NotNull String subString) {
        int i = text.indexOf(subString);
        if (i == -1) {
            return -1;
        }
        return i + subString.length();
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars) {
        return Strings.indexOfAny(s, chars);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        return Strings.indexOfAny(s, chars);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull String s, @NotNull String chars, int start, int end) {
        return Strings.indexOfAny(s, chars, start, end);
    }

    @Contract(pure=true)
    public static int indexOfAny(@NotNull CharSequence s, @NotNull String chars, int start, int end) {
        return Strings.indexOfAny(s, chars, start, end);
    }

    @Contract(pure=true)
    public static int lastIndexOfAny(@NotNull CharSequence s, @NotNull String chars) {
        for (int i = s.length() - 1; i >= 0; --i) {
            if (!StringUtil.containsChar(chars, s.charAt(i))) continue;
            return i;
        }
        return -1;
    }

    @Contract(pure=true)
    @Nullable
    public static String substringBefore(@NotNull String text, @NotNull String subString) {
        int i = text.indexOf(subString);
        if (i == -1) {
            return null;
        }
        return text.substring(0, i);
    }

    @Contract(pure=true)
    @NotNull
    public static String substringBeforeLast(@NotNull String text, @NotNull String subString) {
        int i = text.lastIndexOf(subString);
        if (i == -1) {
            return text;
        }
        return text.substring(0, i);
    }

    @Contract(pure=true)
    @Nullable
    public static String substringAfter(@NotNull String text, @NotNull String subString) {
        int i = text.indexOf(subString);
        if (i == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    @Contract(pure=true)
    @Nullable
    public static String substringAfterLast(@NotNull String text, @NotNull String subString) {
        int i = text.lastIndexOf(subString);
        if (i == -1) {
            return null;
        }
        return text.substring(i + subString.length());
    }

    @Contract(pure=true)
    public static int lastIndexOf(@NotNull CharSequence s, char c, int start, int end) {
        return StringUtilRt.lastIndexOf((CharSequence)s, (char)c, (int)start, (int)end);
    }

    @Contract(pure=true)
    @NotNull
    public static String first(@NotNull String text, int maxLength, boolean appendEllipsis) {
        return text.length() > maxLength ? text.substring(0, maxLength) + (appendEllipsis ? THREE_DOTS : "") : text;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence first(@NotNull CharSequence text, int length, boolean appendEllipsis) {
        if (text.length() <= length) {
            return text;
        }
        if (appendEllipsis) {
            return text.subSequence(0, length) + THREE_DOTS;
        }
        return text.subSequence(0, length);
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence last(@NotNull CharSequence text, int length, boolean prependEllipsis) {
        if (text.length() <= length) {
            return text;
        }
        if (prependEllipsis) {
            return THREE_DOTS + text.subSequence(text.length() - length, text.length());
        }
        return text.subSequence(text.length() - length, text.length());
    }

    @Contract(pure=true)
    @NotNull
    public static String firstLast(@NotNull String text, int length) {
        return text.length() > length ? text.subSequence(0, length / 2) + ELLIPSIS + text.subSequence(text.length() - length / 2 - 1, text.length()) : text;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeChar(@NotNull String str, char character) {
        return StringUtil.escapeChars(str, character);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeChars(@NotNull String str, char ... character) {
        StringBuilder buf = new StringBuilder(str);
        for (char c : character) {
            StringUtil.escapeChar(buf, c);
        }
        return buf.toString();
    }

    public static void escapeChar(@NotNull StringBuilder buf, char character) {
        int idx = 0;
        while ((idx = StringUtil.indexOf((CharSequence)buf, character, idx)) >= 0) {
            buf.insert(idx, "\\");
            idx += 2;
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeQuotes(@NotNull String str) {
        return StringUtil.escapeChar(str, '\"');
    }

    public static void escapeQuotes(@NotNull StringBuilder buf) {
        StringUtil.escapeChar(buf, '\"');
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeSlashes(@NotNull String str) {
        return StringUtil.escapeChar(str, '/');
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeBackSlashes(@NotNull String str) {
        return StringUtil.escapeChar(str, '\\');
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeBackSlashes(@NotNull String str) {
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, '\\');
        return buf.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeChar(@NotNull String str, char unescapeChar) {
        StringBuilder buf = new StringBuilder(str.length());
        StringUtil.unescapeChar(buf, str, unescapeChar);
        return buf.toString();
    }

    private static void unescapeChar(@NotNull StringBuilder buf, @NotNull String str, char unescapeChar) {
        int length = str.length();
        int last = length - 1;
        for (int i = 0; i < length; ++i) {
            char ch = str.charAt(i);
            if (ch == '\\' && i != last && (ch = str.charAt(++i)) != unescapeChar) {
                buf.append('\\');
            }
            buf.append(ch);
        }
    }

    public static void quote(@NotNull StringBuilder builder) {
        StringUtil.quote(builder, '\"');
    }

    public static void quote(@NotNull StringBuilder builder, char quotingChar) {
        builder.insert(0, quotingChar);
        builder.append(quotingChar);
    }

    @Contract(pure=true)
    @NotNull
    public static String wrapWithDoubleQuote(@NotNull String str) {
        return '\"' + str + "\"";
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String unescapeXml(@Nullable String text) {
        return text == null ? null : StringUtil.unescapeXmlEntities(text);
    }

    @Deprecated
    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String escapeXml(@Nullable String text) {
        return text == null ? null : StringUtil.escapeXmlEntities(text);
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeXmlEntities(@NotNull String text) {
        return Strings.unescapeXmlEntities(text);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeXmlEntities(@NotNull String text) {
        return Strings.escapeXmlEntities(text);
    }

    @Contract(pure=true)
    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString) {
        return StringUtil.removeHtmlTags(htmlString, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String removeHtmlTags(@NotNull String htmlString, boolean isRemoveStyleTag) {
        if (StringUtil.isEmpty(htmlString)) {
            return "";
        }
        MyHtml2Text parser = isRemoveStyleTag ? new MyHtml2Text(true) : new MyHtml2Text(false);
        try {
            parser.parse(new StringReader(htmlString));
        }
        catch (IOException e) {
            Logger.getInstance(StringUtil.class).error(e);
        }
        return parser.getText();
    }

    @Contract(pure=true)
    @NotNull
    @Nls
    public static String removeEllipsisSuffix(@NotNull @Nls String s) {
        if (s.endsWith(THREE_DOTS)) {
            return s.substring(0, s.length() - THREE_DOTS.length());
        }
        if (s.endsWith(ELLIPSIS)) {
            return s.substring(0, s.length() - ELLIPSIS.length());
        }
        return s;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeMnemonics(@NotNull String text) {
        return StringUtil.replace(text, MN_CHARS, MN_QUOTED);
    }

    @Contract(pure=true)
    @NlsSafe
    @NotNull
    public static String htmlEmphasize(@NotNull @Nls String text) {
        return HtmlChunk.tag("code").addText(text).wrapWith("b").toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeToRegexp(@NotNull String text) {
        StringBuilder result = new StringBuilder(text.length());
        return StringUtil.escapeToRegexp(text, result).toString();
    }

    @NotNull
    public static StringBuilder escapeToRegexp(@NotNull CharSequence text, @NotNull StringBuilder builder) {
        return Strings.escapeToRegexp(text, builder);
    }

    @Contract(pure=true)
    public static boolean isEscapedBackslash(@NotNull CharSequence text, int startOffset, int backslashOffset) {
        if (text.charAt(backslashOffset) != '\\') {
            return true;
        }
        boolean escaped = false;
        for (int i = startOffset; i < backslashOffset; ++i) {
            escaped = text.charAt(i) == '\\' ? !escaped : false;
        }
        return escaped;
    }

    @Contract(pure=true)
    @NotNull
    public static String replace(@NotNull String text, @NotNull List<String> from, @NotNull List<String> to) {
        return Strings.replace(text, from, to);
    }

    @Contract(pure=true)
    public static String @NotNull [] filterEmptyStrings(String @NotNull [] strings2) {
        int emptyCount = 0;
        for (String string2 : strings2) {
            if (string2 != null && !string2.isEmpty()) continue;
            ++emptyCount;
        }
        if (emptyCount == 0) {
            return strings2;
        }
        String[] result = ArrayUtil.newStringArray(strings2.length - emptyCount);
        int count = 0;
        for (String string3 : strings2) {
            if (string3 == null || string3.isEmpty()) continue;
            result[count++] = string3;
        }
        return result;
    }

    @Contract(pure=true)
    public static int countNewLines(@NotNull CharSequence text) {
        return StringUtil.countChars(text, '\n');
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c) {
        return Strings.countChars(text, c);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int offset, boolean stopAtOtherChar) {
        return Strings.countChars(text, c, offset, stopAtOtherChar);
    }

    @Contract(pure=true)
    public static int countChars(@NotNull CharSequence text, char c, int start, int end, boolean stopAtOtherChar) {
        return Strings.countChars(text, c, start, end, stopAtOtherChar);
    }

    @Contract(pure=true)
    @Nullable
    public static String joinOrNull(String ... args2) {
        StringBuilder r = new StringBuilder();
        for (String arg2 : args2) {
            if (arg2 == null) {
                return null;
            }
            r.append(arg2);
        }
        return r.toString();
    }

    @Contract(pure=true)
    @Nullable
    public static String getPropertyName(@NotNull String methodName) {
        if (methodName.startsWith("get")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return Introspector.decapitalize(methodName.substring(2));
        }
        if (methodName.startsWith("set")) {
            return Introspector.decapitalize(methodName.substring(3));
        }
        return null;
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierStart(c);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifierPart(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || Character.isJavaIdentifierPart(c);
    }

    @Contract(pure=true)
    private static boolean isJavaIdentifierStart(int cp) {
        return cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || Character.isJavaIdentifierStart(cp);
    }

    @Contract(pure=true)
    private static boolean isJavaIdentifierPart(int cp) {
        return cp >= 48 && cp <= 57 || cp >= 97 && cp <= 122 || cp >= 65 && cp <= 90 || Character.isJavaIdentifierPart(cp);
    }

    @Contract(pure=true)
    public static boolean isJavaIdentifier(@NotNull String text) {
        int len = text.length();
        if (len == 0) {
            return false;
        }
        int point = text.codePointAt(0);
        if (!StringUtil.isJavaIdentifierStart(point)) {
            return false;
        }
        for (int i = Character.charCount(point); i < len; i += Character.charCount(point)) {
            point = text.codePointAt(i);
            if (StringUtil.isJavaIdentifierPart(point)) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeProperty(@NotNull String input, boolean isKey) {
        StringBuilder escaped = new StringBuilder(input.length());
        block8: for (int i = 0; i < input.length(); ++i) {
            char ch = input.charAt(i);
            switch (ch) {
                case ' ': {
                    if (isKey && i == 0) {
                        escaped.append('\\');
                    }
                    escaped.append(' ');
                    continue block8;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block8;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block8;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block8;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    escaped.append('\\');
                    escaped.append(ch);
                    continue block8;
                }
                default: {
                    if ('\u0014' < ch && ch < '\u007f') {
                        escaped.append(ch);
                        continue block8;
                    }
                    escaped.append("\\u");
                    escaped.append(Character.forDigit(ch >> 12 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 8 & 0xF, 16));
                    escaped.append(Character.forDigit(ch >> 4 & 0xF, 16));
                    escaped.append(Character.forDigit(ch & 0xF, 16));
                }
            }
        }
        return escaped.toString();
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getQualifiedName(@Nullable @NonNls String packageName, @NotNull @NonNls String className) {
        if (packageName == null || packageName.isEmpty()) {
            return className;
        }
        return packageName + '.' + className;
    }

    @Contract(pure=true)
    public static int compareVersionNumbers(@Nullable String v1, @Nullable String v2) {
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[._\\-]");
        String[] part2 = v2.split("[._\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? Integer.valueOf(p1).compareTo(Integer.valueOf(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length != part2.length) {
            String[] parts;
            boolean left = part1.length > idx;
            String[] stringArray = parts = left ? part1 : part2;
            while (idx < parts.length) {
                String p = parts[idx];
                int cmp = p.matches("\\d+") ? Integer.valueOf(p).compareTo(0) : 1;
                if (cmp != 0) {
                    return left ? cmp : -cmp;
                }
                ++idx;
            }
        }
        return 0;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, char c) {
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(c, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    public static int getOccurrenceCount(@NotNull String text, @NotNull String s) {
        int res = 0;
        for (int i = 0; i < text.length() && (i = text.indexOf(s, i)) >= 0; ++i) {
            ++res;
        }
        return res;
    }

    @Contract(pure=true)
    @NotNull
    public static String fixVariableNameDerivedFromPropertyName(@NotNull String name) {
        if (StringUtil.isEmptyOrSpaces(name)) {
            return name;
        }
        char c = name.charAt(0);
        if (StringUtil.isVowel(c)) {
            return "an" + Character.toUpperCase(c) + name.substring(1);
        }
        return "a" + Character.toUpperCase(c) + name.substring(1);
    }

    @Contract(pure=true)
    @NotNull
    public static String sanitizeJavaIdentifier(@NotNull String name) {
        StringBuilder result = new StringBuilder(name.length());
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (!Character.isJavaIdentifierPart(ch)) continue;
            if (result.length() == 0 && !Character.isJavaIdentifierStart(ch)) {
                result.append("_");
            }
            result.append(ch);
        }
        return result.toString();
    }

    public static void assertValidSeparators(@NotNull CharSequence s) {
        int i;
        char[] chars = CharArrayUtil.fromSequenceWithoutCopying(s);
        int slashRIndex = -1;
        if (chars != null) {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (chars[i] != '\r') continue;
                slashRIndex = i;
                break;
            }
        } else {
            int len = s.length();
            for (i = 0; i < len; ++i) {
                if (s.charAt(i) != '\r') continue;
                slashRIndex = i;
                break;
            }
        }
        if (slashRIndex != -1) {
            String context = String.valueOf(StringUtil.last(s.subSequence(0, slashRIndex), 10, true)) + StringUtil.first(s.subSequence(slashRIndex, s.length()), 10, true);
            context = StringUtil.escapeStringCharacters(context);
            throw new AssertionError((Object)("Wrong line separators: '" + context + "' at offset " + slashRIndex));
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String tail(@NotNull String s, int idx) {
        return idx >= s.length() ? "" : s.substring(idx);
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLines(@NotNull String string2) {
        return StringUtil.splitByLines(string2, true);
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLines(@NotNull String string2, boolean excludeEmptyStrings) {
        return (excludeEmptyStrings ? Splitters.EOL_SPLIT_PATTERN : Splitters.EOL_SPLIT_PATTERN_WITH_EMPTY).split(string2);
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLinesDontTrim(@NotNull String string2) {
        return Splitters.EOL_SPLIT_DONT_TRIM_PATTERN.split(string2);
    }

    @Contract(pure=true)
    public static String @NotNull [] splitByLinesKeepSeparators(@NotNull String string2) {
        return Splitters.EOL_SPLIT_KEEP_SEPARATORS.split(string2);
    }

    @Contract(pure=true)
    @NotNull
    public static List<Pair<String, Integer>> getWordsWithOffset(@NotNull String s) {
        ArrayList<Pair<String, Integer>> res = new ArrayList<Pair<String, Integer>>();
        s = s + " ";
        StringBuilder name = new StringBuilder();
        int startInd = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i))) {
                if (name.length() <= 0) continue;
                res.add((Pair<String, Integer>)Pair.create((Object)name.toString(), (Object)startInd));
                name.setLength(0);
                startInd = -1;
                continue;
            }
            if (startInd == -1) {
                startInd = i;
            }
            name.append(s.charAt(i));
        }
        return res;
    }

    @Contract(pure=true)
    public static int naturalCompare(@Nullable String string1, @Nullable String string2) {
        return NaturalComparator.INSTANCE.compare(string1, string2);
    }

    @Contract(pure=true)
    public static boolean isDecimalDigit(char c) {
        return Strings.isDecimalDigit(c);
    }

    @Contract(value="null -> false")
    public static boolean isNotNegativeNumber(@Nullable CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (StringUtil.isDecimalDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Contract(pure=true)
    public static int compare(@Nullable String s1, @Nullable String s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return ignoreCase ? s1.compareToIgnoreCase(s2) : s1.compareTo(s2);
    }

    @Contract(pure=true)
    public static int compare(@Nullable CharSequence s1, @Nullable CharSequence s2, boolean ignoreCase) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        int length1 = s1.length();
        int length2 = s2.length();
        for (int i = 0; i < length1 && i < length2; ++i) {
            int diff = Strings.compare(s1.charAt(i), s2.charAt(i), ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return length1 - length2;
    }

    @Contract(pure=true)
    public static int comparePairs(@Nullable String s1, @Nullable String t1, @Nullable String s2, @Nullable String t2, boolean ignoreCase) {
        int compare = StringUtil.compare(s1, s2, ignoreCase);
        return compare != 0 ? compare : StringUtil.compare(t1, t2, ignoreCase);
    }

    @Contract(pure=true)
    public static boolean equals(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal((CharSequence)s1, (CharSequence)s2, (boolean)true);
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreCase(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return StringUtilRt.equal((CharSequence)s1, (CharSequence)s2, (boolean)false);
    }

    @Contract(pure=true)
    public static boolean equalsIgnoreWhitespaces(@Nullable CharSequence s1, @Nullable CharSequence s2) {
        return Strings.equalsIgnoreWhitespaces(s1, s2);
    }

    @Contract(pure=true)
    public static boolean equalsTrimWhitespaces(@NotNull CharSequence s1, @NotNull CharSequence s2) {
        return Strings.equalsTrimWhitespaces(s1, s2);
    }

    @NotNull
    public static String collapseWhiteSpace(@NotNull CharSequence s) {
        StringBuilder result = new StringBuilder();
        boolean space = false;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char ch = s.charAt(i);
            if (StringUtil.isWhiteSpace(ch)) {
                if (space) continue;
                space = true;
                continue;
            }
            if (space && result.length() > 0) {
                result.append(' ');
            }
            result.append(ch);
            space = false;
        }
        return result.toString();
    }

    @Contract(pure=true)
    public static boolean findIgnoreCase(@Nullable String toFind, String ... where) {
        for (String string2 : where) {
            if (!StringUtil.equalsIgnoreCase(toFind, string2)) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static int compare(char c1, char c2, boolean ignoreCase) {
        return Strings.compare(c1, c2, ignoreCase);
    }

    @Contract(pure=true)
    @NotNull
    public static String formatLinks(@NotNull String message) {
        Pattern linkPattern = Pattern.compile("http://[a-zA-Z\\d./\\-+]+");
        StringBuffer result = new StringBuffer();
        Matcher m = linkPattern.matcher(message);
        while (m.find()) {
            m.appendReplacement(result, "<a href=\"" + m.group() + "\">" + m.group() + "</a>");
        }
        m.appendTail(result);
        return result.toString();
    }

    @Contract(pure=true)
    public static boolean isHexDigit(char c) {
        return '0' <= c && c <= '9' || 'a' <= c && c <= 'f' || 'A' <= c && c <= 'F';
    }

    @Contract(pure=true)
    public static boolean isOctalDigit(char c) {
        return '0' <= c && c <= '7';
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength) {
        return StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String trimMiddle(@NotNull String text, int maxLength) {
        return StringUtil.shortenTextWithEllipsis(text, maxLength, maxLength >> 1, true);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, @NotNull String symbol) {
        int textLength = text.length();
        if (textLength > maxLength) {
            int prefixLength = maxLength - suffixLength - symbol.length();
            assert (prefixLength >= 0);
            return text.substring(0, prefixLength) + symbol + text.substring(textLength - suffixLength);
        }
        return text;
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenTextWithEllipsis(@NotNull String text, int maxLength, int suffixLength, boolean useEllipsisSymbol) {
        String symbol = useEllipsisSymbol ? ELLIPSIS : THREE_DOTS;
        return StringUtil.shortenTextWithEllipsis(text, maxLength, suffixLength, symbol);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength, boolean useEllipsisSymbol) {
        return StringUtil.shortenTextWithEllipsis(path, maxLength, (int)((double)maxLength * 0.7), useEllipsisSymbol);
    }

    @Contract(pure=true)
    @NotNull
    public static String shortenPathWithEllipsis(@NotNull String path, int maxLength) {
        return StringUtil.shortenPathWithEllipsis(path, maxLength, false);
    }

    @Contract(pure=true)
    public static boolean charsEqualIgnoreCase(char a, char b) {
        return Strings.charsEqualIgnoreCase(a, b);
    }

    @Contract(pure=true)
    public static char toUpperCase(char a) {
        return Strings.toUpperCase(a);
    }

    @Contract(value="null -> null; !null -> !null", pure=true)
    public static String toUpperCase(String s) {
        return Strings.toUpperCase(s);
    }

    @Contract(pure=true)
    public static char toLowerCase(char a) {
        return Strings.toLowerCase(a);
    }

    @Contract(pure=true)
    public static boolean isUpperCase(@NotNull CharSequence sequence) {
        for (int i = 0; i < sequence.length(); ++i) {
            if (Character.isUpperCase(sequence.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static LineSeparator detectSeparators(@NotNull CharSequence text) {
        int index = StringUtil.indexOfAny(text, "\n\r");
        if (index == -1) {
            return null;
        }
        LineSeparator lineSeparator = StringUtil.getLineSeparatorAt(text, index);
        if (lineSeparator == null) {
            throw new AssertionError();
        }
        return lineSeparator;
    }

    @Nullable
    public static LineSeparator getLineSeparatorAt(@NotNull CharSequence text, int index) {
        if (index < 0 || index >= text.length()) {
            return null;
        }
        char ch = text.charAt(index);
        if (ch == '\r') {
            return index + 1 < text.length() && text.charAt(index + 1) == '\n' ? LineSeparator.CRLF : LineSeparator.CR;
        }
        return ch == '\n' ? LineSeparator.LF : null;
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text) {
        return Strings.convertLineSeparators(text);
    }

    @Contract(pure=true)
    @NotNull
    public static String convertLineSeparators(@NotNull String text, @NotNull String newSeparator) {
        return StringUtilRt.convertLineSeparators((String)text, (String)newSeparator);
    }

    @Contract(pure=true)
    public static int parseInt(@Nullable String string2, int defaultValue) {
        return StringUtilRt.parseInt((String)string2, (int)defaultValue);
    }

    @Contract(pure=true)
    public static long parseLong(@Nullable String string2, long defaultValue) {
        return StringUtilRt.parseLong((String)string2, (long)defaultValue);
    }

    @Contract(pure=true)
    public static double parseDouble(@Nullable String string2, double defaultValue) {
        return StringUtilRt.parseDouble((String)string2, (double)defaultValue);
    }

    @Contract(pure=true)
    public static <E extends Enum<E>> E parseEnum(@NotNull String string2, E defaultValue, @NotNull Class<E> clazz) {
        return (E)StringUtilRt.parseEnum((String)string2, defaultValue, clazz);
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getShortName(@NotNull Class<?> aClass) {
        return StringUtilRt.getShortName(aClass);
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getShortName(@NotNull @NonNls String fqName) {
        return StringUtilRt.getShortName((String)fqName);
    }

    @Contract(pure=true)
    @NotNull
    @NlsSafe
    public static String getShortName(@NotNull @NonNls String fqName, char separator) {
        return StringUtilRt.getShortName((String)fqName, (char)separator);
    }

    public static boolean isShortNameOf(@NotNull String fqName, @NotNull String shortName) {
        if (fqName.length() < shortName.length()) {
            return false;
        }
        if (fqName.length() == shortName.length()) {
            return fqName.equals(shortName);
        }
        int diff = fqName.length() - shortName.length();
        if (fqName.charAt(diff - 1) != '.') {
            return false;
        }
        return fqName.regionMatches(diff, shortName, 0, shortName.length());
    }

    @Contract(value="null->null;!null->!null")
    static String toShortString(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            return o.toString();
        }
        String className = o.getClass().getName();
        String s = o.toString();
        if (!s.startsWith(className)) {
            return s;
        }
        return s.length() > className.length() && !Character.isLetter(s.charAt(className.length())) ? StringUtil.trimStart(s, className) : s;
    }

    @Contract(pure=true)
    @NotNull
    public static CharSequence newBombedCharSequence(@NotNull CharSequence sequence, long delay) {
        final long myTime = System.currentTimeMillis() + delay;
        return new BombedCharSequence(sequence){

            @Override
            protected void checkCanceled() {
                long l = System.currentTimeMillis();
                if (l >= myTime) {
                    throw new ProcessCanceledException();
                }
            }
        };
    }

    public static boolean trimEnd(@NotNull StringBuilder buffer, @NotNull CharSequence end) {
        if (StringUtil.endsWith(buffer, end)) {
            buffer.delete(buffer.length() - end.length(), buffer.length());
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean isBetween(@NotNull String string2, @NotNull String smallPart, @NotNull String bigPart) {
        String s = StringUtil.toLowerCase(string2);
        return s.startsWith(StringUtil.toLowerCase(smallPart)) && StringUtil.toLowerCase(bigPart).startsWith(s);
    }

    public static boolean hasUpperCaseChar(@NotNull String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowerCaseChar(@NotNull String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static String replaceUnicodeEscapeSequences(String text) {
        if (text == null) {
            return null;
        }
        Matcher matcher = UNICODE_CHAR.matcher(text);
        if (!matcher.find()) {
            return text;
        }
        matcher.reset();
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text.length());
        while (matcher.find()) {
            sb.append(text, lastEnd, matcher.start());
            char c = (char)Integer.parseInt(matcher.group().substring(2), 16);
            sb.append(c);
            lastEnd = matcher.end();
        }
        sb.append(text.substring(lastEnd));
        return sb.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String toHexString(byte @NotNull [] bytes) {
        String digits = "0123456789abcdef";
        StringBuilder sb = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            sb.append(digits.charAt(b >> 4 & 0xF)).append(digits.charAt(b & 0xF));
        }
        return sb.toString();
    }

    @Contract(pure=true)
    public static byte @NotNull [] parseHexString(@NotNull String str) {
        int len = str.length();
        if (len % 2 != 0) {
            throw new IllegalArgumentException("Non-even-length: " + str);
        }
        byte[] bytes = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            bytes[i / 2] = (byte)((Character.digit(str.charAt(i), 16) << 4) + Character.digit(str.charAt(i + 1), 16));
        }
        return bytes;
    }

    @Contract(pure=true)
    public static boolean isLatinAlphanumeric(@Nullable CharSequence str) {
        if (StringUtil.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z' || Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    @Contract(value="null -> null; !null->!null", pure=true)
    public static String internEmptyString(String s) {
        return s == null ? null : (s.isEmpty() ? "" : s);
    }

    public static int skipWhitespaceForward(@NotNull CharSequence text, int pos) {
        int length = text.length();
        while (pos < length && StringUtil.isWhitespaceOrTab(text.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    public static int skipWhitespaceBackward(@NotNull CharSequence text, int pos) {
        while (pos > 0 && StringUtil.isWhitespaceOrTab(text.charAt(pos - 1))) {
            --pos;
        }
        return pos;
    }

    private static boolean isWhitespaceOrTab(char c) {
        return c == ' ' || c == '\t';
    }

    @Deprecated
    @Nls
    @NotNull
    public static String naturalJoin(List<String> strings2) {
        if (strings2.isEmpty()) {
            return "";
        }
        if (strings2.size() == 1) {
            return strings2.get(0);
        }
        String lastWord = strings2.get(strings2.size() - 1);
        String leadingWords = StringUtil.join(strings2.subList(0, strings2.size() - 1), ", ");
        return leadingWords + " and " + lastWord;
    }

    private static final class MyHtml2Text
    extends HTMLEditorKit.ParserCallback {
        @NotNull
        private final StringBuilder myBuffer = new StringBuilder();
        private final boolean myIsSkipStyleTag;
        private boolean myIsStyleTagOpened;

        private MyHtml2Text(boolean isSkipStyleTag) {
            this.myIsSkipStyleTag = isSkipStyleTag;
        }

        void parse(@NotNull Reader in) throws IOException {
            this.myBuffer.setLength(0);
            new ParserDelegator().parse(in, this, Boolean.TRUE);
        }

        @Override
        public void handleText(char @NotNull [] text, int pos) {
            if (!this.myIsStyleTagOpened) {
                this.myBuffer.append(text);
            }
        }

        @Override
        public void handleStartTag(@NotNull HTML.Tag tag, MutableAttributeSet set, int i) {
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = true;
            }
            this.handleTag(tag);
        }

        @Override
        public void handleEndTag(@NotNull HTML.Tag tag, int pos) {
            if (this.myIsSkipStyleTag && "style".equals(tag.toString())) {
                this.myIsStyleTagOpened = false;
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set, int i) {
            this.handleTag(tag);
        }

        private void handleTag(@NotNull HTML.Tag tag) {
            if (tag.breaksFlow() && this.myBuffer.length() > 0) {
                this.myBuffer.append(System.lineSeparator());
            }
        }

        @NotNull
        String getText() {
            return this.myBuffer.toString();
        }
    }

    private static final class Splitters {
        private static final Pattern EOL_SPLIT_KEEP_SEPARATORS = Pattern.compile("(?<=(\r\n|\n))|(?<=\r)(?=[^\n])");
        private static final Pattern EOL_SPLIT_PATTERN = Pattern.compile(" *(\r|\n|\r\n)+ *");
        private static final Pattern EOL_SPLIT_PATTERN_WITH_EMPTY = Pattern.compile(" *(\r|\n|\r\n) *");
        private static final Pattern EOL_SPLIT_DONT_TRIM_PATTERN = Pattern.compile("(\r|\n|\r\n)+");

        private Splitters() {
        }
    }

    public static abstract class BombedCharSequence
    implements CharSequence {
        private final CharSequence delegate;
        private int i;
        private boolean myDefused;

        protected BombedCharSequence(@NotNull CharSequence sequence) {
            this.delegate = sequence;
        }

        @Override
        public int length() {
            this.check();
            return this.delegate.length();
        }

        @Override
        public char charAt(int i) {
            this.check();
            return this.delegate.charAt(i);
        }

        protected void check() {
            if (this.myDefused) {
                return;
            }
            if ((++this.i & 0x3FF) == 0) {
                this.checkCanceled();
            }
        }

        public final void defuse() {
            this.myDefused = true;
        }

        @Override
        @NotNull
        public String toString() {
            this.check();
            return this.delegate.toString();
        }

        protected abstract void checkCanceled();

        @Override
        @NotNull
        public CharSequence subSequence(int i, int i1) {
            this.check();
            return this.delegate.subSequence(i, i1);
        }
    }
}

