/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.util.ArrayUtilRt;
import com.intellij.util.text.CharArrayCharSequence;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class LineTokenizer {
    private int myOffset;
    private int myLength;
    private int myLineSeparatorLength;
    private boolean atEnd;
    private final CharSequence myText;

    public static String @NotNull [] tokenize(CharSequence chars, boolean includeSeparators) {
        return LineTokenizer.tokenize(chars, includeSeparators, true);
    }

    public static String @NotNull [] tokenize(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        List<String> strings2 = LineTokenizer.tokenizeIntoList(chars, includeSeparators, skipLastEmptyLine);
        return strings2.isEmpty() ? ArrayUtilRt.EMPTY_STRING_ARRAY : ArrayUtilRt.toStringArray(strings2);
    }

    @NotNull
    public static List<String> tokenizeIntoList(CharSequence chars, boolean includeSeparators) {
        return LineTokenizer.tokenizeIntoList(chars, includeSeparators, true);
    }

    @NotNull
    public static List<String> tokenizeIntoList(CharSequence chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        if (chars == null || chars.length() == 0) {
            return Collections.emptyList();
        }
        LineTokenizer tokenizer = new LineTokenizer(chars);
        ArrayList<String> lines = new ArrayList<String>();
        while (!tokenizer.atEnd()) {
            int offset = tokenizer.getOffset();
            String line = includeSeparators ? chars.subSequence(offset, offset + tokenizer.getLength() + tokenizer.getLineSeparatorLength()).toString() : chars.subSequence(offset, offset + tokenizer.getLength()).toString();
            lines.add(line);
            tokenizer.advance();
        }
        if (!skipLastEmptyLine && LineTokenizer.stringEndsWithSeparator(tokenizer)) {
            lines.add("");
        }
        return lines;
    }

    public static int calcLineCount(@NotNull CharSequence chars, boolean skipLastEmptyLine) {
        int lineCount = 0;
        if (chars.length() != 0) {
            LineTokenizer tokenizer = new LineTokenizer(chars);
            while (!tokenizer.atEnd()) {
                ++lineCount;
                tokenizer.advance();
            }
            if (!skipLastEmptyLine && LineTokenizer.stringEndsWithSeparator(tokenizer)) {
                ++lineCount;
            }
        }
        return lineCount;
    }

    public static String @NotNull [] tokenize(char @NotNull [] chars, boolean includeSeparators) {
        return LineTokenizer.tokenize(chars, includeSeparators, true);
    }

    public static String @NotNull [] tokenize(char @NotNull [] chars, boolean includeSeparators, boolean skipLastEmptyLine) {
        return LineTokenizer.tokenize(chars, 0, chars.length, includeSeparators, skipLastEmptyLine);
    }

    public static String @NotNull [] tokenize(char @NotNull [] chars, int startOffset, int endOffset, boolean includeSeparators, boolean skipLastEmptyLine) {
        return LineTokenizer.tokenize(new CharArrayCharSequence(chars, startOffset, endOffset), includeSeparators, skipLastEmptyLine);
    }

    private static boolean stringEndsWithSeparator(@NotNull LineTokenizer tokenizer) {
        return tokenizer.getLineSeparatorLength() > 0;
    }

    public static String @NotNull [] tokenize(char @NotNull [] chars, int startOffset, int endOffset, boolean includeSeparators) {
        return LineTokenizer.tokenize(chars, startOffset, endOffset, includeSeparators, true);
    }

    public LineTokenizer(@NotNull CharSequence text) {
        this.myText = text;
        this.myOffset = 0;
        this.advance();
    }

    public LineTokenizer(char @NotNull [] text, int startOffset, int endOffset) {
        this(new CharArrayCharSequence(text, startOffset, endOffset));
    }

    public boolean atEnd() {
        return this.atEnd;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getLength() {
        return this.myLength;
    }

    public int getLineSeparatorLength() {
        return this.myLineSeparatorLength;
    }

    public void advance() {
        char c;
        int i = this.myOffset + this.myLength + this.myLineSeparatorLength;
        int textLength = this.myText.length();
        if (i >= textLength) {
            this.atEnd = true;
            return;
        }
        while (i < textLength && (c = this.myText.charAt(i)) != '\r' && c != '\n') {
            ++i;
        }
        this.myOffset += this.myLength + this.myLineSeparatorLength;
        this.myLength = i - this.myOffset;
        this.myLineSeparatorLength = 0;
        if (i == textLength) {
            return;
        }
        char first = this.myText.charAt(i);
        if (first == '\r' || first == '\n') {
            this.myLineSeparatorLength = 1;
        }
        if (++i == textLength) {
            return;
        }
        char second = this.myText.charAt(i);
        if (first == '\r' && second == '\n') {
            this.myLineSeparatorLength = 2;
        }
    }
}

