/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class InjectorMatchingEndFinder {
    public static int findMatchingEnd(@NotNull String startSymbol, @NotNull String endSymbol, @NotNull String text, int afterStartIdx) {
        if (afterStartIdx < 0) {
            return -1;
        }
        int totalNumStarts = 1;
        int lookFrom = afterStartIdx;
        while (totalNumStarts > 0) {
            --totalNumStarts;
            int nextEndIdx = text.indexOf(endSymbol, lookFrom);
            if (nextEndIdx == -1) {
                return -1;
            }
            int numStarts = InjectorMatchingEndFinder.getOccurrenceCount(text, lookFrom, nextEndIdx, startSymbol);
            if (numStarts > 0) {
                totalNumStarts += numStarts;
            }
            lookFrom = nextEndIdx + endSymbol.length();
            if (totalNumStarts != 0) continue;
            return nextEndIdx;
        }
        return -1;
    }

    @Contract(pure=true)
    private static int getOccurrenceCount(@NotNull String text, int from, int toExcluding, String s) {
        int res = 0;
        int i = from;
        int limit = Math.min(text.length(), toExcluding);
        while (i < limit && (i = text.indexOf(s, i)) >= 0 && i < limit) {
            ++res;
            i += s.length();
        }
        return res;
    }
}

