/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlChunk;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class HtmlBuilder {
    private final List<HtmlChunk> myChunks = new ArrayList<HtmlChunk>();

    @Contract(value="_ -> this")
    public HtmlBuilder append(@NotNull HtmlChunk chunk) {
        if (!chunk.isEmpty()) {
            this.myChunks.add(chunk);
        }
        return this;
    }

    @Contract(value="_ -> this")
    public HtmlBuilder append(@NotNull HtmlBuilder builder) {
        if (this == builder) {
            throw new IllegalArgumentException("Cannot add builder to itself");
        }
        this.myChunks.addAll(builder.myChunks);
        return this;
    }

    @Contract(value="_ -> this")
    public HtmlBuilder append(@NotNull @Nls String text) {
        return this.append(HtmlChunk.text(text));
    }

    @Contract(value="_ -> this")
    public HtmlBuilder appendRaw(@NotNull @Nls String rawHtml) {
        return this.append(HtmlChunk.raw(rawHtml));
    }

    @Contract(value="_, _ -> this")
    public HtmlBuilder appendLink(@NotNull @NonNls String target, @NotNull @Nls String text) {
        return this.append(HtmlChunk.link(target, text));
    }

    @Contract(value="_, _ -> this")
    public HtmlBuilder appendWithSeparators(@NotNull HtmlChunk separator, @NotNull Iterable<? extends HtmlChunk> children2) {
        boolean first = true;
        for (HtmlChunk htmlChunk : children2) {
            if (!first) {
                this.append(separator);
            }
            first = false;
            this.append(htmlChunk);
        }
        return this;
    }

    @Contract(value=" -> this")
    public HtmlBuilder nbsp() {
        return this.append(HtmlChunk.nbsp());
    }

    @Contract(value="_ -> this")
    public HtmlBuilder nbsp(int count) {
        return this.append(HtmlChunk.nbsp(count));
    }

    @Contract(value=" -> this")
    public HtmlBuilder br() {
        return this.append(HtmlChunk.br());
    }

    @Contract(value=" -> this")
    public HtmlBuilder hr() {
        return this.append(HtmlChunk.hr());
    }

    @Contract(pure=true)
    @NotNull
    public HtmlChunk.Element wrapWith(@NotNull @NonNls String tag) {
        return HtmlChunk.tag(tag).children(this.myChunks.toArray(new HtmlChunk[0]));
    }

    @Contract(pure=true)
    @NotNull
    public HtmlChunk.Element wrapWith(@NotNull HtmlChunk.Element element) {
        return element.children(this.myChunks.toArray(new HtmlChunk[0]));
    }

    @Contract(pure=true)
    @NotNull
    public HtmlChunk.Element wrapWithHtmlBody() {
        return this.wrapWith("body").wrapWith("html");
    }

    @Contract(pure=true)
    public boolean isEmpty() {
        return this.myChunks.isEmpty();
    }

    public HtmlChunk toFragment() {
        if (this.myChunks.isEmpty()) {
            return HtmlChunk.empty();
        }
        if (this.myChunks.size() == 1) {
            return this.myChunks.get(0);
        }
        return new HtmlChunk.Fragment(new ArrayList<HtmlChunk>(this.myChunks));
    }

    @Contract(pure=true)
    @NlsSafe
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (HtmlChunk chunk : this.myChunks) {
            chunk.appendTo(sb);
        }
        return sb.toString();
    }

    public void clear() {
        this.myChunks.clear();
    }

    public void clearAndAppend(@NotNull HtmlChunk chunk) {
        this.clear();
        this.append(chunk);
    }
}

