/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.StringUtilRt;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.time.Duration;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class Formats {
    private static final String[] TIME_UNITS = new String[]{"ms", "s", "m", "h", "d"};
    private static final long[] TIME_MULTIPLIERS = new long[]{1L, 1000L, 60L, 60L, 24L};

    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize) {
        return StringUtilRt.formatFileSize((long)fileSize);
    }

    @Contract(pure=true)
    @NotNull
    public static String formatFileSize(long fileSize, @NotNull String unitSeparator) {
        return StringUtilRt.formatFileSize((long)fileSize, (String)unitSeparator);
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(long duration) {
        return Formats.formatDuration(duration, " ");
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(@NotNull Duration duration) {
        return Formats.formatDuration(duration.toMillis());
    }

    @Contract(pure=true)
    @NotNull
    public static String formatDuration(long duration, @NotNull String unitSeparator) {
        return Formats.formatDuration(duration, unitSeparator, Integer.MAX_VALUE);
    }

    @Contract(pure=true)
    @NotNull
    private static String formatDuration(long duration, @NotNull String unitSeparator, int maxFragments) {
        long multiplier;
        int i;
        LongArrayList unitValues = new LongArrayList();
        IntArrayList unitIndices = new IntArrayList();
        long count = duration;
        for (i = 1; i < TIME_UNITS.length && count > 0L && count >= (multiplier = TIME_MULTIPLIERS[i]); ++i) {
            long remainder = count % multiplier;
            count /= multiplier;
            if (remainder == 0L && unitValues.isEmpty()) continue;
            unitValues.add(0, remainder);
            unitIndices.add(0, i - 1);
        }
        unitValues.add(0, count);
        unitIndices.add(0, i - 1);
        if (unitValues.size() > maxFragments) {
            int lastUnitIndex = unitIndices.getInt(maxFragments - 1);
            long lastMultiplier = TIME_MULTIPLIERS[lastUnitIndex];
            if (unitValues.getLong(maxFragments) > lastMultiplier / 2L) {
                long increment = lastMultiplier - unitValues.getLong(maxFragments);
                for (int unit = lastUnitIndex - 1; unit > 0; --unit) {
                    increment *= TIME_MULTIPLIERS[unit];
                }
                return Formats.formatDuration(duration + increment, unitSeparator, maxFragments);
            }
        }
        StringBuilder result = new StringBuilder();
        for (i = 0; i < unitValues.size() && i < maxFragments; ++i) {
            if (i > 0) {
                result.append(" ");
            }
            result.append(unitValues.getLong(i)).append(unitSeparator).append(TIME_UNITS[unitIndices.getInt(i)]);
        }
        return result.toString();
    }
}

