/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.util.MathUtil;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Registry {
    private static Reference<Map<String, String>> bundledRegistry;
    @NonNls
    public static final String REGISTRY_BUNDLE = "misc.registry";
    private static final RegistryValueListener EMPTY_VALUE_LISTENER;
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final Map<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private Map<String, RegistryKeyDescriptor> myContributedKeys = Collections.emptyMap();
    private static final Registry ourInstance;
    private volatile boolean isLoaded;
    @NotNull
    private volatile RegistryValueListener valueChangeListener = EMPTY_VALUE_LISTENER;

    @NotNull
    public static RegistryValue get(@NonNls @NotNull String key) {
        return Registry.getInstance().doGet(key);
    }

    @ApiStatus.Internal
    @NotNull
    public static RegistryValue _getWithoutStateCheck(@NonNls @NotNull String key) {
        return ourInstance.doGet(key);
    }

    @NotNull
    private RegistryValue doGet(@NonNls @NotNull String key) {
        return this.myValues.computeIfAbsent(key, s -> new RegistryValue(this, (String)s, this.myContributedKeys.get(s)));
    }

    public static boolean is(@NonNls @NotNull String key) throws MissingResourceException {
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@NonNls @NotNull String key, boolean defaultValue) {
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            return defaultValue;
        }
        try {
            return Registry.getInstance().doGet(key).asBoolean();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static int intValue(@NonNls @NotNull String key) throws MissingResourceException {
        return Registry.getInstance().doGet(key).asInteger();
    }

    public static int intValue(@NonNls @NotNull String key, int defaultValue) {
        if (!LoadingState.COMPONENTS_LOADED.isOccurred()) {
            LoadingState.COMPONENTS_REGISTERED.checkOccurred();
            return defaultValue;
        }
        try {
            return Registry.getInstance().doGet(key).asInteger();
        }
        catch (MissingResourceException ignore) {
            return defaultValue;
        }
    }

    public static int intValue(@NonNls @NotNull String key, int defaultValue, int minValue, int maxValue) {
        if (defaultValue < minValue || defaultValue > maxValue) {
            throw new IllegalArgumentException("Wrong values for default:min:max (" + defaultValue + ":" + minValue + ":" + maxValue + ")");
        }
        return MathUtil.clamp(Registry.intValue(key, defaultValue), minValue, maxValue);
    }

    public static double doubleValue(@NonNls @NotNull String key) throws MissingResourceException {
        return Registry.get(key).asDouble();
    }

    @NotNull
    public static String stringValue(@NonNls @NotNull String key) throws MissingResourceException {
        return Registry.get(key).asString();
    }

    public static Color getColor(@NonNls @NotNull String key, Color defaultValue) throws MissingResourceException {
        return Registry.get(key).asColor(defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static Map<String, String> loadFromBundledConfig() throws IOException {
        Map<String, String> result;
        Reference<Map<String, String>> bundleRef = bundledRegistry;
        Map<String, String> map = result = bundleRef == null ? null : bundleRef.get();
        if (result != null) {
            return result;
        }
        InputStream stream = Registry.class.getClassLoader().getResourceAsStream("misc/registry.properties");
        if (stream == null) {
            return null;
        }
        final HashMap<String, String> map2 = new HashMap<String, String>(1800);
        try {
            new Properties(){

                @Override
                public Object put(Object key, Object value) {
                    return map2.put((String)key, (String)value);
                }
            }.load(stream);
        }
        finally {
            stream.close();
        }
        bundledRegistry = new SoftReference(map2);
        return map2;
    }

    @NlsSafe
    @Nullable
    public String getBundleValueOrNull(@NonNls @NotNull String key) {
        RegistryKeyDescriptor contributed = this.myContributedKeys.get(key);
        if (contributed != null) {
            return contributed.getDefaultValue();
        }
        try {
            Map<String, String> bundle = Registry.loadFromBundledConfig();
            return bundle == null ? null : bundle.get(key);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @NlsSafe
    @NotNull
    String getBundleValue(@NonNls @NotNull String key) throws MissingResourceException {
        RegistryKeyDescriptor contributed = this.myContributedKeys.get(key);
        if (contributed != null) {
            return contributed.getDefaultValue();
        }
        String result = this.getBundleValueOrNull(key);
        if (result == null) {
            throw new MissingResourceException("Registry key " + key + " is not defined", REGISTRY_BUNDLE, key);
        }
        return result;
    }

    @NotNull
    public static Registry getInstance() {
        LoadingState.COMPONENTS_LOADED.checkOccurred();
        return ourInstance;
    }

    @NotNull
    public Element getState() {
        Element state = new Element("registry");
        for (Map.Entry<String, String> entry : this.myUserProperties.entrySet()) {
            Element entryElement = new Element("entry");
            entryElement.setAttribute("key", entry.getKey());
            entryElement.setAttribute("value", entry.getValue());
            state.addContent(entryElement);
        }
        return state;
    }

    @ApiStatus.Internal
    @Nullable
    public static Map<String, String> loadState(@Nullable Element state) {
        Registry registry = ourInstance;
        if (state == null) {
            registry.isLoaded = true;
            return null;
        }
        registry.myUserProperties.clear();
        for (Element eachEntry : state.getChildren("entry")) {
            RegistryValue registryValue;
            String key = eachEntry.getAttributeValue("key");
            String value = eachEntry.getAttributeValue("value");
            if (key == null || value == null || !(registryValue = registry.doGet(key)).isChangedFromDefault(value, registry)) continue;
            registry.myUserProperties.put(key, value);
            registryValue.resetCache();
        }
        registry.isLoaded = true;
        return registry.myUserProperties;
    }

    @ApiStatus.Internal
    public static void markAsLoaded() {
        Registry.ourInstance.isLoaded = true;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @NotNull
    Map<String, String> getUserProperties() {
        return this.myUserProperties;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<RegistryValue> getAll() {
        Map<String, String> bundle = null;
        try {
            bundle = Registry.loadFromBundledConfig();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Set<Object> keys = bundle == null ? Collections.emptySet() : bundle.keySet();
        ArrayList<RegistryValue> result = new ArrayList<RegistryValue>();
        Registry instance = ourInstance;
        Map<String, RegistryKeyDescriptor> contributedKeys = instance.myContributedKeys;
        for (String string2 : keys) {
            if (string2.endsWith(".description") || string2.endsWith(".restartRequired") || contributedKeys.containsKey(string2)) continue;
            result.add(instance.doGet(string2));
        }
        for (String string3 : contributedKeys.keySet()) {
            result.add(instance.doGet(string3));
        }
        return result;
    }

    void restoreDefaults() {
        HashMap<String, String> old = new HashMap<String, String>(this.myUserProperties);
        Registry instance = Registry.getInstance();
        for (String key : old.keySet()) {
            String v = instance.getBundleValueOrNull(key);
            if (v == null) {
                this.myValues.remove(key);
                continue;
            }
            RegistryValue value = instance.myValues.get(key);
            if (value == null) continue;
            value.setValue(v);
        }
    }

    boolean isInDefaultState() {
        return this.myUserProperties.isEmpty();
    }

    public boolean isRestartNeeded() {
        return Registry.isRestartNeeded(this.myUserProperties);
    }

    private static boolean isRestartNeeded(@NotNull Map<String, String> map) {
        Registry instance = Registry.getInstance();
        for (String s : map.keySet()) {
            RegistryValue eachValue = instance.doGet(s);
            if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
            return true;
        }
        return false;
    }

    @ApiStatus.Internal
    public static synchronized void setKeys(@NotNull Map<String, RegistryKeyDescriptor> descriptors) {
        Registry.ourInstance.myContributedKeys = descriptors;
    }

    @ApiStatus.Internal
    public static synchronized void mutateContributedKeys(@NotNull Function<? super Map<String, RegistryKeyDescriptor>, ? extends Map<String, RegistryKeyDescriptor>> mutator) {
        Registry.ourInstance.myContributedKeys = mutator.apply(Registry.ourInstance.myContributedKeys);
    }

    @ApiStatus.Internal
    public static void setValueChangeListener(@Nullable RegistryValueListener listener) {
        Registry.ourInstance.valueChangeListener = listener == null ? EMPTY_VALUE_LISTENER : listener;
    }

    @NotNull
    RegistryValueListener getValueChangeListener() {
        return this.valueChangeListener;
    }

    static {
        EMPTY_VALUE_LISTENER = new RegistryValueListener(){};
        ourInstance = new Registry();
    }
}

