/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.diagnostic.LoadingState;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.EarlyAccessRegistryManager;
import com.intellij.openapi.util.registry.RegistryManager;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0010J$\u0010\u0017\u001a\u00020\u00152\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0016\u001a\u00020\u0010H\u0002J\u0006\u0010\u0018\u001a\u00020\u0019R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR \u0010\r\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001b"}, d2={"Lcom/intellij/openapi/util/registry/EarlyAccessRegistryManager;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "configFile", "Ljava/nio/file/Path;", "getConfigFile", "()Ljava/nio/file/Path;", "configFile$delegate", "Lkotlin/Lazy;", "lazyMap", "Lkotlin/Lazy;", "Ljava/util/concurrent/ConcurrentHashMap;", "", "map", "getMap", "()Ljava/util/concurrent/ConcurrentHashMap;", "getBoolean", "", "key", "getOrFromSystemProperty", "syncAndFlush", "", "MyListener", "intellij.platform.core"})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class EarlyAccessRegistryManager {
    @NotNull
    public static final EarlyAccessRegistryManager INSTANCE = new EarlyAccessRegistryManager();
    @NotNull
    private static final Lazy configFile$delegate = LazyKt.lazy((Function0)configFile.2.INSTANCE);
    @NotNull
    private static final Lazy<ConcurrentHashMap<String, String>> lazyMap = LazyKt.lazy((Function0)lazyMap.1.INSTANCE);

    private EarlyAccessRegistryManager() {
    }

    private final Path getConfigFile() {
        Lazy lazy = configFile$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-configFile>(...)");
        return (Path)object;
    }

    private final ConcurrentHashMap<String, String> getMap() {
        if (lazyMap.isInitialized()) {
            ConcurrentHashMap map = (ConcurrentHashMap)lazyMap.getValue();
            return map.isEmpty() ? null : map;
        }
        return null;
    }

    private final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(EarlyAccessRegistryManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        return logger;
    }

    public final boolean getBoolean(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (((CharSequence)key).length() == 0) {
            this.getLOG().error("Empty key");
            return false;
        }
        ConcurrentHashMap map = (ConcurrentHashMap)lazyMap.getValue();
        if (!LoadingState.APP_STARTED.isOccurred()) {
            return this.getOrFromSystemProperty(map, key);
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
        ComponentManager $this$serviceOrNull$iv = application;
        boolean $i$f$serviceOrNull = false;
        RegistryManager registryManager = $this$serviceOrNull$iv.getService(RegistryManager.class);
        if (registryManager == null) {
            return this.getOrFromSystemProperty(map, key);
        }
        RegistryManager registryManager2 = registryManager;
        boolean value = registryManager2.is(key);
        map.putIfAbsent(key, String.valueOf(value));
        return value;
    }

    private final boolean getOrFromSystemProperty(ConcurrentHashMap<String, String> map, String key) {
        String string2 = map.get(key);
        if (string2 == null) {
            string2 = System.getProperty(key);
        }
        return Boolean.parseBoolean(string2);
    }

    public final void syncAndFlush() {
        ConcurrentHashMap<String, String> concurrentHashMap = this.getMap();
        if (concurrentHashMap == null) {
            return;
        }
        ConcurrentHashMap<String, String> map = concurrentHashMap;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
        ComponentManager $this$serviceIfCreated$iv = application;
        boolean $i$f$serviceIfCreated = false;
        RegistryManager registryManager = $this$serviceIfCreated$iv.getServiceIfCreated(RegistryManager.class);
        if (registryManager == null) {
            return;
        }
        RegistryManager registryManager2 = registryManager;
        try {
            List lines = new ArrayList();
            Set set = map.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"map.keys");
            for (String key : CollectionsKt.sorted((Iterable)set)) {
                try {
                    String value;
                    Intrinsics.checkNotNullExpressionValue((Object)registryManager2.get(key).asString(), (String)"registryManager.get(key).asString()");
                    Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
                    lines.add(key);
                    lines.add(value);
                }
                catch (MissingResourceException missingResourceException) {}
            }
            if (lines.isEmpty()) {
                Files.deleteIfExists(this.getConfigFile());
            } else {
                Files.createDirectories(this.getConfigFile().getParent(), new FileAttribute[0]);
                Files.write(this.getConfigFile(), (Iterable<? extends CharSequence>)lines, StandardCharsets.UTF_8, new OpenOption[0]);
            }
        }
        catch (Throwable e) {
            this.getLOG().error("cannot save early access registry", e);
        }
    }

    public static final /* synthetic */ Path access$getConfigFile(EarlyAccessRegistryManager $this) {
        return $this.getConfigFile();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lcom/intellij/openapi/util/registry/EarlyAccessRegistryManager$MyListener;", "Lcom/intellij/openapi/util/registry/RegistryValueListener;", "()V", "afterValueChanged", "", "value", "Lcom/intellij/openapi/util/registry/RegistryValue;", "intellij.platform.core"})
    private static final class MyListener
    implements RegistryValueListener {
        @Override
        public void afterValueChanged(@NotNull RegistryValue value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            ConcurrentHashMap concurrentHashMap = INSTANCE.getMap();
            if (concurrentHashMap == null) {
                return;
            }
            ConcurrentHashMap map = concurrentHashMap;
            String string2 = value.getKey();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"value.key");
            String key = string2;
            if (map.containsKey(key)) {
                map.put(key, value.asString());
            }
        }
    }
}

