/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.objectTree;

import com.intellij.openapi.diagnostic.UntraceableException;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.Interner;
import com.intellij.util.containers.WeakInterner;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class ThrowableInterner {
    private static final Interner<Throwable> myTraceInterner = new WeakInterner<Throwable>(new HashingStrategy<Throwable>(){

        @Override
        public int hashCode(Throwable throwable) {
            return ThrowableInterner.computeHashCode(throwable);
        }

        @Override
        public boolean equals(Throwable o1, Throwable o2) {
            if (o1 == o2) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            if (!Comparing.equal(o1.getClass(), o2.getClass())) {
                return false;
            }
            if (!Objects.equals(o1.getMessage(), o2.getMessage())) {
                return false;
            }
            if (!this.equals(o1.getCause(), o2.getCause())) {
                return false;
            }
            Object[] backtrace1 = ThrowableInterner.getBacktrace(o1);
            Object[] backtrace2 = ThrowableInterner.getBacktrace(o2);
            if (backtrace1 != null && backtrace2 != null) {
                return Arrays.deepEquals(backtrace1, backtrace2);
            }
            return Arrays.equals(o1.getStackTrace(), o2.getStackTrace());
        }
    });
    private static final Field BACKTRACE_FIELD = ReflectionUtil.getDeclaredField(Throwable.class, "backtrace");

    private ThrowableInterner() {
    }

    private static int computeHashCode(@NotNull Throwable throwable) {
        String message = throwable.getMessage();
        if (message != null) {
            return message.hashCode();
        }
        return ThrowableInterner.computeTraceHashCode(throwable);
    }

    public static int computeTraceHashCode(@NotNull Throwable throwable) {
        Object[] backtrace = ThrowableInterner.getBacktrace(throwable);
        if (backtrace == null) {
            return Arrays.hashCode(throwable.getStackTrace());
        }
        for (Object element : backtrace) {
            if (!(element instanceof Object[])) continue;
            return Arrays.hashCode((Object[])element);
        }
        return 0;
    }

    public static int computeAccurateTraceHashCode(@NotNull Throwable throwable) {
        Object[] backtrace = ThrowableInterner.getBacktrace(throwable);
        if (backtrace == null) {
            Object[] trace = throwable instanceof UntraceableException ? null : throwable.getStackTrace();
            return Arrays.hashCode(trace);
        }
        return Arrays.deepHashCode(backtrace);
    }

    private static Object[] getBacktrace(@NotNull Throwable throwable) {
        Object backtrace;
        try {
            backtrace = BACKTRACE_FIELD != null ? BACKTRACE_FIELD.get(throwable) : null;
        }
        catch (Throwable e) {
            return null;
        }
        return backtrace instanceof Object[] ? (Object[])backtrace : null;
    }

    public static void clearBacktrace(@NotNull Throwable throwable) {
        try {
            throwable.setStackTrace(new StackTraceElement[0]);
            if (BACKTRACE_FIELD != null) {
                BACKTRACE_FIELD.set(throwable, null);
            }
        }
        catch (Throwable e) {
            ExceptionUtil.rethrowAllAsUnchecked(e);
        }
    }

    @NotNull
    public static Throwable intern(@NotNull Throwable throwable) {
        return ThrowableInterner.getBacktrace(throwable) == null ? throwable : myTraceInterner.intern(throwable);
    }

    public static void clearInternedBacktraces() {
        for (Throwable t : myTraceInterner.getValues()) {
            ThrowableInterner.clearBacktrace(t);
        }
        myTraceInterner.clear();
    }
}

