/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
public final class WindowsRegistryUtil {
    private WindowsRegistryUtil() {
    }

    @Nullable
    private static String trimToValue(@Nullable StringBuilder output) {
        if (output == null) {
            return null;
        }
        int pos = output.lastIndexOf("  ");
        int pos2 = output.lastIndexOf("\t");
        if ((pos = Math.max(pos, pos2)) == -1) {
            return null;
        }
        output.delete(0, pos + 1);
        String blackList = "\r\n \"";
        int startPos = 0;
        int endPos = output.length() - 1;
        while (true) {
            if (startPos >= endPos) {
                return null;
            }
            if (blackList.indexOf(output.charAt(startPos)) == -1) break;
            ++startPos;
        }
        while (blackList.indexOf(output.charAt(endPos)) != -1) {
            --endPos;
        }
        return output.subSequence(startPos, endPos + 1).toString();
    }

    @NotNull
    public static List<String> readRegistryBranch(@NotNull String location) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder output = WindowsRegistryUtil.doReadBranch(location);
        if (output != null) {
            int pos = output.indexOf(location);
            while (pos != -1) {
                String section;
                int pos2 = output.indexOf("\r\n", pos + location.length());
                if (pos2 > pos + location.length() && !(section = output.substring(pos + location.length() + 1, pos2)).contains("\\")) {
                    result.add(section);
                }
                pos = output.indexOf(location, pos + location.length());
            }
        }
        return result;
    }

    private static StringBuilder doReadBranch(@NotNull String location) {
        return WindowsRegistryUtil.readRegistrySilently("reg query \"" + location + "\"");
    }

    @Nullable
    public static String readRegistryDefault(@NonNls @NotNull String location) {
        return WindowsRegistryUtil.trimToValue(WindowsRegistryUtil.readRegistrySilently("reg query \"" + location + "\" /ve"));
    }

    @Nullable
    public static String readRegistryValue(@NonNls @NotNull String location, @NonNls @NotNull String key) {
        return WindowsRegistryUtil.trimToValue(WindowsRegistryUtil.readRegistrySilently("reg query \"" + location + "\" /v " + key));
    }

    @Nullable
    private static StringBuilder readRegistrySilently(@NonNls @NotNull String command) {
        try {
            String text = WindowsRegistryUtil.readRegistry(command);
            return new StringBuilder(text);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    @ApiStatus.Internal
    public static String readRegistry(@NonNls @NotNull String command) throws IOException, InterruptedException {
        Process process = Runtime.getRuntime().exec(command);
        InputStream is = null;
        ByteArrayOutputStream os = null;
        try {
            byte[] buffer = new byte[128];
            is = process.getInputStream();
            os = new ByteArrayOutputStream();
            int length = is.read(buffer);
            while (length > 0) {
                os.write(buffer, 0, length);
                length = is.read(buffer);
            }
            String string2 = new String(os.toByteArray(), StandardCharsets.UTF_8);
            return string2;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
            process.waitFor();
        }
    }
}

