/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.UnsyncByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class StreamUtil {
    public static final int BUFFER_SIZE = 8192;

    private StreamUtil() {
    }

    public static int copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        int read;
        byte[] buffer = new byte[8192];
        int total = 0;
        while ((read = inputStream.read(buffer)) > 0) {
            outputStream.write(buffer, 0, read);
            total += read;
        }
        return total;
    }

    public static byte @NotNull [] readBytes(@NotNull InputStream inputStream) throws IOException {
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.copy(inputStream, outputStream);
        return outputStream.toByteArray();
    }

    @NotNull
    public static String readText(@NotNull Reader reader) throws IOException {
        return StreamUtil.readChars(reader).toString();
    }

    @NotNull
    public static String convertSeparators(@NotNull String s) {
        char[] source = s.toCharArray();
        char[] converted = StreamUtil.convertSeparators(source);
        return converted == source ? s : new String(converted);
    }

    public static char @NotNull [] readTextAndConvertSeparators(@NotNull Reader reader) throws IOException {
        CharArrayWriter chars = StreamUtil.readChars(reader);
        return StreamUtil.convertSeparators(chars.toCharArray());
    }

    private static char[] convertSeparators(char[] buffer) {
        int dst = 0;
        int prev = 32;
        for (int n : buffer) {
            switch (n) {
                case 13: {
                    buffer[dst++] = 10;
                    break;
                }
                case 10: {
                    if (prev == 13) break;
                    buffer[dst++] = 10;
                    break;
                }
                default: {
                    buffer[dst++] = n;
                }
            }
            prev = n;
        }
        if (dst == buffer.length) {
            return buffer;
        }
        return Arrays.copyOf(buffer, dst);
    }

    private static CharArrayWriter readChars(Reader reader) throws IOException {
        int read;
        CharArrayWriter writer = new CharArrayWriter();
        char[] buffer = new char[2048];
        while ((read = reader.read(buffer)) > 0) {
            writer.write(buffer, 0, read);
        }
        return writer;
    }

    @Deprecated
    public static int copyStreamContent(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        return StreamUtil.copy(inputStream, outputStream);
    }

    @Deprecated
    public static byte @NotNull [] loadFromStream(@NotNull InputStream inputStream) throws IOException {
        UnsyncByteArrayOutputStream outputStream = new UnsyncByteArrayOutputStream();
        try {
            StreamUtil.copy(inputStream, outputStream);
        }
        finally {
            inputStream.close();
        }
        return outputStream.toByteArray();
    }

    @Deprecated
    @NotNull
    public static String readText(@NotNull InputStream inputStream) throws IOException {
        return StreamUtil.readText(inputStream, StandardCharsets.UTF_8);
    }

    @Deprecated
    @NotNull
    public static String readText(@NotNull InputStream inputStream, @NotNull String encoding) throws IOException {
        return StreamUtil.readText(inputStream, Charset.forName(encoding));
    }

    @Deprecated
    @NotNull
    public static String readText(@NotNull InputStream inputStream, @NotNull Charset encoding) throws IOException {
        byte[] data = StreamUtil.loadFromStream(inputStream);
        return new String(data, encoding);
    }

    @Deprecated
    @NotNull
    public static String readTextFrom(@NotNull Reader reader) throws IOException {
        return StreamUtil.readText(reader);
    }

    @Deprecated
    public static void closeStream(@Nullable Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                Logger.getInstance(StreamUtil.class).error(e);
            }
        }
    }
}

