/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtilRt;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OSAgnosticPathUtil {
    public static final Comparator<String> COMPARATOR = (path1, path2) -> {
        if (path1 == path2) {
            return 0;
        }
        if (path1 == null) {
            return -1;
        }
        if (path2 == null) {
            return 1;
        }
        int length1 = path1.length();
        int length2 = path2.length();
        boolean ignoreCase = !SystemInfoRt.isFileSystemCaseSensitive;
        for (int pos = 0; pos < length1 && pos < length2; ++pos) {
            char ch2;
            char ch1 = path1.charAt(pos);
            if (ch1 == (ch2 = path2.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return -1;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return -1;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return 1;
            }
            int diff = StringUtil.compare(ch1, ch2, ignoreCase);
            if (diff == 0) continue;
            return diff;
        }
        return Integer.compare(length1, length2);
    };

    private OSAgnosticPathUtil() {
    }

    public static boolean isAbsolute(@NotNull String path) {
        return path.startsWith("/") || OSAgnosticPathUtil.isAbsoluteDosPath(path) || OSAgnosticPathUtil.isUncPath(path);
    }

    public static boolean isAbsoluteDosPath(@NotNull String path) {
        return path.length() > 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path) && PathUtilRt.isSeparator((char)path.charAt(2));
    }

    public static boolean startsWithWindowsDrive(@NotNull String path) {
        return path.length() >= 2 && path.charAt(1) == ':' && OSAgnosticPathUtil.isDriveLetter(path.charAt(0));
    }

    public static boolean isUncPath(@NotNull String path) {
        if (!PathUtilRt.startsWithSeparatorSeparator((CharSequence)path)) {
            return false;
        }
        int slashIndex = OSAgnosticPathUtil.nextSeparatorIndex(path, 2);
        return PathUtilRt.isWindowsUNCRoot((CharSequence)path, (int)(slashIndex == -1 ? path.length() : slashIndex));
    }

    public static boolean startsWith(@NotNull String path, @NotNull String prefix) {
        char next;
        int pathLength = path.length();
        int prefixLength = prefix.length();
        if (prefixLength == 0) {
            return true;
        }
        if (prefixLength > pathLength) {
            return false;
        }
        boolean ignoreCase = !SystemInfoRt.isFileSystemCaseSensitive;
        for (int pos = 0; pos < pathLength && pos < prefixLength; ++pos) {
            char ch2;
            char ch1 = path.charAt(pos);
            if (ch1 == (ch2 = prefix.charAt(pos))) continue;
            if (ch1 == '/') {
                if (ch2 == '\\') continue;
                return false;
            }
            if (ch1 == '\\') {
                if (ch2 == '/') continue;
                return false;
            }
            if (ch2 == '/' || ch2 == '\\') {
                return false;
            }
            if (StringUtil.compare(ch1, ch2, ignoreCase) == 0) continue;
            return false;
        }
        if (pathLength == prefixLength) {
            return true;
        }
        char lastPrefixChar = prefix.charAt(prefixLength - 1);
        int slashOrSeparatorIdx = prefixLength;
        if (lastPrefixChar == '/' || lastPrefixChar == '\\') {
            slashOrSeparatorIdx = prefixLength - 1;
        }
        return (next = path.charAt(slashOrSeparatorIdx)) == '/' || next == '\\';
    }

    @Nullable
    public static String getParent(@NotNull String path) {
        int length = path.length();
        int lastSeparator = PathUtilRt.lastSeparatorIndex((CharSequence)path, (int)(length - 1));
        if (lastSeparator < 0) {
            return null;
        }
        if (lastSeparator == length - 1) {
            lastSeparator = PathUtilRt.lastSeparatorIndex((CharSequence)path, (int)(length - 2));
        }
        if (lastSeparator < 0) {
            return null;
        }
        if (PathUtilRt.startsWithSeparatorSeparator((CharSequence)path)) {
            int prevSeparator;
            int slashIndex = OSAgnosticPathUtil.nextSeparatorIndex(path, 2);
            if (lastSeparator > 1 && slashIndex != -1 && slashIndex <= lastSeparator && PathUtilRt.isWindowsUNCRoot((CharSequence)path, (int)slashIndex) && (prevSeparator = PathUtilRt.lastSeparatorIndex((CharSequence)path, (int)(lastSeparator - 1))) > 1) {
                return path.substring(0, lastSeparator);
            }
            return null;
        }
        if (lastSeparator == 2 && OSAgnosticPathUtil.startsWithWindowsDrive(path)) {
            return path.substring(0, 3);
        }
        return path.substring(0, lastSeparator == 0 ? 1 : lastSeparator);
    }

    private static int nextSeparatorIndex(@NotNull String s, int start) {
        for (int i = start; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!PathUtilRt.isSeparator((char)c)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isDriveLetter(char c) {
        return 'A' <= c && c <= 'Z' || 'a' <= c && c <= 'z';
    }
}

