/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.BitUtil;
import com.sun.jna.platform.win32.Kernel32;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NioFiles {
    public static final BasicFileAttributes BROKEN_SYMLINK = new BasicFileAttributes(){
        private final FileTime ZERO = FileTime.fromMillis(0L);

        @Override
        public FileTime lastModifiedTime() {
            return this.ZERO;
        }

        @Override
        public FileTime lastAccessTime() {
            return this.ZERO;
        }

        @Override
        public FileTime creationTime() {
            return this.ZERO;
        }

        @Override
        public boolean isRegularFile() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isSymbolicLink() {
            return true;
        }

        @Override
        public boolean isOther() {
            return false;
        }

        @Override
        public long size() {
            return 0L;
        }

        @Override
        public Object fileKey() {
            return null;
        }
    };
    private static final Logger LOG = Logger.getInstance(NioFiles.class);
    private static final LinkOption[] NO_FOLLOW = new LinkOption[]{LinkOption.NOFOLLOW_LINKS};

    private NioFiles() {
    }

    @Nullable
    public static Path toPath(@NotNull String path) {
        try {
            return Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    @NotNull
    @NlsSafe
    public static String getFileName(@NotNull Path path) {
        Path name = path.getFileName();
        return (name != null ? name : path).toString();
    }

    @NotNull
    public static Path createDirectories(@NotNull Path path) throws IOException {
        try {
            NioFiles.tryCreateDirectory(path);
        }
        catch (FileAlreadyExistsException e) {
            throw e;
        }
        catch (IOException e) {
            Path parent = path.getParent();
            if (parent == null) {
                throw e;
            }
            NioFiles.createDirectories(parent);
            NioFiles.tryCreateDirectory(path);
        }
        return path;
    }

    private static void tryCreateDirectory(Path path) throws IOException {
        block2: {
            try {
                Files.createDirectory(path, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(path, new LinkOption[0])) break block2;
                throw e;
            }
        }
    }

    public static boolean isWritable(@NotNull Path path) {
        try {
            return Files.isWritable(path);
        }
        catch (SecurityException e) {
            return false;
        }
    }

    public static void setReadOnly(@NotNull Path path, boolean value) throws IOException {
        PosixFileAttributeView posixView = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
        if (posixView != null) {
            boolean modified;
            Set<PosixFilePermission> permissions = posixView.readAttributes().permissions();
            boolean bl = modified = value ? permissions.removeAll(Arrays.asList(PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OTHERS_WRITE)) : permissions.add(PosixFilePermission.OWNER_WRITE);
            if (modified) {
                posixView.setPermissions(permissions);
            }
        } else {
            DosFileAttributeView dosView = Files.getFileAttributeView(path, DosFileAttributeView.class, new LinkOption[0]);
            if (dosView != null) {
                dosView.setReadOnly(value);
            } else {
                throw new IOException("Not supported: " + path.getFileSystem());
            }
        }
    }

    public static void setExecutable(@NotNull Path file2) throws IOException {
        Set<PosixFilePermission> permissions;
        PosixFileAttributeView view = Files.getFileAttributeView(file2, PosixFileAttributeView.class, new LinkOption[0]);
        if (view != null && (permissions = view.readAttributes().permissions()).add(PosixFilePermission.OWNER_EXECUTE)) {
            view.setPermissions(permissions);
        }
    }

    @NotNull
    public static List<Path> list(@NotNull Path directory) {
        try {
            ArrayList<Path> files2 = new ArrayList<Path>();
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(directory);){
                for (Path path : stream) {
                    files2.add(path);
                }
            }
            return files2;
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
    }

    @NotNull
    public static BasicFileAttributes readAttributes(@NotNull Path path) throws IOException, SecurityException {
        try {
            return Files.readAttributes(path, BasicFileAttributes.class, NO_FOLLOW);
        }
        catch (AccessDeniedException | NoSuchFileException e) {
            throw e;
        }
        catch (FileSystemException e) {
            if (SystemInfo.isWindows && JnaLoader.isLoaded() && NioFiles.isNtfsReparsePoint(path)) {
                LOG.debug(e);
                return BROKEN_SYMLINK;
            }
            throw e;
        }
    }

    private static boolean isNtfsReparsePoint(Path path) {
        int attrs = Kernel32.INSTANCE.GetFileAttributes(path.toString());
        return attrs != -1 && BitUtil.isSet(attrs, 1024);
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory) throws IOException {
        FileUtilRt.deleteRecursively((Path)fileOrDirectory, null);
    }

    public static void deleteRecursively(@NotNull Path fileOrDirectory, @NotNull Consumer<Path> callback) throws IOException {
        FileUtilRt.deleteRecursively((Path)fileOrDirectory, callback::accept);
    }
}

