/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.BitUtil;
import java.io.IOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FileAttributes {
    public static final byte SYM_LINK = 1;
    public static final byte HIDDEN = 2;
    public static final byte READ_ONLY = 4;
    public static final FileAttributes BROKEN_SYMLINK = new FileAttributes(1, 0L, 0L);
    private static final int TYPE_SHIFT = 3;
    private static final int CASE_SENSITIVITY_SHIFT = 5;
    private final @Flags byte flags;
    public final long length;
    public final long lastModified;

    public FileAttributes(boolean isDirectory, boolean isSpecial, boolean isSymlink, boolean isHidden, long length, long lastModified, boolean isWritable) {
        this(isDirectory, isSpecial, isSymlink, isHidden, length, lastModified, isWritable, CaseSensitivity.UNKNOWN);
    }

    public FileAttributes(boolean isDirectory, boolean isSpecial, boolean isSymlink, boolean isHidden, long length, long lastModified, boolean isWritable, @NotNull CaseSensitivity caseSensitivity) {
        this(FileAttributes.flags(isDirectory, isSpecial, isSymlink, isHidden, isWritable, caseSensitivity), length, lastModified);
    }

    private FileAttributes(@Flags byte flags, long length, long lastModified) {
        if (flags != -1 && (flags & 0x80) != 0) {
            throw new IllegalArgumentException("Invalid flags: " + Integer.toBinaryString(flags));
        }
        if (length < 0L) {
            throw new IllegalArgumentException("Invalid length: " + length);
        }
        this.flags = flags;
        this.length = length;
        this.lastModified = lastModified;
    }

    private static @Flags byte flags(boolean isDirectory, boolean isSpecial, boolean isSymlink, boolean isHidden, boolean isWritable, CaseSensitivity sensitivity) {
        byte flags = 0;
        if (isSymlink) {
            flags = (byte)(flags | 1);
        }
        if (isHidden) {
            flags = (byte)(flags | 2);
        }
        if (!isWritable) {
            flags = (byte)(flags | 4);
        }
        int type_flags = (isSpecial ? 3 : (isDirectory ? 2 : 1)) << 3;
        flags = (byte)(flags | type_flags);
        flags = FileAttributes.packSensitivityIntoFlags(isDirectory ? sensitivity : CaseSensitivity.UNKNOWN, flags);
        return flags;
    }

    private static @Flags byte packSensitivityIntoFlags(CaseSensitivity sensitivity, byte flags) {
        int sensitivity_flags = sensitivity == CaseSensitivity.UNKNOWN ? 0 : (sensitivity == CaseSensitivity.SENSITIVE ? 1 : 2);
        flags = (byte)(flags | sensitivity_flags << 5);
        return flags;
    }

    public boolean isFile() {
        return (this.flags >> 3 & 3) == 1;
    }

    public boolean isDirectory() {
        return (this.flags >> 3 & 3) == 2;
    }

    public boolean isSpecial() {
        return !this.isDirectory() && (this.flags >> 3 & 3) == 3;
    }

    public boolean isSymLink() {
        return BitUtil.isSet(this.flags, (byte)1);
    }

    public boolean isHidden() {
        return BitUtil.isSet(this.flags, (byte)2);
    }

    public boolean isWritable() {
        return !BitUtil.isSet(this.flags, (byte)4);
    }

    @Nullable(value="`null` means an unknown type, typically a broken symlink")
    public @Nullable(value="`null` means an unknown type, typically a broken symlink") Type getType() {
        int type = this.flags >> 3 & 3;
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return Type.FILE;
            }
            case 2: {
                return Type.DIRECTORY;
            }
            case 3: {
                return Type.SPECIAL;
            }
        }
        throw new IllegalStateException("Invalid type flags: " + Integer.toBinaryString(this.flags));
    }

    @NotNull
    public CaseSensitivity areChildrenCaseSensitive() {
        if (!this.isDirectory()) {
            return CaseSensitivity.UNKNOWN;
        }
        int sensitivity_flags = this.flags >> 5 & 3;
        switch (sensitivity_flags) {
            case 0: {
                return CaseSensitivity.UNKNOWN;
            }
            case 1: {
                return CaseSensitivity.SENSITIVE;
            }
            case 2: {
                return CaseSensitivity.INSENSITIVE;
            }
        }
        throw new IllegalStateException("Invalid sensitivity flags: " + Integer.toBinaryString(sensitivity_flags));
    }

    @NotNull
    public FileAttributes withCaseSensitivity(@NotNull CaseSensitivity sensitivity) {
        byte newFlags = (byte)(this.flags & 0xFFFFFF9F);
        newFlags = FileAttributes.packSensitivityIntoFlags(sensitivity, newFlags);
        return new FileAttributes(newFlags, this.length, this.lastModified);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileAttributes that = (FileAttributes)o;
        if (this.flags != that.flags) {
            return false;
        }
        if (this.lastModified != that.lastModified) {
            return false;
        }
        return this.length == that.length;
    }

    public int hashCode() {
        int result = this.flags;
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (int)(this.lastModified ^ this.lastModified >>> 32);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[type:").append((Object)this.getType());
        if (BitUtil.isSet(this.flags, (byte)1)) {
            sb.append(" l");
        }
        if (BitUtil.isSet(this.flags, (byte)2)) {
            sb.append(" .");
        }
        if (BitUtil.isSet(this.flags, (byte)4)) {
            sb.append(" ro");
        }
        sb.append(" length:").append(this.length);
        sb.append(" modified:").append(this.lastModified);
        sb.append(" case sensitive: ").append((Object)this.areChildrenCaseSensitive());
        sb.append(']');
        return sb.toString();
    }

    @NotNull
    public static FileAttributes fromNio(@NotNull Path path, @NotNull BasicFileAttributes attrs) {
        boolean isSymbolicLink;
        boolean bl = isSymbolicLink = attrs.isSymbolicLink() || SystemInfo.isWindows && attrs.isOther() && attrs.isDirectory() && path.getParent() != null;
        if (isSymbolicLink) {
            try {
                attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
            }
            catch (IOException e) {
                return BROKEN_SYMLINK;
            }
        }
        boolean isHidden = false;
        boolean isWritable = false;
        if (SystemInfo.isWindows) {
            isHidden = path.getParent() != null && ((DosFileAttributes)attrs).isHidden();
            isWritable = attrs.isDirectory() || !((DosFileAttributes)attrs).isReadOnly();
        } else {
            try {
                isWritable = Files.isWritable(path);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        long lastModified = attrs.lastModifiedTime().toMillis();
        boolean isSpecial = attrs.isOther() && (!SystemInfo.isWindows || !attrs.isDirectory());
        return new FileAttributes(attrs.isDirectory(), isSpecial, isSymbolicLink, isHidden, attrs.size(), lastModified, isWritable);
    }

    public static enum CaseSensitivity {
        SENSITIVE,
        INSENSITIVE,
        UNKNOWN;

    }

    public static enum Type {
        FILE,
        DIRECTORY,
        SPECIAL;

    }

    @Target(value={ElementType.TYPE_USE})
    public static @interface Flags {
    }
}

