/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public final class TimeoutCachedValue<T>
implements Supplier<T> {
    private final long myTimeoutMs;
    @NotNull
    private final Supplier<? extends T> myValueSupplier;
    private long myLastCalcTime;
    private T myCache;

    public TimeoutCachedValue(long timeout, @NotNull TimeUnit unit, @NotNull Supplier<? extends T> valueSupplier) {
        this.myValueSupplier = valueSupplier;
        this.myTimeoutMs = unit.toMillis(timeout);
    }

    @Override
    public synchronized T get() {
        if (this.hasUpToDateValue()) {
            return this.myCache;
        }
        this.myCache = this.myValueSupplier.get();
        this.myLastCalcTime = System.currentTimeMillis();
        return this.myCache;
    }

    public synchronized boolean hasUpToDateValue() {
        return this.myTimeoutMs > System.currentTimeMillis() - this.myLastCalcTime;
    }
}

