/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class TextRangeScalarUtil {
    public static long toScalarRange(@NotNull Segment range) {
        return TextRangeScalarUtil.toScalarRange(range.getStartOffset(), range.getEndOffset());
    }

    public static long toScalarRange(int start, int end) {
        return (long)start << 32 | (long)end;
    }

    public static long deltaScalarRange(long range, int deltaStart, int deltaEnd) {
        return range + ((long)deltaStart << 32) + (long)deltaEnd;
    }

    public static long union(long range1, long range2) {
        if (range1 == range2) {
            return range1;
        }
        int start = Math.min(TextRangeScalarUtil.startOffset(range1), TextRangeScalarUtil.startOffset(range2));
        int end = Math.max(TextRangeScalarUtil.endOffset(range1), TextRangeScalarUtil.endOffset(range2));
        return TextRangeScalarUtil.toScalarRange(start, end);
    }

    public static int endOffset(long range) {
        return (int)range & Integer.MAX_VALUE;
    }

    public static int startOffset(long range) {
        return (int)(range >>> 32);
    }

    public static boolean contains(long outerRange, long innerRange) {
        return TextRangeScalarUtil.containsRange(outerRange, TextRangeScalarUtil.startOffset(innerRange), TextRangeScalarUtil.endOffset(innerRange));
    }

    public static boolean containsRange(long outerRange, int innerRangeStartOffset, int innerRangeEndOffset) {
        return TextRangeScalarUtil.startOffset(outerRange) <= innerRangeStartOffset && innerRangeEndOffset <= TextRangeScalarUtil.endOffset(outerRange);
    }

    public static boolean containsOffset(long range, int offset) {
        return TextRangeScalarUtil.startOffset(range) <= offset && offset <= TextRangeScalarUtil.endOffset(range);
    }

    public static boolean intersects(@NotNull TextRange thisRange, long otherRange) {
        return thisRange.intersects(TextRangeScalarUtil.startOffset(otherRange), TextRangeScalarUtil.endOffset(otherRange));
    }

    @NotNull
    public static TextRange create(long range) {
        return TextRange.create(TextRangeScalarUtil.startOffset(range), TextRangeScalarUtil.endOffset(range));
    }

    public static boolean equalsToRange(@NotNull TextRange thisRange, long otherRange) {
        return thisRange.getStartOffset() == TextRangeScalarUtil.startOffset(otherRange) && thisRange.getEndOffset() == TextRangeScalarUtil.endOffset(otherRange);
    }
}

