/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.WinBuildVersionKt;
import com.intellij.openapi.util.io.PathExecLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.lang.JavaVersion;
import com.intellij.util.system.CpuArch;
import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SystemInfo {
    public static final String OS_NAME = SystemInfoRt.OS_NAME;
    public static final String OS_VERSION = SystemInfoRt.OS_VERSION;
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = SystemInfo.getRtVersion(JAVA_VERSION);
    public static final String JAVA_VENDOR = System.getProperty("java.vm.vendor", "Unknown");
    public static final boolean isWindows = SystemInfoRt.isWindows;
    public static final boolean isMac = SystemInfoRt.isMac;
    public static final boolean isLinux = SystemInfoRt.isLinux;
    public static final boolean isFreeBSD = SystemInfoRt.isFreeBSD;
    public static final boolean isSolaris = SystemInfoRt.isSolaris;
    public static final boolean isUnix = SystemInfoRt.isUnix;
    public static final boolean isChromeOS = isLinux && SystemInfo.isCrostini();
    public static final boolean isOracleJvm = Strings.indexOfIgnoreCase(JAVA_VENDOR, "Oracle", 0) >= 0;
    public static final boolean isIbmJvm = Strings.indexOfIgnoreCase(JAVA_VENDOR, "IBM", 0) >= 0;
    public static final boolean isAzulJvm = Strings.indexOfIgnoreCase(JAVA_VENDOR, "Azul", 0) >= 0;
    public static final boolean isJetBrainsJvm = Strings.indexOfIgnoreCase(JAVA_VENDOR, "JetBrains", 0) >= 0;
    public static final boolean isMetalRendering = isMac && Boolean.getBoolean("sun.java2d.metal");
    public static final boolean isDCEVM = ManagementFactory.getRuntimeMXBean().getInputArguments().contains("-XX:+AllowEnhancedClassRedefinition");
    public static final boolean isWin7OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.1");
    public static final boolean isWin8OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.2");
    public static final boolean isWin10OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("10.0");
    public static final boolean isXWindow = SystemInfoRt.isXWindow;
    public static final boolean isWayland;
    public static final boolean isGNOME;
    public static final boolean isKDE;
    public static final boolean isXfce;
    public static final boolean isI3;
    public static final boolean isAppleSystemMenu;
    public static final boolean isJBSystemMenu;
    public static final boolean isMacSystemMenu;
    public static final boolean isFileSystemCaseSensitive;
    private static final NotNullLazyValue<Boolean> ourHasXdgOpen;
    private static final NotNullLazyValue<Boolean> ourHasXdgMime;
    @Deprecated
    public static final boolean isMacOSYosemite;
    public static final boolean isMacOSMojave;
    public static final boolean isMacOSCatalina;
    public static final boolean isMacOSBigSur;
    public static final boolean isMacOSMonterey;
    public static final boolean isMacOSVentura;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean is32Bit;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean is64Bit;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isMacOSLeopard;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isMacOSMountainLion;
    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static final boolean isWinVistaOrNewer;

    private static String getRtVersion(String fallback) {
        String rtVersion = System.getProperty("java.runtime.version");
        if (rtVersion != null && Character.isDigit(rtVersion.charAt(0))) {
            return rtVersion;
        }
        return fallback;
    }

    private static boolean isCrostini() {
        return new File("/dev/.cros_milestone").exists();
    }

    public static boolean isOsVersionAtLeast(@NotNull String version) {
        return StringUtil.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    public static boolean hasXdgOpen() {
        return isXWindow && ourHasXdgOpen.getValue() != false;
    }

    public static boolean hasXdgMime() {
        return isXWindow && ourHasXdgMime.getValue() != false;
    }

    @Nullable
    public static Long getWinBuildNumber() {
        if (!isWin10OrNewer) {
            return null;
        }
        return WinBuildVersionKt.getWinBuildNumber();
    }

    @NotNull
    public static String getMacOSMajorVersion() {
        return SystemInfo.getMacOSMajorVersion(OS_VERSION);
    }

    public static String getMacOSMajorVersion(String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%d.%d", parts[0], parts[1]);
    }

    @NotNull
    public static String getMacOSVersionCode() {
        return SystemInfo.getMacOSVersionCode(OS_VERSION);
    }

    @NotNull
    public static String getMacOSMajorVersionCode() {
        return SystemInfo.getMacOSMajorVersionCode(OS_VERSION);
    }

    @NotNull
    public static String getMacOSMinorVersionCode() {
        return SystemInfo.getMacOSMinorVersionCode(OS_VERSION);
    }

    @NotNull
    public static String getMacOSVersionCode(@NotNull String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), SystemInfo.normalize(parts[2]));
    }

    @NotNull
    public static String getMacOSMajorVersionCode(@NotNull String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), 0);
    }

    @NotNull
    public static String getMacOSMinorVersionCode(@NotNull String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%02d%02d", parts[1], parts[2]);
    }

    private static int[] getMacOSVersionParts(@NotNull String version) {
        List<String> parts = StringUtil.split(version, ".");
        while (parts.size() < 3) {
            parts.add("0");
        }
        return new int[]{SystemInfo.toInt(parts.get(0)), SystemInfo.toInt(parts.get(1)), SystemInfo.toInt(parts.get(2))};
    }

    public static String getOsName() {
        return isMac ? "macOS" : OS_NAME;
    }

    public static String getOsNameAndVersion() {
        return SystemInfo.getOsName() + ' ' + OS_VERSION;
    }

    private static int normalize(int number) {
        return Math.min(number, 9);
    }

    private static int toInt(String string2) {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isJavaVersionAtLeast(int major) {
        return JavaVersion.current().feature >= major;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isJavaVersionAtLeast(int major, int minor, int update) {
        return JavaVersion.current().compareTo(JavaVersion.compose(major, minor, update, 0, false)) >= 0;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static boolean isJavaVersionAtLeast(String v) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, v) >= 0;
    }

    static {
        if (isXWindow) {
            isWayland = System.getenv("WAYLAND_DISPLAY") != null;
            String desktop = System.getenv("XDG_CURRENT_DESKTOP");
            String gdmSession = System.getenv("GDMSESSION");
            isGNOME = desktop != null && desktop.contains("GNOME") || gdmSession != null && gdmSession.contains("gnome");
            isKDE = !isGNOME && (desktop != null && desktop.contains("KDE") || System.getenv("KDE_FULL_SESSION") != null);
            isXfce = !isGNOME && !isKDE && desktop != null && desktop.contains("XFCE");
            isI3 = !isGNOME && !isKDE && !isXfce && desktop != null && desktop.contains("i3");
        } else {
            isI3 = false;
            isXfce = false;
            isKDE = false;
            isGNOME = false;
            isWayland = false;
        }
        isAppleSystemMenu = isMac && Boolean.getBoolean("apple.laf.useScreenMenuBar");
        isJBSystemMenu = isMac && Boolean.getBoolean("jbScreenMenuBar.enabled");
        isMacSystemMenu = isAppleSystemMenu || isJBSystemMenu;
        isFileSystemCaseSensitive = SystemInfoRt.isFileSystemCaseSensitive;
        ourHasXdgOpen = PathExecLazyValue.create("xdg-open");
        ourHasXdgMime = PathExecLazyValue.create("xdg-mime");
        isMacOSYosemite = isMac && SystemInfo.isOsVersionAtLeast("10.10");
        isMacOSMojave = isMac && SystemInfo.isOsVersionAtLeast("10.14");
        isMacOSCatalina = isMac && SystemInfo.isOsVersionAtLeast("10.15");
        isMacOSBigSur = isMac && SystemInfo.isOsVersionAtLeast("10.16");
        isMacOSMonterey = isMac && SystemInfo.isOsVersionAtLeast("12.0");
        isMacOSVentura = isMac && SystemInfo.isOsVersionAtLeast("13.0");
        is32Bit = CpuArch.CURRENT.width == 32;
        is64Bit = CpuArch.CURRENT.width == 64;
        isMacOSLeopard = isMac;
        isMacOSMountainLion = isMac;
        isWinVistaOrNewer = isWindows;
    }
}

