/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public final class ShutDownTracker
implements Runnable {
    private final List<Thread> myThreads = Collections.synchronizedList(new ArrayList());
    private final ConcurrentLinkedDeque<Runnable> myShutdownTasks = new ConcurrentLinkedDeque();
    private final Thread myThread = new Thread((Runnable)this, "Shutdown tracker");

    private ShutDownTracker() {
        Runtime.getRuntime().addShutdownHook(this.myThread);
    }

    @NotNull
    public static ShutDownTracker getInstance() {
        return ShutDownTrackerHolder.ourInstance;
    }

    public static boolean isShutdownHookRunning() {
        return ShutDownTracker.getInstance().myThread.isAlive();
    }

    @Override
    public void run() {
        Runnable task;
        this.ensureStopperThreadsFinished();
        while ((task = this.myShutdownTasks.pollLast()) != null) {
            try {
                task.run();
            }
            catch (Throwable e) {
                try {
                    Logger.getInstance(ShutDownTracker.class).error(e);
                }
                catch (AssertionError assertionError) {}
            }
        }
    }

    public boolean waitFor(long timeout, @NotNull TimeUnit unit) {
        if (ShutDownTracker.isShutdownHookRunning()) {
            try {
                this.myThread.join(unit.toMillis(timeout));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return !this.myThread.isAlive();
        }
        return false;
    }

    public void ensureStopperThreadsFinished() {
        Thread[] threads = this.getStopperThreads();
        long started = System.currentTimeMillis();
        while (threads.length > 0) {
            Thread thread = threads[0];
            if (!thread.isAlive()) {
                if (this.isRegistered(thread)) {
                    Logger.getInstance(ShutDownTracker.class).error("Thread '" + thread.getName() + "' did not unregister itself from ShutDownTracker");
                    this.unregisterStopperThread(thread);
                }
            } else {
                long totalTimeWaited = System.currentTimeMillis() - started;
                if (totalTimeWaited > 3000L) {
                    thread.interrupt();
                }
                try {
                    thread.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            threads = this.getStopperThreads();
        }
    }

    private boolean isRegistered(@NotNull Thread thread) {
        return this.myThreads.contains(thread);
    }

    private Thread @NotNull [] getStopperThreads() {
        return this.myThreads.toArray(new Thread[0]);
    }

    private void unregisterStopperThread(@NotNull Thread thread) {
        this.myThreads.remove(thread);
    }

    public void executeWithStopperThread(@NotNull Thread thread, @NotNull Runnable runnable) {
        this.myThreads.add(thread);
        try {
            runnable.run();
        }
        finally {
            this.myThreads.remove(thread);
        }
    }

    public void registerShutdownTask(@NotNull Runnable task, @NotNull Disposable parentDisposable) {
        this.registerShutdownTask(task);
        Disposer.register(parentDisposable, () -> this.unregisterShutdownTask(task));
    }

    public void registerShutdownTask(@NotNull Runnable task) {
        this.myShutdownTasks.addLast(task);
    }

    public void unregisterShutdownTask(@NotNull Runnable task) {
        this.myShutdownTasks.remove(task);
    }

    private static class ShutDownTrackerHolder {
        private static final ShutDownTracker ourInstance = new ShutDownTracker();

        private ShutDownTrackerHolder() {
        }
    }
}

