/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.SafeJdomFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Verifier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class SafeStAXStreamBuilder {
    public static final SafeJdomFactory FACTORY = new SafeJdomFactory.BaseSafeJdomFactory();

    static Document buildDocument(@NotNull XMLStreamReader2 stream) throws XMLStreamException {
        int state = stream.getEventType();
        if (7 != state) {
            throw new XMLStreamException("JDOM requires that XMLStreamReaders are at their beginning when being processed.");
        }
        Document document = new Document();
        while (state != 8) {
            switch (state) {
                case 7: {
                    document.setBaseURI(stream.getLocation().getSystemId());
                    document.setProperty("ENCODING_SCHEME", stream.getCharacterEncodingScheme());
                    document.setProperty("STANDALONE", String.valueOf(stream.isStandalone()));
                    document.setProperty("ENCODING", stream.getEncoding());
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 11: {
                    break;
                }
                case 1: {
                    document.setRootElement(SafeStAXStreamBuilder.processElementFragment(stream, true, true, FACTORY));
                    break;
                }
                case 4: {
                    String badTxt = stream.getText();
                    if (Verifier.isAllXMLWhitespace(badTxt)) break;
                    throw new XMLStreamException("Unexpected XMLStream event at Document level: CHARACTERS (" + badTxt + ")");
                }
                default: {
                    throw new XMLStreamException("Unexpected XMLStream event at Document level:" + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new XMLStreamException("Unexpected end-of-XMLStreamReader");
        }
        return document;
    }

    public static Element build(@NotNull XMLStreamReader2 stream, boolean isIgnoreBoundaryWhitespace, boolean isNsSupported, @NotNull SafeJdomFactory factory) throws XMLStreamException {
        int state = stream.getEventType();
        if (state != 7) {
            throw new XMLStreamException("JDOM requires that XMLStreamReaders are at their beginning when being processed");
        }
        Element rootElement = null;
        while (state != 8) {
            switch (state) {
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: {
                    break;
                }
                case 1: {
                    rootElement = SafeStAXStreamBuilder.processElementFragment(stream, isIgnoreBoundaryWhitespace, isNsSupported, factory);
                    break;
                }
                default: {
                    throw new XMLStreamException("Unexpected XMLStream event " + state);
                }
            }
            if (stream.hasNext()) {
                state = stream.next();
                continue;
            }
            throw new XMLStreamException("Unexpected end-of-XMLStreamReader");
        }
        if (rootElement == null) {
            return new Element("empty");
        }
        return rootElement;
    }

    @NotNull
    public static Element processElementFragment(@NotNull XMLStreamReader2 reader, boolean isIgnoreBoundaryWhitespace, boolean isNsSupported, @NotNull SafeJdomFactory factory) throws XMLStreamException {
        Element fragment;
        Element current = fragment = SafeStAXStreamBuilder.processElement(reader, isNsSupported, factory);
        int depth = 1;
        block8: while (depth > 0 && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    Element tmp = SafeStAXStreamBuilder.processElement(reader, isNsSupported, factory);
                    current.addContent(tmp);
                    current = tmp;
                    ++depth;
                    continue block8;
                }
                case 2: {
                    current = current.getParentElement();
                    --depth;
                    continue block8;
                }
                case 12: {
                    current.addContent(factory.cdata(reader.getText()));
                    continue block8;
                }
                case 6: {
                    if (isIgnoreBoundaryWhitespace) continue block8;
                    current.addContent(factory.text(reader.getText()));
                    continue block8;
                }
                case 4: {
                    if (isIgnoreBoundaryWhitespace && reader.isWhiteSpace()) continue block8;
                    current.addContent(factory.text(reader.getText()));
                    continue block8;
                }
                case 3: 
                case 5: 
                case 9: {
                    continue block8;
                }
            }
            throw new XMLStreamException("Unexpected XMLStream event " + reader.getEventType(), reader.getLocation());
        }
        return fragment;
    }

    @NotNull
    private static Element processElement(@NotNull XMLStreamReader2 reader, boolean isNsSupported, @NotNull SafeJdomFactory factory) {
        int i;
        Element element = factory.element(reader.getLocalName(), isNsSupported ? Namespace.getNamespace(reader.getPrefix(), reader.getNamespaceURI()) : Namespace.NO_NAMESPACE);
        int len = reader.getAttributeCount();
        for (i = 0; i < len; ++i) {
            element.setAttribute(factory.attribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i), isNsSupported ? Namespace.getNamespace(reader.getAttributePrefix(i), reader.getAttributeNamespace(i)) : Namespace.NO_NAMESPACE));
        }
        if (isNsSupported) {
            len = reader.getNamespaceCount();
            for (i = 0; i < len; ++i) {
                element.addNamespaceDeclaration(Namespace.getNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i)));
            }
        }
        return element;
    }
}

