/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import org.jdom.Attribute;
import org.jdom.AttributeType;
import org.jdom.CDATA;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.Text;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public interface SafeJdomFactory {
    @NotNull
    public Element element(@NotNull String var1, @Nullable Namespace var2);

    @NotNull
    public Attribute attribute(@NotNull String var1, @NotNull String var2, @Nullable Namespace var3);

    @NotNull
    public Text text(@NotNull String var1);

    @NotNull
    public CDATA cdata(@NotNull String var1);

    public static final class BaseSafeJdomFactory
    implements SafeJdomFactory {
        @Override
        @NotNull
        public Element element(@NotNull String name, @Nullable Namespace namespace) {
            Element element = new Element(name, namespace);
            if (namespace != null) {
                element.setNamespace(namespace);
            }
            return element;
        }

        @Override
        @NotNull
        public Attribute attribute(@NotNull String name, @NotNull String value, @Nullable Namespace namespace) {
            return new Attribute(name, value, AttributeType.UNDECLARED, namespace);
        }

        @Override
        @NotNull
        public Text text(@NotNull String text) {
            return new Text(text);
        }

        @Override
        @NotNull
        public CDATA cdata(@NotNull String text) {
            return new CDATA(text);
        }
    }
}

