/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectNode;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.CollectionFactory;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

final class ObjectTree {
    private final Map<Disposable, ObjectNode> myObject2ParentNode = new Reference2ObjectOpenHashMap();
    private final Map<Disposable, Throwable> myDisposedObjects = CollectionFactory.createWeakIdentityMap(100, 0.5f);
    private static final Throwable UNKNOWN_TRACE = new Throwable();
    private final ObjectNode myRootNode = ObjectNode.createRootNode();
    private static final ThreadLocal<Throwable> ourTopmostDisposeTrace = new ThreadLocal();

    ObjectTree() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(@NotNull Disposable parent, @NotNull Disposable child) throws RuntimeException {
        if (parent == child) {
            throw new IllegalArgumentException("Cannot register to itself: " + parent);
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isDisposed(parent)) {
                throw new IncorrectOperationException("Sorry but parent: " + parent + " (" + parent.getClass() + ") has already been disposed (see the cause for stacktrace) so the child: " + child + " (" + child.getClass() + ") will never be disposed", this.getDisposalTrace(parent));
            }
            this.myDisposedObjects.remove(child);
            if (child instanceof Disposer.CheckedDisposableImpl) {
                ((Disposer.CheckedDisposableImpl)child).isDisposed = false;
            }
            ObjectNode parentNode = this.getParentNode(parent).findOrCreateChildNode(parent);
            ObjectNode childNode = this.getParentNode(child).moveChildNodeToOtherParent(child, parentNode);
            this.myObject2ParentNode.put(child, parentNode);
            assert (childNode.getObject() == child);
            this.checkWasNotAddedAlreadyAsChild(parentNode, childNode);
        }
    }

    @NotNull
    private ObjectNode getParentNode(@NotNull Disposable object) {
        return ObjectUtils.chooseNotNull(this.myObject2ParentNode.get(object), this.myRootNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean tryRegister(@NotNull Disposable parent, @NotNull Disposable child) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.isDisposed(parent)) {
                return false;
            }
            this.register(parent, child);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Throwable getDisposalTrace(@NotNull Disposable object) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            return ObjectUtils.nullizeIfDefaultValue(this.myDisposedObjects.get(object), UNKNOWN_TRACE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDisposed(@NotNull Disposable object) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            return this.myDisposedObjects.get(object) != null;
        }
    }

    private void checkWasNotAddedAlreadyAsChild(@NotNull ObjectNode childNode, @NotNull ObjectNode parentNode) throws IncorrectOperationException {
        ObjectNode node = childNode;
        while (node != this.myRootNode && node != null) {
            if (node == parentNode) {
                throw new IncorrectOperationException("'" + childNode.getObject() + "' was already added as a child of '" + parentNode.getObject() + "'");
            }
            node = this.myObject2ParentNode.get(node.getObject());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWithTrace(@NotNull @NotNull BiFunction<? super ObjectTree, ? super Throwable, ? extends @NotNull List<Disposable>> removeFromTreeAction) {
        List<Disposable> disposables;
        boolean needTrace;
        Throwable trace = null;
        boolean bl = needTrace = Disposer.isDebugMode() && (trace = ourTopmostDisposeTrace.get()) == null;
        if (needTrace) {
            trace = ThrowableInterner.intern(new Throwable());
            ourTopmostDisposeTrace.set(trace);
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            disposables = removeFromTreeAction.apply(this, trace);
        }
        SmartList<Throwable> exceptions = null;
        for (int i = disposables.size() - 1; i >= 0; --i) {
            Disposable disposable = disposables.get(i);
            if (!(disposable instanceof Disposable.Parent)) continue;
            try {
                ((Disposable.Parent)disposable).beforeTreeDispose();
                continue;
            }
            catch (Throwable t) {
                if (exceptions == null) {
                    exceptions = new SmartList<Throwable>();
                }
                exceptions.add(t);
            }
        }
        for (Disposable disposable : disposables) {
            try {
                disposable.dispose();
            }
            catch (Throwable e) {
                if (exceptions == null) {
                    exceptions = new SmartList();
                }
                exceptions.add(e);
            }
        }
        if (needTrace) {
            ourTopmostDisposeTrace.remove();
        }
        if (exceptions != null) {
            ObjectTree.handleExceptions(exceptions);
        }
    }

    void executeAllChildren(@NotNull Disposable object, @NotNull Predicate<? super Disposable> predicate) {
        this.runWithTrace((tree, trace) -> {
            ObjectNode parentNode = this.getParentNode(object);
            ObjectNode node = parentNode.findChildNode(object);
            if (node == null) {
                return Collections.emptyList();
            }
            ArrayList disposables = new ArrayList();
            node.removeChildNodesRecursively(disposables, (ObjectTree)tree, (Throwable)trace, predicate);
            for (Disposable disposable : disposables) {
                this.myObject2ParentNode.remove(disposable);
            }
            return disposables;
        });
    }

    void executeAll(@NotNull Disposable object, boolean processUnregistered) {
        this.runWithTrace((tree, trace) -> {
            ObjectNode parentNode = this.getParentNode(object);
            ObjectNode node = parentNode.findChildNode(object);
            if (node == null && !processUnregistered) {
                return Collections.emptyList();
            }
            ArrayList<Disposable> disposables = new ArrayList<Disposable>();
            if (node != null) {
                node.removeChildNodesRecursively((List<? super Disposable>)disposables, (ObjectTree)tree, (Throwable)trace, null);
                parentNode.removeChildNode(node);
            }
            if (this.rememberDisposedTrace(object, (Throwable)trace) == null) {
                disposables.add(object);
            }
            for (Disposable disposable : disposables) {
                this.myObject2ParentNode.remove(disposable);
            }
            return disposables;
        });
    }

    private Object getTreeLock() {
        return this.myRootNode;
    }

    private static void handleExceptions(@NotNull List<? extends Throwable> exceptions) {
        if (exceptions.isEmpty()) {
            return;
        }
        ProcessCanceledException processCanceledException = null;
        for (Throwable throwable : exceptions) {
            if (!(throwable instanceof ProcessCanceledException)) {
                ObjectTree.getLogger().error(throwable);
                continue;
            }
            if (processCanceledException != null) continue;
            processCanceledException = (ProcessCanceledException)throwable;
        }
        if (processCanceledException != null) {
            throw processCanceledException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    void assertNoReferenceKeptInTree(@NotNull Disposable disposable) {
        Object object = this.getTreeLock();
        synchronized (object) {
            for (ObjectNode node : this.myObject2ParentNode.values()) {
                node.assertNoReferencesKept(disposable);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    void assertIsEmpty(boolean throwError) {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.myRootNode.assertNoChildren(throwError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Throwable getRegistrationTrace(@NotNull Disposable object) {
        Object object2 = this.getTreeLock();
        synchronized (object2) {
            ObjectNode objectNode = this.getParentNode(object).findChildNode(object);
            return objectNode == null ? null : objectNode.getTrace();
        }
    }

    @NotNull
    static Logger getLogger() {
        return Logger.getInstance(ObjectTree.class);
    }

    Throwable rememberDisposedTrace(@NotNull Disposable object, @Nullable Throwable trace) {
        return this.myDisposedObjects.put(object, ObjectUtils.notNull(trace, UNKNOWN_TRACE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearDisposedObjectTraces() {
        Object object = this.getTreeLock();
        synchronized (object) {
            this.myDisposedObjects.clear();
            for (ObjectNode value : this.myObject2ParentNode.values()) {
                value.clearTrace();
            }
        }
    }
}

