/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ObjectTree;
import com.intellij.openapi.util.objectTree.ThrowableInterner;
import com.intellij.util.SmartList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectLinkedOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

final class ObjectNode {
    @VisibleForTesting
    static final int REASONABLY_BIG = 500;
    private final Disposable myObject;
    @NotNull
    private NodeChildren myChildren = EMPTY;
    private Throwable myTrace;
    private static final Disposable ROOT_DISPOSABLE = Disposer.newDisposable("ROOT_DISPOSABLE");
    private static final NodeChildren EMPTY = new NodeChildren(){

        @Override
        public ObjectNode removeChildNode(@NotNull Disposable object) {
            return null;
        }

        @Override
        @Nullable
        public ObjectNode findChildNode(@NotNull Disposable object) {
            return null;
        }

        @Override
        @NotNull
        public NodeChildren addChildNode(@NotNull ObjectNode node) {
            return new ListNodeChildren(node);
        }

        @Override
        public void removeChildren(@Nullable Predicate<? super Disposable> condition, @NotNull Consumer<? super ObjectNode> deletedNodeConsumer) {
        }

        @Override
        @NotNull
        public Collection<? extends ObjectNode> getAllNodes() {
            return Collections.emptyList();
        }
    };

    private ObjectNode(@NotNull Disposable object, boolean parentIsRoot) {
        this.myObject = object;
        this.myTrace = parentIsRoot && Disposer.isDebugMode() ? ThrowableInterner.intern(new Throwable()) : null;
    }

    private ObjectNode() {
        this.myObject = ROOT_DISPOSABLE;
    }

    void assertNoChildren(boolean throwError) {
        for (ObjectNode objectNode : this.myChildren.getAllNodes()) {
            Disposable object = objectNode.getObject();
            Throwable trace = objectNode.getTrace();
            String message = "Memory leak detected: '" + object + "' of " + object.getClass() + " is registered in Disposer but wasn't disposed.\nRegister it with a proper parentDisposable or ensure that it's always disposed by direct Disposer.dispose call.\nSee https://jetbrains.org/intellij/sdk/docs/basics/disposers.html for more details.\nThe corresponding Disposer.register() stacktrace is shown as the cause:\n";
            RuntimeException exception = new RuntimeException(message, trace);
            if (throwError) {
                throw exception;
            }
            ObjectTree.getLogger().error(exception);
        }
    }

    private boolean isRootNode() {
        return this.myObject == ROOT_DISPOSABLE;
    }

    @NotNull
    static ObjectNode createRootNode() {
        return new ObjectNode();
    }

    private void addChildNode(@NotNull ObjectNode childNode) {
        NodeChildren children2 = this.myChildren;
        NodeChildren newChildren = children2.addChildNode(childNode);
        if (children2 != newChildren) {
            this.myChildren = newChildren;
        }
    }

    void removeChildNode(@NotNull ObjectNode childNode) {
        this.myChildren.removeChildNode(childNode.getObject());
    }

    @NotNull
    ObjectNode moveChildNodeToOtherParent(@NotNull Disposable child, @NotNull ObjectNode otherParentNode) {
        ObjectNode childNode = this.myChildren.removeChildNode(child);
        if (childNode == null) {
            childNode = new ObjectNode(child, this.isRootNode());
        }
        otherParentNode.addChildNode(childNode);
        assert (childNode.getObject() == child);
        return childNode;
    }

    void removeChildNodesRecursively(@NotNull List<? super Disposable> disposables, @NotNull ObjectTree tree, @Nullable Throwable trace, @Nullable Predicate<? super Disposable> predicate) {
        this.myChildren.removeChildren(predicate, childNode -> {
            boolean alreadyDisposed;
            childNode.removeChildNodesRecursively(disposables, tree, trace, null);
            Disposable object = childNode.getObject();
            boolean bl = alreadyDisposed = tree.rememberDisposedTrace(object, trace) != null;
            if (!alreadyDisposed) {
                disposables.add(object);
            }
        });
    }

    @NotNull
    Disposable getObject() {
        return this.myObject;
    }

    @NonNls
    public String toString() {
        return this.isRootNode() ? "ROOT" : "Node: " + this.myObject;
    }

    Throwable getTrace() {
        return this.myTrace;
    }

    void clearTrace() {
        this.myTrace = null;
    }

    @TestOnly
    void assertNoReferencesKept(@NotNull Disposable aDisposable) {
        assert (this.getObject() != aDisposable);
        for (ObjectNode objectNode : this.myChildren.getAllNodes()) {
            objectNode.assertNoReferencesKept(aDisposable);
        }
    }

    ObjectNode findChildNode(@NotNull Disposable object) {
        return this.myChildren.findChildNode(object);
    }

    @NotNull
    ObjectNode findOrCreateChildNode(@NotNull Disposable object) {
        ObjectNode existing = this.findChildNode(object);
        if (existing != null) {
            return existing;
        }
        ObjectNode childNode = new ObjectNode(object, this.isRootNode());
        this.addChildNode(childNode);
        return childNode;
    }

    private static interface NodeChildren {
        @Nullable
        public ObjectNode removeChildNode(@NotNull Disposable var1);

        @Nullable
        public ObjectNode findChildNode(@NotNull Disposable var1);

        @NotNull
        public NodeChildren addChildNode(@NotNull ObjectNode var1);

        public void removeChildren(@Nullable Predicate<? super Disposable> var1, @NotNull Consumer<? super ObjectNode> var2);

        @NotNull
        public Collection<? extends ObjectNode> getAllNodes();
    }

    private static class ListNodeChildren
    implements NodeChildren {
        @NotNull
        private final List<ObjectNode> myChildren;

        ListNodeChildren(@NotNull ObjectNode node) {
            this.myChildren = new SmartList<ObjectNode>(node);
        }

        @Override
        public ObjectNode removeChildNode(@NotNull Disposable nodeToDelete) {
            List<ObjectNode> children2 = this.myChildren;
            for (int i = children2.size() - 1; i >= 0; --i) {
                ObjectNode node = children2.get(i);
                if (node.getObject() != nodeToDelete) continue;
                return children2.remove(i);
            }
            return null;
        }

        @Override
        @Nullable
        public ObjectNode findChildNode(@NotNull Disposable object) {
            for (ObjectNode node : this.myChildren) {
                if (node.getObject() != object) continue;
                return node;
            }
            return null;
        }

        @Override
        @NotNull
        public NodeChildren addChildNode(@NotNull ObjectNode node) {
            this.myChildren.add(node);
            return this.myChildren.size() > 500 ? new MapNodeChildren(this.myChildren) : this;
        }

        @Override
        public void removeChildren(@Nullable Predicate<? super Disposable> condition, @NotNull Consumer<? super ObjectNode> deletedNodeConsumer) {
            for (int i = this.myChildren.size() - 1; i >= 0; --i) {
                ObjectNode childNode = this.myChildren.get(i);
                Disposable object = childNode.getObject();
                if (condition != null && !condition.test(object)) continue;
                this.myChildren.remove(i);
                deletedNodeConsumer.accept(childNode);
            }
        }

        @Override
        @NotNull
        public Collection<? extends ObjectNode> getAllNodes() {
            return this.myChildren;
        }
    }

    private static class MapNodeChildren
    implements NodeChildren {
        private final Map<Disposable, ObjectNode> myChildren;

        MapNodeChildren(@NotNull List<? extends ObjectNode> children2) {
            Reference2ObjectLinkedOpenHashMap map = new Reference2ObjectLinkedOpenHashMap(children2.size());
            for (ObjectNode objectNode : children2) {
                map.put((Object)objectNode.getObject(), (Object)objectNode);
            }
            this.myChildren = map;
        }

        @Override
        @Nullable
        public ObjectNode removeChildNode(@NotNull Disposable object) {
            return this.myChildren.remove(object);
        }

        @Override
        @Nullable
        public ObjectNode findChildNode(@NotNull Disposable object) {
            return this.myChildren.get(object);
        }

        @Override
        @NotNull
        public NodeChildren addChildNode(@NotNull ObjectNode node) {
            this.myChildren.put(node.getObject(), node);
            return this;
        }

        @Override
        public void removeChildren(@Nullable Predicate<? super Disposable> condition, @NotNull Consumer<? super ObjectNode> deletedNodeConsumer) {
            Iterator<Map.Entry<Disposable, ObjectNode>> iterator = this.myChildren.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Disposable, ObjectNode> entry = iterator.next();
                if (condition != null && !condition.test(entry.getKey())) continue;
                ObjectNode value = entry.getValue();
                iterator.remove();
                deletedNodeConsumer.accept(value);
            }
        }

        @Override
        @NotNull
        public Collection<? extends ObjectNode> getAllNodes() {
            return this.myChildren.values();
        }
    }
}

