/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.VolatileNullableLazyValue;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NullableLazyValue<T> {
    private boolean myComputed;
    @Nullable
    private T myValue;

    @Nullable
    protected abstract T compute();

    @Nullable
    public T getValue() {
        T value = this.myValue;
        if (!this.myComputed) {
            RecursionGuard.StackStamp stamp = RecursionManager.markStack();
            value = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value;
                this.myComputed = true;
            }
        }
        return value;
    }

    public boolean isComputed() {
        return this.myComputed;
    }

    @NotNull
    public static <T> NullableLazyValue<T> lazyNullable(final @NotNull Supplier<? extends T> value) {
        return new NullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.get();
            }
        };
    }

    @NotNull
    public static <T> NullableLazyValue<T> atomicLazyNullable(final @NotNull Supplier<? extends T> value) {
        return new AtomicNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.get();
            }
        };
    }

    @NotNull
    public static <T> NullableLazyValue<T> volatileLazyNullable(final @NotNull Supplier<? extends T> value) {
        return new VolatileNullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.get();
            }
        };
    }

    @Deprecated
    @NotNull
    public static <T> NullableLazyValue<T> createValue(final @NotNull Factory<? extends T> value) {
        return new NullableLazyValue<T>(){

            @Override
            @Nullable
            protected T compute() {
                return value.create();
            }
        };
    }
}

