/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.KeyedFactoryEPBean;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class KeyedExtensionFactory<T, KeyT> {
    private final Class<T> myInterfaceClass;
    private final ExtensionPointName<KeyedFactoryEPBean> myEpName;
    private final ComponentManager componentManager;

    public KeyedExtensionFactory(@NotNull Class<T> interfaceClass, @NotNull ExtensionPointName<KeyedFactoryEPBean> epName, @NotNull ComponentManager componentManager) {
        this.myInterfaceClass = interfaceClass;
        this.myEpName = epName;
        this.componentManager = componentManager;
    }

    @NotNull
    public T get() {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args2) {
                Object keyArg;
                String key;
                List epBeans = KeyedExtensionFactory.this.myEpName.getExtensionList();
                Object result = KeyedExtensionFactory.this.getByKey(epBeans, key = KeyedExtensionFactory.this.getKey(keyArg = args2[0]), method, args2);
                if (result == null) {
                    result = KeyedExtensionFactory.this.getByKey(epBeans, null, method, args2);
                }
                return result;
            }
        };
        return (T)Proxy.newProxyInstance(this.myInterfaceClass.getClassLoader(), new Class[]{this.myInterfaceClass}, handler);
    }

    public T getByKey(@NotNull KeyT key) {
        return KeyedExtensionFactory.findByKey(this.getKey(key), this.myEpName, this.componentManager);
    }

    @Nullable
    public static <T> T findByKey(@NotNull String key, @NotNull ExtensionPointName<KeyedFactoryEPBean> point, @NotNull ComponentManager componentManager) {
        for (KeyedFactoryEPBean epBean : point.getExtensionList()) {
            if (!key.equals(epBean.key) || epBean.implementationClass == null) continue;
            return componentManager.instantiateClass(epBean.implementationClass, epBean.getPluginDescriptor());
        }
        return null;
    }

    private T getByKey(@NotNull List<KeyedFactoryEPBean> epBeans, @Nullable String key, @NotNull Method method, Object[] args2) {
        for (KeyedFactoryEPBean epBean : epBeans) {
            if (!(epBean.key == null ? "" : epBean.key).equals(key == null ? "" : key)) continue;
            if (epBean.implementationClass != null) {
                return this.componentManager.instantiateClass(epBean.implementationClass, epBean.getPluginDescriptor());
            }
            Object factory = this.componentManager.instantiateClass(epBean.factoryClass, epBean.getPluginDescriptor());
            try {
                Object result = method.invoke(factory, args2);
                if (result == null) continue;
                return (T)result;
            }
            catch (RuntimeException e) {
                if (e instanceof ControlFlowException) {
                    throw e;
                }
                throw this.componentManager.createError(e, epBean.getPluginDescriptor().getPluginId());
            }
            catch (Exception e) {
                throw this.componentManager.createError(e, epBean.getPluginDescriptor().getPluginId());
            }
        }
        return null;
    }

    @NotNull
    public abstract String getKey(@NotNull KeyT var1);
}

