/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.util.KeyedLazyInstance;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class KeyedExtensionCollector<T, KeyT>
implements ModificationTracker {
    private static final Logger LOG = Logger.getInstance(KeyedExtensionCollector.class);
    @NonNls
    protected final String myLock;
    private Map<String, List<T>> myExplicitExtensions = Collections.emptyMap();
    private final ConcurrentMap<String, List<T>> myCache = new ConcurrentHashMap<String, List<T>>();
    private final String myEpName;
    private final SimpleModificationTracker myTracker = new SimpleModificationTracker();
    protected final AtomicBoolean myEpListenerAdded = new AtomicBoolean();

    public KeyedExtensionCollector(@NotNull ExtensionPointName<? extends KeyedLazyInstance<T>> epName) {
        this(epName.getName());
    }

    public KeyedExtensionCollector(@NotNull String epName) {
        this.myEpName = epName;
        this.myLock = "lock for KeyedExtensionCollector " + epName;
    }

    public void clearCache() {
        this.myCache.clear();
        this.myTracker.incModificationCount();
    }

    private void addExtensionPointListener(@NotNull @NotNull ExtensionPoint<@NotNull KeyedLazyInstance<T>> point) {
        if (this.myEpListenerAdded.compareAndSet(false, true)) {
            point.addExtensionPointListener(new MyExtensionPointListener(), false, null);
        }
    }

    protected void invalidateCacheForExtension(String key) {
        if (key != null) {
            this.myCache.remove(key);
        }
        this.myTracker.incModificationCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        String string2 = this.myLock;
        synchronized (string2) {
            String stringKey = this.keyToString(key);
            if (this.myExplicitExtensions == Collections.emptyMap()) {
                this.myExplicitExtensions = new HashMap<String, List<T>>();
            }
            List list = this.myExplicitExtensions.computeIfAbsent(stringKey, __ -> new SmartList());
            list.add(t);
            this.invalidateCacheForExtension(stringKey);
        }
    }

    public void addExplicitExtension(@NotNull KeyT key, @NotNull T t, @NotNull Disposable parentDisposable) {
        this.addExplicitExtension(key, t);
        Disposer.register(parentDisposable, () -> this.removeExplicitExtension(key, t));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeExplicitExtension(@NotNull KeyT key, @NotNull T t) {
        String string2 = this.myLock;
        synchronized (string2) {
            String stringKey = this.keyToString(key);
            List<T> list = this.myExplicitExtensions.get(stringKey);
            if (list != null) {
                list.remove(t);
                if (list.isEmpty()) {
                    this.myExplicitExtensions.remove(stringKey);
                }
            }
            this.invalidateCacheForExtension(stringKey);
        }
    }

    @NotNull
    protected String keyToString(@NotNull KeyT key) {
        return key.toString();
    }

    @NotNull
    public List<T> forKey(@NotNull KeyT key) {
        String stringKey = this.keyToString(key);
        List<Object> cached = (List)this.myCache.get(stringKey);
        if (cached != null) {
            return cached;
        }
        List<T> list = this.buildExtensions(stringKey, key);
        cached = list.isEmpty() ? Collections.emptyList() : (list.size() == 1 ? Collections.singletonList(list.get(0)) : ContainerUtil.immutableList(list.toArray()));
        List prev = this.myCache.putIfAbsent(stringKey, cached);
        return prev == null ? cached : prev;
    }

    public T findSingle(@NotNull KeyT key) {
        List<T> list = this.forKey(key);
        return list.isEmpty() ? null : (T)list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<T> buildExtensions(@NotNull String stringKey, @NotNull KeyT key) {
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string2 = this.myLock;
        synchronized (string2) {
            List<T> list = this.myExplicitExtensions.get(stringKey);
            List<T> result = list != null ? new ArrayList<T>(list) : null;
            result = this.buildExtensionsFromExtensionPoint(result, bean -> stringKey.equals(bean.getKey()), extensions);
            return ContainerUtil.notNullize(result);
        }
    }

    @NotNull
    protected final List<KeyedLazyInstance<T>> getExtensions() {
        ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
        if (point == null) {
            return Collections.emptyList();
        }
        this.addExtensionPointListener(point);
        return point.getExtensionList();
    }

    @Nullable
    final List<T> buildExtensionsFromExtensionPoint(@Nullable List<T> result, @NotNull Predicate<? super KeyedLazyInstance<T>> isMyBean, @NotNull List<? extends KeyedLazyInstance<T>> extensions) {
        for (KeyedLazyInstance<T> bean : extensions) {
            T instance;
            if (!isMyBean.test(bean) || (instance = KeyedExtensionCollector.instantiate(bean)) == null) continue;
            if (result == null) {
                result = new SmartList<T>();
            }
            result.add(instance);
        }
        return result;
    }

    @Nullable
    public static <T> T instantiate(KeyedLazyInstance<T> bean) {
        try {
            return bean.getInstance();
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (ExtensionNotApplicableException ignore) {
            return null;
        }
        catch (Exception | LinkageError e) {
            LOG.error(e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected List<T> buildExtensions(@NotNull Set<String> keys) {
        List<KeyedLazyInstance<T>> extensions = this.getExtensions();
        String string2 = this.myLock;
        synchronized (string2) {
            List<T> result = this.buildExtensionsFromExplicitRegistration(null, keys::contains);
            result = this.buildExtensionsFromExtensionPoint(result, bean -> keys.contains(bean.getKey()), extensions);
            return ContainerUtil.notNullize(result);
        }
    }

    @Nullable
    protected List<T> buildExtensionsFromExplicitRegistration(@Nullable List<T> result, @NotNull Predicate<? super String> isMyBean) {
        for (Map.Entry<String, List<T>> entry : this.myExplicitExtensions.entrySet()) {
            String key = entry.getKey();
            if (!isMyBean.test(key)) continue;
            List<T> list = entry.getValue();
            if (result == null) {
                result = new ArrayList<T>(list);
                continue;
            }
            result.addAll(list);
        }
        return result;
    }

    @ApiStatus.Internal
    public final @Nullable ExtensionPoint<@NotNull KeyedLazyInstance<T>> getPoint() {
        return Extensions.getRootArea().getExtensionPointIfRegistered(this.myEpName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasAnyExtensions() {
        String string2 = this.myLock;
        synchronized (string2) {
            if (!this.myExplicitExtensions.isEmpty()) {
                return true;
            }
            // MONITOREXIT @DISABLED, blocks:[0, 1] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1
            ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
            return point != null && point.size() != 0;
        }
    }

    @NotNull
    public String getName() {
        return this.myEpName;
    }

    @Override
    public long getModificationCount() {
        return this.myTracker.getModificationCount();
    }

    protected void ensureValuesLoaded() {
        ExtensionPoint<@NotNull KeyedLazyInstance<T>> point = this.getPoint();
        if (point != null) {
            for (KeyedLazyInstance<T> bean : point.getExtensionList()) {
                bean.getInstance();
            }
        }
    }

    private final class MyExtensionPointListener
    implements ExtensionPointAndAreaListener<KeyedLazyInstance<T>>,
    ExtensionPointPriorityListener {
        private MyExtensionPointListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void extensionAdded(@NotNull KeyedLazyInstance<T> bean, @NotNull PluginDescriptor pluginDescriptor) {
            String string2 = KeyedExtensionCollector.this.myLock;
            synchronized (string2) {
                if (bean.getKey() == null) {
                    throw new PluginException("No key specified for extension of class " + bean.getInstance().getClass(), pluginDescriptor.getPluginId());
                }
                KeyedExtensionCollector.this.invalidateCacheForExtension(bean.getKey());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void extensionRemoved(@NotNull KeyedLazyInstance<T> bean, @NotNull PluginDescriptor pluginDescriptor) {
            String string2 = KeyedExtensionCollector.this.myLock;
            synchronized (string2) {
                KeyedExtensionCollector.this.invalidateCacheForExtension(bean.getKey());
            }
        }

        @Override
        public void areaReplaced(@NotNull ExtensionsArea area) {
            KeyedExtensionCollector.this.myCache.clear();
            KeyedExtensionCollector.this.myTracker.incModificationCount();
        }
    }
}

