/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SafeJdomFactory;
import com.intellij.openapi.util.SafeStAXStreamBuilder;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.io.URLUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.text.CharSequenceReader;
import com.intellij.util.xml.dom.StaxFactory;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import org.codehaus.stax2.XMLStreamReader2;
import org.jdom.Attribute;
import org.jdom.CloneBase;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.JDOMInterner;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDOMUtil {
    @NonNls
    private static final String X = "x";
    @NonNls
    private static final String Y = "y";
    @NonNls
    private static final String WIDTH = "width";
    @NonNls
    private static final String HEIGHT = "height";
    public static final Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace("xi", "http://www.w3.org/2001/XInclude");
    public static final Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");
    private static final Predicate<Content> CONTENT_FILTER = content -> !(content instanceof Text) || !CharArrayUtil.containsOnlyWhiteSpaces(((Text)content).getText());

    private JDOMUtil() {
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent) {
        return parent == null ? Collections.emptyList() : parent.getChildren();
    }

    @NotNull
    public static List<Element> getChildren(@Nullable Element parent, @NotNull String name) {
        if (parent != null) {
            return parent.getChildren(name);
        }
        return Collections.emptyList();
    }

    private static Logger getLogger() {
        return LoggerHolder.LOG;
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2) {
        return JDOMUtil.areElementsEqual(e1, e2, false);
    }

    public static boolean areElementsEqual(@Nullable Element e1, @Nullable Element e2, boolean ignoreEmptyAttrValues) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return Objects.equals(e1.getName(), e2.getName()) && JDOMUtil.isAttributesEqual(JDOMUtil.getAttributes(e1), JDOMUtil.getAttributes(e2), ignoreEmptyAttrValues) && JDOMUtil.areElementContentsEqual(e1, e2, ignoreEmptyAttrValues);
    }

    public static int hashCode(@Nullable Element e, boolean ignoreEmptyAttrValues) {
        if (e == null) {
            return 0;
        }
        int hashCode = e.getName().hashCode();
        for (Attribute attribute : JDOMUtil.getAttributes(e)) {
            String value = attribute.getValue();
            if (ignoreEmptyAttrValues && (value == null || value.isEmpty())) continue;
            hashCode = hashCode * 31 * 31 + attribute.getName().hashCode() * 31 + value.hashCode();
        }
        Iterator iterator = e.content().filter(CONTENT_FILTER).iterator();
        while (iterator.hasNext()) {
            Content content = (Content)iterator.next();
            int contentHash = content instanceof Element ? JDOMUtil.hashCode((Element)content, ignoreEmptyAttrValues) : e.getValue().hashCode();
            hashCode = hashCode * 31 + contentHash;
        }
        return hashCode;
    }

    private static boolean areElementContentsEqual(@NotNull Element e1, @NotNull Element e2, boolean ignoreEmptyAttrValues) {
        return JDOMUtil.contentListsEqual(e1.content().filter(CONTENT_FILTER), e2.content().filter(CONTENT_FILTER), ignoreEmptyAttrValues);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Element @NotNull [] getElements(@NotNull Element m) {
        List<Element> list = m.getChildren();
        return list.toArray(new Element[0]);
    }

    @NotNull
    public static String legalizeText(@NotNull String str) {
        return JDOMUtil.legalizeChars(str).toString();
    }

    @NotNull
    public static CharSequence legalizeChars(@NotNull CharSequence str) {
        StringBuilder result = new StringBuilder(str.length());
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            JDOMUtil.appendLegalized(result, str.charAt(i));
        }
        return result;
    }

    private static void appendLegalized(@NotNull @NonNls StringBuilder sb, char each) {
        if (each == '<' || each == '>') {
            sb.append(each == '<' ? "&lt;" : "&gt;");
        } else if (!Verifier.isXMLCharacter(each)) {
            String s = Long.toHexString(each);
            sb.append("0x").append(s.toUpperCase(Locale.ENGLISH));
        } else {
            sb.append(each);
        }
    }

    private static boolean contentListsEqual(@NotNull Stream<Content> c1, @NotNull Stream<Content> c2, boolean ignoreEmptyAttrValues) {
        Iterator l1 = c1.iterator();
        Iterator l2 = c2.iterator();
        while (l1.hasNext() && l2.hasNext()) {
            if (JDOMUtil.contentsEqual((Content)l1.next(), (Content)l2.next(), ignoreEmptyAttrValues)) continue;
            return false;
        }
        return l1.hasNext() == l2.hasNext();
    }

    private static boolean contentsEqual(Content c1, Content c2, boolean ignoreEmptyAttrValues) {
        if (!(c1 instanceof Element) && !(c2 instanceof Element)) {
            return c1.getValue().equals(c2.getValue());
        }
        return c1 instanceof Element && c2 instanceof Element && JDOMUtil.areElementsEqual((Element)c1, (Element)c2, ignoreEmptyAttrValues);
    }

    private static boolean isAttributesEqual(@NotNull List<? extends Attribute> l1, @NotNull List<? extends Attribute> l2, boolean ignoreEmptyAttrValues) {
        if (ignoreEmptyAttrValues) {
            l1 = JDOMUtil.getNotEmptyAttributes(l1);
            l2 = JDOMUtil.getNotEmptyAttributes(l2);
        }
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (JDOMUtil.attributesEqual(l1.get(i), l2.get(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<? extends Attribute> getNotEmptyAttributes(@NotNull List<? extends Attribute> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> result = null;
        for (Attribute attribute : list) {
            String s = attribute.getValue();
            if (s == null || s.isEmpty()) continue;
            if (result == null) {
                result = new ArrayList<Attribute>(list.size());
            }
            result.add(attribute);
        }
        return result == null ? Collections.emptyList() : result;
    }

    private static boolean attributesEqual(@NotNull Attribute a1, @NotNull Attribute a2) {
        return a1.getName().equals(a2.getName()) && a1.getValue().equals(a2.getValue());
    }

    @NotNull
    private static Document loadDocumentUsingStaX(@NotNull InputStream stream) throws JDOMException, IOException {
        try {
            Document document;
            XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(stream);
            try {
                document = SafeStAXStreamBuilder.buildDocument(xmlStreamReader);
            }
            catch (Throwable throwable) {
                try {
                    xmlStreamReader.close();
                    throw throwable;
                }
                catch (XMLStreamException e) {
                    throw new JDOMException(e.getMessage(), e);
                }
            }
            xmlStreamReader.close();
            return document;
        }
        finally {
            stream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Element loadUsingStaX(@NotNull InputStream stream, @Nullable SafeJdomFactory factory) throws JDOMException {
        Element element;
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(stream);
        try {
            element = SafeStAXStreamBuilder.build(xmlStreamReader, true, true, factory == null ? SafeStAXStreamBuilder.FACTORY : factory);
        }
        catch (Throwable throwable) {
            try {
                xmlStreamReader.close();
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new JDOMException(e.getMessage(), e);
            }
        }
        xmlStreamReader.close();
        return element;
    }

    @NotNull
    public static Element load(@NotNull CharSequence seq) throws IOException, JDOMException {
        return JDOMUtil.load(new CharSequenceReader(seq));
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull File file2) throws JDOMException, IOException {
        return JDOMUtil.loadDocumentUsingStaX(new FileInputStream(file2));
    }

    @NotNull
    public static Element load(@NotNull File file2) throws JDOMException, IOException {
        return JDOMUtil.loadUsingStaX(new FileInputStream(file2), null);
    }

    @NotNull
    public static Element load(@NotNull Path file2) throws JDOMException, IOException {
        try {
            return JDOMUtil.loadUsingStaX(Files.newInputStream(file2, new OpenOption[0]), null);
        }
        catch (ClosedFileSystemException e) {
            throw new IOException("Cannot read file from closed file system: " + file2, e);
        }
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull File file2, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        return JDOMUtil.loadUsingStaX(new FileInputStream(file2), factory);
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull Path file2, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        try {
            return JDOMUtil.loadUsingStaX(Files.newInputStream(file2, new OpenOption[0]), factory);
        }
        catch (ClosedFileSystemException e) {
            throw new IOException("Cannot read file from closed file system: " + file2, e);
        }
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull InputStream stream) throws JDOMException, IOException {
        return JDOMUtil.loadDocumentUsingStaX(stream);
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(Reader reader) throws JDOMException, IOException {
        Element element;
        if (reader == null) {
            return null;
        }
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(reader);
        try {
            element = SafeStAXStreamBuilder.build(xmlStreamReader, true, true, SafeStAXStreamBuilder.FACTORY);
        }
        catch (Throwable throwable) {
            try {
                xmlStreamReader.close();
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new JDOMException(e.getMessage(), e);
            }
        }
        xmlStreamReader.close();
        return element;
    }

    @Contract(value="null -> null; !null -> !null")
    public static Element load(InputStream stream) throws JDOMException, IOException {
        return stream == null ? null : JDOMUtil.loadUsingStaX(stream, null);
    }

    @NotNull
    public static Element load(byte @NotNull [] data) throws JDOMException, IOException {
        Element element;
        XMLStreamReader2 xmlStreamReader = StaxFactory.createXmlStreamReader(data);
        try {
            element = SafeStAXStreamBuilder.build(xmlStreamReader, true, true, SafeStAXStreamBuilder.FACTORY);
        }
        catch (Throwable throwable) {
            try {
                xmlStreamReader.close();
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw new JDOMException(e.getMessage(), e);
            }
        }
        xmlStreamReader.close();
        return element;
    }

    @ApiStatus.Internal
    @NotNull
    public static Element load(@NotNull InputStream stream, @Nullable SafeJdomFactory factory) throws JDOMException, IOException {
        return JDOMUtil.loadUsingStaX(stream, factory);
    }

    @NotNull
    public static Element load(@NotNull Class<?> clazz, @NotNull String resource) throws JDOMException, IOException {
        InputStream stream = clazz.getResourceAsStream(resource);
        if (stream == null) {
            throw new FileNotFoundException(resource);
        }
        return JDOMUtil.load(stream);
    }

    @Deprecated
    @NotNull
    public static Document loadDocument(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.loadDocumentUsingStaX(URLUtil.openStream(url));
    }

    @NotNull
    public static Element load(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.load(URLUtil.openStream(url));
    }

    @NotNull
    public static Element loadResource(@NotNull URL url) throws JDOMException, IOException {
        return JDOMUtil.load(URLUtil.openResourceStream(url));
    }

    public static void writeDocument(@NotNull Document document, @NotNull String filePath, String lineSeparator) throws IOException {
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filePath));){
            JDOMUtil.writeDocument(document, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull File file2, String lineSeparator) throws IOException {
        JDOMUtil.write((Parent)document, file2, lineSeparator);
    }

    public static void write(@NotNull Element element, @NotNull Path file2) throws IOException {
        Files.createDirectories(file2.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(file2, new OpenOption[0]);){
            JDOMUtil.createOutputter("\n").output(element, (Writer)writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    public static void write(@NotNull Parent element, @NotNull File file2) throws IOException {
        JDOMUtil.write(element, file2, "\n");
    }

    public static void write(@NotNull Parent element, @NotNull File file2, @NotNull String lineSeparator) throws IOException {
        FileUtilRt.createParentDirs((File)file2);
        try (BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(file2));){
            JDOMUtil.write(element, stream, lineSeparator);
        }
    }

    public static void writeDocument(@NotNull Document document, @NotNull OutputStream stream, String lineSeparator) throws IOException {
        JDOMUtil.write((Parent)document, stream, lineSeparator);
    }

    public static void write(@NotNull Parent element, @NotNull OutputStream stream) throws IOException {
        JDOMUtil.write(element, stream, "\n");
    }

    public static void write(@NotNull Parent element, @NotNull OutputStream stream, @NotNull String lineSeparator) throws IOException {
        try (OutputStreamWriter writer = new OutputStreamWriter(stream, StandardCharsets.UTF_8);){
            if (element instanceof Document) {
                JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
            } else {
                JDOMUtil.writeElement((Element)element, writer, lineSeparator);
            }
        }
    }

    @NotNull
    public static String writeDocument(@NotNull Document document, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.writeDocument(document, writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException ignored) {
            return "";
        }
    }

    @NotNull
    public static String write(@NotNull Element element) {
        return JDOMUtil.writeElement(element);
    }

    @NotNull
    public static String write(@NotNull Parent element, String lineSeparator) {
        try {
            StringWriter writer = new StringWriter();
            JDOMUtil.write(element, writer, lineSeparator);
            return writer.toString();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static void write(Parent element, Writer writer, String lineSeparator) throws IOException {
        if (element instanceof Element) {
            JDOMUtil.writeElement((Element)element, writer, lineSeparator);
        } else if (element instanceof Document) {
            JDOMUtil.writeDocument((Document)element, writer, lineSeparator);
        }
    }

    public static void writeElement(@NotNull Element element, Writer writer, String lineSeparator) throws IOException {
        try {
            JDOMUtil.createOutputter(lineSeparator).output(element, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
    }

    @NotNull
    public static String writeElement(@NotNull Element element) {
        return JDOMUtil.writeElement(element, "\n");
    }

    @NotNull
    public static String writeElement(@NotNull Element element, String lineSeparator) {
        StringWriter writer = new StringWriter();
        try {
            JDOMUtil.createOutputter(lineSeparator).output(element, (Writer)writer);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(element, "");
        }
        return writer.toString();
    }

    @NotNull
    public static String writeChildren(@NotNull Element element, @NotNull String lineSeparator) throws IOException {
        StringWriter writer = new StringWriter();
        for (Element child : element.getChildren()) {
            JDOMUtil.writeElement(child, writer, lineSeparator);
            writer.append(lineSeparator);
        }
        return writer.toString();
    }

    private static void writeDocument(@NotNull Document document, @NotNull Writer writer, String lineSeparator) throws IOException {
        XMLOutputter xmlOutputter = JDOMUtil.createOutputter(lineSeparator);
        try {
            xmlOutputter.output(document, writer);
        }
        catch (NullPointerException ex) {
            JDOMUtil.getLogger().error(ex);
            JDOMUtil.printDiagnostics(document.getRootElement(), "");
        }
    }

    @NotNull
    public static Format createFormat(@Nullable String lineSeparator) {
        return Format.getCompactFormat().setIndent("  ").setTextMode(Format.TextMode.TRIM).setLineSeparator(lineSeparator);
    }

    @ApiStatus.Internal
    @NotNull
    public static XMLOutputter createOutputter(String lineSeparator) {
        return new MyXMLOutputter(JDOMUtil.createFormat(lineSeparator));
    }

    @Nullable
    private static String escapeChar(char c, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        switch (c) {
            case '\n': {
                return escapeLineEnds ? "&#10;" : null;
            }
            case '\r': {
                return escapeLineEnds ? "&#13;" : null;
            }
            case '\t': {
                return escapeLineEnds ? "&#9;" : null;
            }
            case ' ': {
                return escapeSpaces ? "&#20" : null;
            }
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '\"': {
                return "&quot;";
            }
            case '\'': {
                return escapeApostrophes ? "&apos;" : null;
            }
            case '&': {
                return "&amp;";
            }
        }
        return null;
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text) {
        return JDOMUtil.escapeText(text, false, false);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeSpaces, boolean escapeLineEnds) {
        return JDOMUtil.escapeText(text, false, escapeSpaces, escapeLineEnds);
    }

    @Contract(pure=true)
    @NotNull
    public static String escapeText(@NotNull String text, boolean escapeApostrophes, boolean escapeSpaces, boolean escapeLineEnds) {
        StringBuilder buffer = null;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            String quotation = JDOMUtil.escapeChar(ch, escapeApostrophes, escapeSpaces, escapeLineEnds);
            buffer = XmlStringUtil.appendEscapedSymbol(text, buffer, i, quotation, ch);
        }
        return buffer == null ? text : buffer.toString();
    }

    private static void printDiagnostics(@NotNull Element element, String prefix) {
        ElementInfo info = JDOMUtil.getElementInfo(element);
        prefix = prefix + "/" + info.name;
        if (info.hasNullAttributes) {
            System.err.println(prefix);
        }
        for (Element child : element.getChildren()) {
            JDOMUtil.printDiagnostics(child, prefix);
        }
    }

    @NotNull
    private static ElementInfo getElementInfo(@NotNull Element element) {
        boolean hasNullAttributes = false;
        StringBuilder buf = new StringBuilder(element.getName());
        List<Attribute> attributes = JDOMUtil.getAttributes(element);
        int length = attributes.size();
        if (length > 0) {
            buf.append("[");
            for (int idx = 0; idx < length; ++idx) {
                Attribute attr = attributes.get(idx);
                if (idx != 0) {
                    buf.append(";");
                }
                buf.append(attr.getName());
                buf.append("=");
                buf.append(attr.getValue());
                if (attr.getValue() != null) continue;
                hasNullAttributes = true;
            }
            buf.append("]");
        }
        return new ElementInfo(buf, hasNullAttributes);
    }

    public static void updateFileSet(File @NotNull [] oldFiles, String @NotNull [] newFilePaths, Document @NotNull [] newFileDocuments, String lineSeparator) throws IOException {
        JDOMUtil.getLogger().assertTrue(newFilePaths.length == newFileDocuments.length);
        for (String newFilePath : newFilePaths) {
            File file2 = new File(newFilePath);
            if (!file2.exists() || file2.canWrite()) continue;
            throw new IOException("File \"" + newFilePath + "\" is not writeable");
        }
        for (File file3 : oldFiles) {
            if (!file3.exists() || file3.canWrite()) continue;
            throw new IOException("File \"" + file3.getAbsolutePath() + "\" is not writeable");
        }
        ArrayList<String> writtenFilesPaths = new ArrayList<String>();
        for (int i = 0; i < newFilePaths.length; ++i) {
            String newFilePath = newFilePaths[i];
            JDOMUtil.writeDocument(newFileDocuments[i], newFilePath, lineSeparator);
            writtenFilesPaths.add(newFilePath);
        }
        block3: for (File oldFile : oldFiles) {
            String oldFilePath = oldFile.getAbsolutePath();
            for (String writtenFilesPath : writtenFilesPaths) {
                if (!oldFilePath.equals(writtenFilesPath)) continue;
                continue block3;
            }
            boolean result = oldFile.delete();
            if (result) continue;
            throw new IOException("File \"" + oldFilePath + "\" was not deleted");
        }
    }

    public static String getValue(Object node) {
        if (node instanceof Content) {
            Content content = (Content)node;
            return content.getValue();
        }
        if (node instanceof Attribute) {
            Attribute attribute = (Attribute)node;
            return attribute.getValue();
        }
        throw new IllegalArgumentException("Wrong node: " + node);
    }

    public static boolean isEmpty(@Nullable Element element) {
        return element == null || element.isEmpty();
    }

    public static boolean isEmpty(@Nullable Element element, int attributeCount) {
        return element == null || JDOMUtil.getAttributes(element).size() == attributeCount && element.getContent().isEmpty();
    }

    @NotNull
    public static List<Attribute> getAttributes(@NotNull Element e) {
        return e.hasAttributes() ? e.getAttributes() : Collections.emptyList();
    }

    @Contract(value="_, !null -> !null; !null, _ -> !null")
    @Nullable
    public static Element merge(@Nullable Element to, @Nullable Element from) {
        if (from == null) {
            return to;
        }
        if (to == null) {
            return from;
        }
        Iterator<CloneBase> iterator = from.getChildren().iterator();
        while (iterator.hasNext()) {
            Element configuration = iterator.next();
            iterator.remove();
            to.addContent(configuration);
        }
        iterator = JDOMUtil.getAttributes(from).iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            iterator.remove();
            to.setAttribute(attribute);
        }
        return to;
    }

    @NotNull
    public static Element deepMerge(@NotNull Element to, @NotNull Element from) {
        return JDOMUtil.deepMergeWithAttributes(to, from, Collections.emptyList());
    }

    @NotNull
    public static Element deepMergeWithAttributes(@NotNull Element to, @NotNull Element from, @NotNull List<MergeAttribute> mergeByAttributes) {
        Iterator<CloneBase> iterator = from.getChildren().iterator();
        while (iterator.hasNext()) {
            Element child = iterator.next();
            iterator.remove();
            Element existingChild = to.getChild(child.getName());
            if (existingChild != null && JDOMUtil.isEmpty(existingChild)) {
                to.removeChild(child.getName());
                existingChild = null;
            }
            if (existingChild == null || existingChild.getChildren().isEmpty() || !JDOMUtil.areAttributesEqual(JDOMUtil.getAttributes(existingChild), JDOMUtil.getAttributes(child), existingChild, mergeByAttributes)) {
                to.addContent(child);
                continue;
            }
            JDOMUtil.deepMergeWithAttributes(existingChild, child, mergeByAttributes);
        }
        iterator = JDOMUtil.getAttributes(from).iterator();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            iterator.remove();
            to.setAttribute(attribute);
        }
        return to;
    }

    private static boolean areAttributesEqual(@NotNull List<? extends Attribute> l1, @NotNull List<? extends Attribute> l2, @NotNull Element base, @NotNull List<MergeAttribute> mergeByAttributes) {
        Set attributes = mergeByAttributes.stream().filter(o -> o.elementName.equals(base.getName())).map(o -> o.attributeName).collect(Collectors.toSet());
        if (attributes.isEmpty()) {
            return JDOMUtil.isAttributesEqual(l1, l2, false);
        }
        Map<String, String> secondMap = l2.stream().collect(Collectors.toMap(Attribute::getName, Attribute::getValue));
        return l1.stream().filter(o -> attributes.contains(o.getName())).allMatch(o -> o.getValue().equals(secondMap.get(o.getName())));
    }

    @Nullable
    public static Element reduceChildren(@NotNull String name, @NotNull Element parent) {
        List<Element> children2 = parent.getChildren(name);
        Iterator<Element> it = children2.iterator();
        if (!it.hasNext()) {
            return null;
        }
        Element accumulator = it.next();
        while (it.hasNext()) {
            JDOMUtil.merge(accumulator, it.next());
            it.remove();
        }
        return accumulator;
    }

    @NotNull
    public static Element internElement(@NotNull Element element) {
        return JDOMInterner.INSTANCE.internElement(element);
    }

    @NotNull
    public static String removeControlChars(@NotNull String text) {
        StringBuilder result = null;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (!Verifier.isXMLCharacter(c)) {
                if (result != null) continue;
                result = new StringBuilder(text.length());
                result.append(text, 0, i);
                continue;
            }
            if (result == null) continue;
            result.append(c);
        }
        return result == null ? text : result.toString();
    }

    @Nullable
    public static Point getLocation(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getLocation(element, X, Y);
    }

    @Nullable
    public static Point getLocation(@NotNull Element element, @NotNull String x, @NotNull String y) {
        String sX = element.getAttributeValue(x);
        if (sX == null) {
            return null;
        }
        String sY = element.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        try {
            return new Point(Integer.parseInt(sX), Integer.parseInt(sY));
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setLocation(@NotNull Element element, @NotNull Point location) {
        return JDOMUtil.setLocation(element, X, Y, location);
    }

    @NotNull
    public static Element setLocation(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull Point location) {
        return element.setAttribute(x, Integer.toString(location.x)).setAttribute(y, Integer.toString(location.y));
    }

    @Nullable
    public static Dimension getSize(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getSize(element, WIDTH, HEIGHT);
    }

    @Nullable
    public static Dimension getSize(@NotNull Element element, @NotNull String width, @NotNull String height) {
        String sWidth = element.getAttributeValue(width);
        if (sWidth == null) {
            return null;
        }
        String sHeight = element.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Dimension(iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setSize(@NotNull Element element, @NotNull Dimension size) {
        return JDOMUtil.setSize(element, WIDTH, HEIGHT, size);
    }

    @NotNull
    public static Element setSize(@NotNull Element element, @NotNull String width, @NotNull String height, @NotNull Dimension size) {
        return element.setAttribute(width, Integer.toString(size.width)).setAttribute(height, Integer.toString(size.height));
    }

    @Nullable
    public static Rectangle getBounds(@Nullable Element element) {
        return element == null ? null : JDOMUtil.getBounds(element, X, Y, WIDTH, HEIGHT);
    }

    @Nullable
    public static Rectangle getBounds(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height) {
        String sX = element.getAttributeValue(x);
        if (sX == null) {
            return null;
        }
        String sY = element.getAttributeValue(y);
        if (sY == null) {
            return null;
        }
        String sWidth = element.getAttributeValue(width);
        if (sWidth == null) {
            return null;
        }
        String sHeight = element.getAttributeValue(height);
        if (sHeight == null) {
            return null;
        }
        try {
            int iWidth = Integer.parseInt(sWidth);
            if (iWidth <= 0) {
                return null;
            }
            int iHeight = Integer.parseInt(sHeight);
            if (iHeight <= 0) {
                return null;
            }
            return new Rectangle(Integer.parseInt(sX), Integer.parseInt(sY), iWidth, iHeight);
        }
        catch (NumberFormatException ignored) {
            return null;
        }
    }

    @NotNull
    public static Element setBounds(@NotNull Element element, @NotNull Rectangle bounds) {
        return JDOMUtil.setBounds(element, X, Y, WIDTH, HEIGHT, bounds);
    }

    @NotNull
    public static Element setBounds(@NotNull Element element, @NotNull String x, @NotNull String y, @NotNull String width, @NotNull String height, @NotNull Rectangle bounds) {
        return element.setAttribute(x, Integer.toString(bounds.x)).setAttribute(y, Integer.toString(bounds.y)).setAttribute(width, Integer.toString(bounds.width)).setAttribute(height, Integer.toString(bounds.height));
    }

    public static void copyMissingContent(@NotNull Element source, @NotNull Element target) {
        Element targetClone = target.clone();
        for (Attribute attribute : source.getAttributes()) {
            if (JDOMUtil.hasAttribute(targetClone, attribute.getName())) continue;
            target.setAttribute(attribute.clone());
        }
        for (Content content : source.getContent()) {
            if (JDOMUtil.hasContent(targetClone, content)) continue;
            target.addContent(content.clone());
        }
    }

    private static boolean hasAttribute(@NotNull Element element, @NotNull String name) {
        return element.getAttribute(name) != null;
    }

    private static boolean hasContent(@NotNull Element element, @NotNull Content content) {
        return content instanceof Element && !element.getChildren(((Element)content).getName()).isEmpty();
    }

    private static final class LoggerHolder {
        private static final Logger LOG = Logger.getInstance(JDOMUtil.class);

        private LoggerHolder() {
        }
    }

    private static final class MyXMLOutputter
    extends XMLOutputter {
        private MyXMLOutputter(@NotNull Format format) {
            super(format);
        }

        @Override
        @NotNull
        public String escapeAttributeEntities(@NotNull String str) {
            return JDOMUtil.escapeText(str, false, true);
        }

        @Override
        @NotNull
        public String escapeElementEntities(@NotNull String str) {
            return JDOMUtil.escapeText(str, false, false);
        }
    }

    private static final class ElementInfo {
        @NotNull
        private final CharSequence name;
        private final boolean hasNullAttributes;

        private ElementInfo(@NotNull CharSequence name, boolean attributes) {
            this.name = name;
            this.hasNullAttributes = attributes;
        }
    }

    public static class MergeAttribute {
        public String elementName;
        public String attributeName;

        public MergeAttribute(String elementName, String attributeName) {
            this.elementName = elementName;
            this.attributeName = attributeName;
        }
    }

    public static interface ElementOutputFilter {
        public boolean accept(@NotNull Element var1, int var2);
    }
}

