/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JDOMExternalizerUtil {
    public static void writeField(@NotNull Element parent, @NotNull @NonNls String fieldName, @Nullable String value) {
        Element element = new Element("option");
        element.setAttribute("name", fieldName);
        element.setAttribute("value", value == null ? "" : value);
        parent.addContent(element);
    }

    public static void writeField(@NotNull Element parent, @NotNull @NonNls String fieldName, @Nullable String value, @NotNull String defaultValue) {
        if (!defaultValue.equals(value)) {
            JDOMExternalizerUtil.writeField(parent, fieldName, value);
        }
    }

    @NotNull
    public static String readField(@NotNull Element parent, @NotNull @NonNls String fieldName, @NotNull String defaultValue) {
        String val = JDOMExternalizerUtil.readField(parent, fieldName);
        return val == null ? defaultValue : val;
    }

    @Nullable
    public static String readField(@NotNull Element parent, @NonNls @NotNull String fieldName) {
        for (Element element : parent.getChildren("option")) {
            if (!fieldName.equals(element.getAttributeValue("name"))) continue;
            return element.getAttributeValue("value");
        }
        return null;
    }

    @NotNull
    public static Element writeOption(@NotNull Element parent, @NotNull String fieldName) {
        Element element = new Element("option");
        element.setAttribute("name", fieldName);
        parent.addContent(element);
        return element;
    }

    @Nullable
    public static Element readOption(@NotNull Element parent, @NotNull String fieldName) {
        for (Element element : parent.getChildren("option")) {
            if (!fieldName.equals(element.getAttributeValue("name"))) continue;
            return element;
        }
        return null;
    }

    public static void writeCustomField(@NotNull Element parent, @NotNull String tagName, @Nullable String value) {
        Element element = new Element(tagName);
        if (value != null) {
            element.setAttribute("value", value);
        }
        parent.addContent(element);
    }

    @Nullable
    public static String readCustomField(@NotNull Element parent, @NotNull String tagName) {
        Element element = parent.getChild(tagName);
        return element != null ? element.getAttributeValue("value") : null;
    }

    @NotNull
    public static List<String> getChildrenValueAttributes(@NotNull Element parent, @NotNull String childTagName) {
        return ContainerUtil.mapNotNull(parent.getChildren(childTagName), e -> e.getAttributeValue("value"));
    }

    public static void addChildrenWithValueAttribute(@NotNull Element parent, @NotNull String childTagName, @NotNull List<String> attrValues) {
        for (String value : attrValues) {
            if (value == null) continue;
            Element child = new Element(childTagName);
            child.setAttribute("value", value);
            parent.addContent(child);
        }
    }

    public static void addChildren(@NotNull Element parent, @NotNull String childElementName, @NotNull Collection<? extends JDOMExternalizable> children2) throws WriteExternalException {
        for (JDOMExternalizable jDOMExternalizable : children2) {
            if (jDOMExternalizable == null) continue;
            Element element = new Element(childElementName);
            jDOMExternalizable.writeExternal(element);
            parent.addContent(element);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static Element addElementWithValueAttribute(@NotNull Element parent, @NotNull String childTagName, @Nullable String attrValue) {
        JDOMExternalizerUtil.writeCustomField(parent, childTagName, attrValue);
        return parent.getChild(childTagName);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static String getFirstChildValueAttribute(@NotNull Element parent, @NotNull String childTagName) {
        return JDOMExternalizerUtil.readCustomField(parent, childTagName);
    }
}

