/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class Conditions {
    private Conditions() {
    }

    @NotNull
    public static <T> Condition<T> alwaysTrue() {
        return Condition.TRUE;
    }

    @NotNull
    public static <T> Condition<T> alwaysFalse() {
        return Condition.FALSE;
    }

    @NotNull
    public static <T> Condition<T> notNull() {
        return Condition.NOT_NULL;
    }

    @NotNull
    public static <T> Condition<T> constant(boolean value) {
        return value ? Conditions.alwaysTrue() : Conditions.alwaysFalse();
    }

    @NotNull
    public static <T> Condition<T> instanceOf(@NotNull Class<?> clazz) {
        return t -> clazz.isInstance(t);
    }

    @NotNull
    public static <T> Condition<T> notInstanceOf(@NotNull Class<?> clazz) {
        return t -> !clazz.isInstance(t);
    }

    @NotNull
    public static Condition<Class<?>> assignableTo(@NotNull Class<?> clazz) {
        return t -> clazz.isAssignableFrom((Class<?>)t);
    }

    @NotNull
    public static <T> Condition<T> instanceOf(Class<?> ... clazz) {
        return t -> {
            for (Class aClass : clazz) {
                if (!aClass.isInstance(t)) continue;
                return true;
            }
            return false;
        };
    }

    @NotNull
    public static <T> Condition<T> is(T option) {
        return Conditions.equalTo(option);
    }

    @NotNull
    public static <T> Condition<T> equalTo(Object option) {
        return t -> Comparing.equal((Object)t, (Object)option);
    }

    @NotNull
    public static <T> Condition<T> notEqualTo(Object option) {
        return t -> !Comparing.equal((Object)t, (Object)option);
    }

    @SafeVarargs
    @NotNull
    public static <T> Condition<T> oneOf(T ... options) {
        return Conditions.oneOf(Arrays.asList(options));
    }

    @NotNull
    public static <T> Condition<T> oneOf(@NotNull Collection<? extends T> options) {
        return t -> options.contains(t);
    }

    @NotNull
    public static <T> Condition<T> not(@NotNull Condition<? super T> c) {
        if (c == Conditions.alwaysTrue()) {
            return Conditions.alwaysFalse();
        }
        if (c == Conditions.alwaysFalse()) {
            return Conditions.alwaysTrue();
        }
        if (c instanceof Not) {
            return ((Not)c).c;
        }
        return new Not<T>(c);
    }

    @NotNull
    public static <T> Condition<T> and(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
        if (c1 == Conditions.alwaysTrue() || c2 == Conditions.alwaysFalse()) {
            return c2;
        }
        if (c2 == Conditions.alwaysTrue() || c1 == Conditions.alwaysFalse()) {
            return c1;
        }
        return new And<T>(c1, c2);
    }

    @NotNull
    public static <T> Condition<T> or(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
        if (c1 == Conditions.alwaysFalse() || c2 == Conditions.alwaysTrue()) {
            return c2;
        }
        if (c2 == Conditions.alwaysFalse() || c1 == Conditions.alwaysTrue()) {
            return c1;
        }
        return new Or<T>(c1, c2);
    }

    @NotNull
    public static <A, B> Condition<A> compose(@NotNull Function<? super A, B> fun, @NotNull Condition<? super B> condition) {
        return o -> condition.value(fun.fun(o));
    }

    @NotNull
    public static <T> Condition<T> cached(@NotNull Condition<? super T> c) {
        return new SoftRefCache<T>(c);
    }

    private static class Not<T>
    implements Condition<T> {
        final Condition<? super T> c;

        Not(@NotNull Condition<? super T> c) {
            this.c = c;
        }

        public boolean value(T value) {
            return !this.c.value(value);
        }
    }

    private static class And<T>
    implements Condition<T> {
        final Condition<? super T> c1;
        final Condition<? super T> c2;

        And(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public boolean value(T object) {
            return this.c1.value(object) && this.c2.value(object);
        }
    }

    private static class Or<T>
    implements Condition<T> {
        final Condition<? super T> c1;
        final Condition<? super T> c2;

        Or(@NotNull Condition<? super T> c1, @NotNull Condition<? super T> c2) {
            this.c1 = c1;
            this.c2 = c2;
        }

        public boolean value(T object) {
            return this.c1.value(object) || this.c2.value(object);
        }
    }

    private static final class SoftRefCache<T>
    implements Condition<T> {
        private final Map<Integer, Pair<SoftReference<T>, Boolean>> myCache = new HashMap<Integer, Pair<SoftReference<T>, Boolean>>();
        private final Condition<? super T> myCondition;

        SoftRefCache(@NotNull Condition<? super T> condition) {
            this.myCondition = condition;
        }

        public boolean value(T object) {
            int key = object.hashCode();
            Pair<SoftReference<T>, Boolean> entry = this.myCache.get(key);
            if (entry == null || ((SoftReference)entry.first).get() != object) {
                boolean value = this.myCondition.value(object);
                this.myCache.put(key, Pair.create(new SoftReference<T>(object), (Object)value));
                return value;
            }
            return (Boolean)entry.second;
        }
    }
}

