/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableRunnable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassLoaderUtil {
    private ClassLoaderUtil() {
    }

    public static <E extends Throwable> void runWithClassLoader(@Nullable ClassLoader classLoader, @NotNull ThrowableRunnable<E> runnable) throws E {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            runnable.run();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithClassLoader(@Nullable ClassLoader classLoader, @NotNull ThrowableComputable<T, E> computable) throws E {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public static <T> T runWithClassLoader(ClassLoader classLoader, Computable<T> computable) {
        return ClassLoaderUtil.computeWithClassLoader(classLoader, () -> computable.compute());
    }
}

