/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.SystemInfoRt;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BuildNumber
implements Comparable<BuildNumber> {
    private static final String STAR = "*";
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String FALLBACK_VERSION = "999.SNAPSHOT";
    public static final int SNAPSHOT_VALUE = Integer.MAX_VALUE;
    @NotNull
    private final String myProductCode;
    private final int @NotNull [] myComponents;

    public BuildNumber(@NotNull String productCode, int baselineVersion, int buildNumber) {
        this(productCode, new int[]{baselineVersion, buildNumber});
    }

    public BuildNumber(@NotNull String productCode, int ... components) {
        this.myProductCode = productCode;
        this.myComponents = components;
    }

    private static boolean isPlaceholder(String value) {
        return "__BUILD_NUMBER__".equals(value) || "__BUILD__".equals(value);
    }

    @NotNull
    public String getProductCode() {
        return this.myProductCode;
    }

    public int getBaselineVersion() {
        return this.myComponents[0];
    }

    public int @NotNull [] getComponents() {
        return (int[])this.myComponents.clone();
    }

    public boolean isSnapshot() {
        for (int value : this.myComponents) {
            if (value != Integer.MAX_VALUE) continue;
            return true;
        }
        return false;
    }

    @Contract(pure=true)
    @NotNull
    public BuildNumber withoutProductCode() {
        return this.myProductCode.isEmpty() ? this : new BuildNumber("", this.myComponents);
    }

    @NotNull
    @NlsSafe
    public String asString() {
        return this.asString(true, true);
    }

    @NotNull
    @NlsSafe
    public String asStringWithoutProductCode() {
        return this.asString(false, true);
    }

    @NotNull
    public String asStringWithoutProductCodeAndSnapshot() {
        return this.asString(false, false);
    }

    @NotNull
    private String asString(boolean includeProductCode, boolean withSnapshotMarker) {
        StringBuilder builder = new StringBuilder();
        if (includeProductCode && !this.myProductCode.isEmpty()) {
            builder.append(this.myProductCode).append('-');
        }
        for (int each : this.myComponents) {
            if (each != Integer.MAX_VALUE) {
                builder.append(each);
            } else if (withSnapshotMarker) {
                builder.append(SNAPSHOT);
            }
            builder.append('.');
        }
        if (builder.charAt(builder.length() - 1) == '.') {
            builder.setLength(builder.length() - 1);
        }
        return builder.toString();
    }

    @Nullable
    public static BuildNumber fromPluginsCompatibleBuild() {
        return BuildNumber.fromString(BuildNumber.getPluginsCompatibleBuild());
    }

    @Nullable
    public static BuildNumber fromStringOrNull(@NotNull String version) {
        try {
            return BuildNumber.fromString(version);
        }
        catch (RuntimeException ignored) {
            return null;
        }
    }

    @Nullable
    public static BuildNumber fromString(@Nullable String version) {
        if (version == null) {
            return null;
        }
        version = version.trim();
        return BuildNumber.fromString(version, null, null);
    }

    @Nullable
    public static BuildNumber fromStringWithProductCode(@NotNull String version, @NotNull String productCode) {
        return BuildNumber.fromString(version, null, productCode);
    }

    @Nullable
    public static BuildNumber fromString(@NotNull String version, @Nullable String pluginName, @Nullable String productCodeIfAbsentInVersion) {
        String productCode;
        if (version.isEmpty()) {
            return null;
        }
        String code = version;
        int productSeparator = code.indexOf(45);
        if (productSeparator > 0) {
            productCode = code.substring(0, productSeparator);
            code = code.substring(productSeparator + 1);
        } else {
            String string2 = productCode = productCodeIfAbsentInVersion != null ? productCodeIfAbsentInVersion : "";
        }
        if (SNAPSHOT.equals(code) || BuildNumber.isPlaceholder(code)) {
            return new BuildNumber(productCode, BuildNumber.currentVersion().myComponents);
        }
        int baselineVersionSeparator = code.indexOf(46);
        if (baselineVersionSeparator > 0) {
            String baselineVersionString = code.substring(0, baselineVersionSeparator);
            if (baselineVersionString.trim().isEmpty()) {
                return null;
            }
            String[] stringComponents = code.split("\\.");
            int[] intComponentsList = new int[stringComponents.length];
            int n = stringComponents.length;
            for (int i = 0; i < n; ++i) {
                int comp;
                String stringComponent = stringComponents[i];
                intComponentsList[i] = comp = BuildNumber.parseBuildNumber(version, stringComponent, pluginName);
                if (comp != Integer.MAX_VALUE || i + 1 == n) continue;
                intComponentsList = Arrays.copyOf(intComponentsList, i + 1);
                break;
            }
            return new BuildNumber(productCode, intComponentsList);
        }
        int buildNumber = BuildNumber.parseBuildNumber(version, code, pluginName);
        if (buildNumber <= 2000) {
            return new BuildNumber(productCode, buildNumber, 0);
        }
        int baselineVersion = BuildNumber.getBaseLineForHistoricBuilds(buildNumber);
        return new BuildNumber(productCode, baselineVersion, buildNumber);
    }

    private static int parseBuildNumber(String version, @NotNull String code, String pluginName) {
        if (SNAPSHOT.equals(code) || BuildNumber.isPlaceholder(code) || STAR.equals(code)) {
            return Integer.MAX_VALUE;
        }
        try {
            return Integer.parseInt(code);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Invalid version number: " + version + "; plugin name: " + pluginName);
        }
    }

    @Override
    public int compareTo(@NotNull BuildNumber o) {
        int[] c1 = this.myComponents;
        int[] c2 = o.myComponents;
        for (int i = 0; i < Math.min(c1.length, c2.length); ++i) {
            if (c1[i] == c2[i] && c1[i] == Integer.MAX_VALUE) {
                return 0;
            }
            if (c1[i] == Integer.MAX_VALUE) {
                return 1;
            }
            if (c2[i] == Integer.MAX_VALUE) {
                return -1;
            }
            int result = c1[i] - c2[i];
            if (result == 0) continue;
            return result;
        }
        return c1.length - c2.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BuildNumber that = (BuildNumber)o;
        if (!this.myProductCode.equals(that.myProductCode)) {
            return false;
        }
        return Arrays.equals(this.myComponents, that.myComponents);
    }

    public int hashCode() {
        int result = this.myProductCode.hashCode();
        result = 31 * result + Arrays.hashCode(this.myComponents);
        return result;
    }

    public String toString() {
        return this.asString();
    }

    private static int getBaseLineForHistoricBuilds(int bn) {
        if (bn >= 10000) {
            return 88;
        }
        if (bn >= 9500) {
            return 85;
        }
        if (bn >= 9100) {
            return 81;
        }
        if (bn >= 8000) {
            return 80;
        }
        if (bn >= 7500) {
            return 75;
        }
        if (bn >= 7200) {
            return 72;
        }
        if (bn >= 6900) {
            return 69;
        }
        if (bn >= 6500) {
            return 65;
        }
        if (bn >= 6000) {
            return 60;
        }
        if (bn >= 5000) {
            return 55;
        }
        if (bn >= 4000) {
            return 50;
        }
        return 40;
    }

    @ApiStatus.Internal
    @NotNull
    public static BuildNumber currentVersion() {
        return Holder.CURRENT_VERSION;
    }

    @Nullable
    private static String getPluginsCompatibleBuild() {
        return System.getProperty("idea.plugins.compatible.build");
    }

    private static final class Holder {
        private static final BuildNumber CURRENT_VERSION = Holder.fromFile();

        private Holder() {
        }

        @NotNull
        private static BuildNumber fromFile() {
            String homePath = PathManager.getHomePath();
            Path home = Paths.get(homePath, new String[0]);
            BuildNumber result = Holder.readFile(home.resolve("build.txt"));
            if (result != null) {
                return result;
            }
            if (SystemInfoRt.isMac && (result = Holder.readFile(home.resolve("Resources/build.txt"))) != null) {
                return result;
            }
            String communityHomePath = PathManager.getCommunityHomePath();
            if (!communityHomePath.equals(homePath) && (result = Holder.readFile(Paths.get(communityHomePath, "build.txt"))) != null) {
                return result;
            }
            return Objects.requireNonNull(BuildNumber.fromString(BuildNumber.FALLBACK_VERSION));
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nullable
        private static BuildNumber readFile(@NotNull Path path) {
            try (BufferedReader reader = Files.newBufferedReader(path);){
                String text = reader.readLine();
                if (text == null) return null;
                BuildNumber buildNumber = BuildNumber.fromString(text);
                return buildNumber;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
    }
}

