/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CachedSingletonsRegistry;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.WrappedProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import java.util.HashSet;
import java.util.function.Supplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressManager
extends ProgressIndicatorProvider {
    static ProgressManager ourInstance = CachedSingletonsRegistry.markCachedField(ProgressManager.class);

    @NotNull
    public static ProgressManager getInstance() {
        ProgressManager result = ourInstance;
        if (result == null) {
            ourInstance = result = ApplicationManager.getApplication().getService(ProgressManager.class);
        }
        return result;
    }

    @ApiStatus.Internal
    @Nullable
    public static ProgressManager getInstanceOrNull() {
        return ourInstance;
    }

    public abstract boolean hasProgressIndicator();

    public abstract boolean hasModalProgressIndicator();

    public abstract boolean hasUnsafeProgressIndicator();

    public abstract void runProcess(@NotNull Runnable var1, @Nullable ProgressIndicator var2) throws ProcessCanceledException;

    public final <T> T runProcess(@NotNull Computable<T> process, ProgressIndicator progress) throws ProcessCanceledException {
        Ref ref = new Ref();
        this.runProcess(() -> ref.set(process.compute()), progress);
        return (T)ref.get();
    }

    @Override
    public abstract ProgressIndicator getProgressIndicator();

    public static void progress(@NotNull @NlsContexts.ProgressText String text) throws ProcessCanceledException {
        ProgressManager.progress(text, "");
    }

    public static void progress2(@NotNull @NlsContexts.ProgressDetails String text) throws ProcessCanceledException {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.checkCanceled();
            pi.setText2(text);
        }
    }

    public static void progress(@NotNull @NlsContexts.ProgressText String text, @Nullable @NlsContexts.ProgressDetails String text2) throws ProcessCanceledException {
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        if (pi != null) {
            pi.checkCanceled();
            pi.setText(text);
            pi.setText2(text2 == null ? "" : text2);
        }
    }

    public abstract void executeNonCancelableSection(@NotNull Runnable var1);

    public abstract <T, E extends Exception> T computeInNonCancelableSection(@NotNull ThrowableComputable<T, E> var1) throws E;

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @NlsContexts.ProgressTitle String var2, boolean var3, @Nullable Project var4);

    public abstract <T, E extends Exception> T runProcessWithProgressSynchronously(@NotNull ThrowableComputable<T, E> var1, @NotNull @NlsContexts.ProgressTitle String var2, boolean var3, @Nullable Project var4) throws E;

    public abstract boolean runProcessWithProgressSynchronously(@NotNull Runnable var1, @NotNull @NlsContexts.DialogTitle String var2, boolean var3, @Nullable Project var4, @Nullable JComponent var5);

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public abstract void runProcessWithProgressAsynchronously(@NotNull Project var1, @NotNull @NlsContexts.ProgressTitle String var2, @NotNull Runnable var3, @Nullable Runnable var4, @Nullable Runnable var5, @NotNull PerformInBackgroundOption var6);

    public abstract void run(@NotNull Task var1);

    public <T, E extends Exception> T run(@NotNull Task.WithResult<T, E> task) throws E {
        this.run((Task)task);
        return task.getResult();
    }

    public abstract void runProcessWithProgressAsynchronously(@NotNull Task.Backgroundable var1, @NotNull ProgressIndicator var2);

    protected void indicatorCanceled(@NotNull ProgressIndicator indicator) {
    }

    public static void canceled(@NotNull ProgressIndicator indicator) {
        ProgressManager.getInstance().indicatorCanceled(indicator);
    }

    public static void checkCanceled() throws ProcessCanceledException {
        ProgressManager instance = ourInstance;
        if (instance != null) {
            instance.doCheckCanceled();
        }
    }

    public abstract void executeProcessUnderProgress(@NotNull Runnable var1, @Nullable ProgressIndicator var2) throws ProcessCanceledException;

    public static void assertNotCircular(@NotNull ProgressIndicator original) {
        HashSet<ProgressIndicator> wrappedParents = null;
        ProgressIndicator i = original;
        while (i instanceof WrappedProgressIndicator) {
            if (wrappedParents == null) {
                wrappedParents = new HashSet<ProgressIndicator>();
            }
            if (!wrappedParents.add(i)) {
                throw new IllegalArgumentException(i + " wraps itself");
            }
            i = ((WrappedProgressIndicator)i).getOriginalProgressIndicator();
        }
    }

    public abstract boolean runInReadActionWithWriteActionPriority(@NotNull Runnable var1, @Nullable ProgressIndicator var2);

    public abstract boolean isInNonCancelableSection();

    @ApiStatus.Internal
    public abstract <T, E extends Throwable> T computePrioritized(@NotNull ThrowableComputable<T, E> var1) throws E;

    @ApiStatus.Internal
    public abstract <X> X silenceGlobalIndicator(@NotNull Supplier<? extends X> var1);

    @ApiStatus.Internal
    @Nullable
    public abstract ModalityState getCurrentProgressModality();
}

