/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.progress.Cancellation;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class PeriodicCancellationRunnable
implements Runnable {
    @NotNull
    private final CompletableJob myJob;
    @NotNull
    private final Runnable myRunnable;

    public PeriodicCancellationRunnable(@NotNull CompletableJob job, @NotNull Runnable runnable) {
        this.myJob = job;
        this.myRunnable = runnable;
    }

    @Override
    public void run() {
        try {
            Cancellation.withCurrentJob((Job)this.myJob, () -> {
                this.myRunnable.run();
                return null;
            });
        }
        catch (Throwable e) {
            this.myJob.completeExceptionally(e);
            throw e;
        }
    }
}

