/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.diagnostic.PluginException;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import org.jetbrains.annotations.NotNull;

public abstract class EmptyProgressIndicatorBase
implements ProgressIndicator {
    @NotNull
    private final ModalityState myModalityState;
    @NotNull
    private volatile RunState myRunState = RunState.VIRGIN;
    private volatile int myNonCancelableSectionCount;

    public EmptyProgressIndicatorBase() {
        this(ModalityState.defaultModalityState());
    }

    public EmptyProgressIndicatorBase(@NotNull ModalityState modalityState) {
        this.myModalityState = modalityState;
    }

    @Override
    public void start() {
        if (this.myRunState == RunState.STARTED) {
            throw new IllegalStateException("Indicator already started");
        }
        this.myRunState = RunState.STARTED;
    }

    @Override
    public void stop() {
        switch (this.myRunState) {
            case VIRGIN: {
                throw new IllegalStateException("Indicator can't be stopped because it wasn't started");
            }
            case STARTED: {
                this.myRunState = RunState.STOPPED;
                break;
            }
            case STOPPED: {
                throw new IllegalStateException("Indicator already stopped");
            }
        }
    }

    @Override
    public boolean isRunning() {
        return this.myRunState == RunState.STARTED;
    }

    @Override
    public final void checkCanceled() {
        if (this.isCanceled() && this.myNonCancelableSectionCount == 0) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public void setText(String text) {
    }

    @Override
    public String getText() {
        return "";
    }

    @Override
    public void setText2(String text) {
    }

    @Override
    public String getText2() {
        return "";
    }

    @Override
    public double getFraction() {
        return 1.0;
    }

    @Override
    public void setFraction(double fraction) {
    }

    @Override
    public void pushState() {
    }

    @Override
    public void popState() {
    }

    @Override
    public void startNonCancelableSection() {
        PluginException.reportDeprecatedUsage("ProgressIndicator#startNonCancelableSection", "Use `ProgressManager.executeNonCancelableSection()` instead");
        ++this.myNonCancelableSectionCount;
    }

    @Override
    public void finishNonCancelableSection() {
        --this.myNonCancelableSectionCount;
    }

    @Override
    public boolean isModal() {
        return false;
    }

    @Override
    @NotNull
    public ModalityState getModalityState() {
        return this.myModalityState;
    }

    @Override
    public void setModalityProgress(ProgressIndicator modalityProgress) {
        if (this.isRunning()) {
            throw new IllegalStateException("Can't change modality progress for already running indicator");
        }
    }

    @Override
    public boolean isIndeterminate() {
        return false;
    }

    @Override
    public void setIndeterminate(boolean indeterminate) {
    }

    @Override
    public boolean isPopupWasShown() {
        return false;
    }

    @Override
    public boolean isShowing() {
        return false;
    }

    private static enum RunState {
        VIRGIN,
        STARTED,
        STOPPED;

    }
}

