/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.concurrency.ThreadContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.CancellationKt;
import com.intellij.openapi.progress.CoroutineSuspenderElement;
import com.intellij.openapi.progress.CoroutineSuspenderElementKey;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorSink;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.ProgressSink;
import com.intellij.openapi.progress.ProgressSinkIndicator;
import com.intellij.openapi.progress.SinkKt;
import java.util.concurrent.CancellationException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.ContinuationInterceptor;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DisposableHandle;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a%\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u001a\u0011\u0010\u0005\u001a\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0007\u001aG\u0010\b\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\t\u001a\u00020\n2'\u0010\u0002\u001a#\b\u0001\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000b\u00a2\u0006\u0002\b\u000fH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001a=\u0010\b\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012'\u0010\u0002\u001a#\b\u0001\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000b\u00a2\u0006\u0002\b\u000f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001a?\u0010\u0012\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012'\u0010\u0002\u001a#\b\u0001\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000b\u00a2\u0006\u0002\b\u000fH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001aG\u0010\u0013\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\t\u001a\u00020\n2'\u0010\u0002\u001a#\b\u0001\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000b\u00a2\u0006\u0002\b\u000fH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0010\u001a?\u0010\u0013\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012'\u0010\u0002\u001a#\b\u0001\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\r\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u000b\u00a2\u0006\u0002\b\u000fH\u0007\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001a%\u0010\u0014\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0087@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0004\u001a)\u0010\u0014\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0007\u00a2\u0006\u0002\u0010\u0017\u001a1\u0010\u0014\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0003H\u0007\u00a2\u0006\u0002\u0010\u001a\u001a\f\u0010\u001b\u001a\u00020\n*\u00020\u0016H\u0002\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001c"}, d2={"blockingContext", "T", "action", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "checkCanceled", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runBlockingCancellable", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "Lkotlin/Function2;", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "(Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "runBlockingMaybeCancellable", "runSuspendingAction", "runUnderIndicator", "ctx", "Lkotlin/coroutines/CoroutineContext;", "(Lkotlin/coroutines/CoroutineContext;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "job", "Lkotlinx/coroutines/Job;", "(Lkotlinx/coroutines/Job;Lcom/intellij/openapi/progress/ProgressIndicator;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "createIndicator", "intellij.platform.core"})
@ApiStatus.Experimental
public final class CoroutinesKt {
    @Nullable
    public static final Object checkCanceled(@NotNull Continuation<? super Unit> $completion) {
        CoroutineContext ctx = $completion.getContext();
        JobKt.ensureActive((CoroutineContext)ctx);
        CoroutineSuspenderElement coroutineSuspenderElement = (CoroutineSuspenderElement)ctx.get((CoroutineContext.Key)CoroutineSuspenderElementKey.INSTANCE);
        if (coroutineSuspenderElement != null) {
            Object object = coroutineSuspenderElement.checkPaused($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    public static final <T> T runBlockingCancellable(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        ProgressIndicator indicator = ProgressManager.getGlobalProgressIndicator();
        if (indicator != null) {
            return CoroutinesKt.runBlockingCancellable(indicator, action);
        }
        return CancellationKt.ensureCurrentJob((Function1)new Function1<Job, T>(action){
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super T>, Object> $action;
            {
                this.$action = $action;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T invoke(@NotNull Job currentJob) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)currentJob, (String)"currentJob");
                CoroutineContext context = ThreadContext.currentThreadContext().plus((CoroutineContext)currentJob).plus((CoroutineContext)new CoroutineName("job run blocking"));
                AutoCloseable autoCloseable = ThreadContext.replaceThreadContext((CoroutineContext)EmptyCoroutineContext.INSTANCE);
                Function2<CoroutineScope, Continuation<? super T>, Object> function2 = this.$action;
                Throwable throwable = null;
                try {
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl = false;
                    object = BuildersKt.runBlocking((CoroutineContext)context, function2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return (T)object;
            }
        });
    }

    @ApiStatus.Internal
    public static final <T> T runBlockingMaybeCancellable(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return CancellationKt.ensureCurrentJobAllowingOrphan((Function1)new Function1<Job, T>(action){
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super T>, Object> $action;
            {
                this.$action = $action;
                super(1);
            }

            public final T invoke(@NotNull Job it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return CoroutinesKt.runBlockingCancellable(this.$action);
            }
        });
    }

    @ApiStatus.Internal
    public static final <T> T runBlockingCancellable(@NotNull ProgressIndicator indicator, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return CancellationKt.ensureCurrentJob(indicator, (Function1)new Function1<Job, T>(indicator, action){
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ Function2<CoroutineScope, Continuation<? super T>, Object> $action;
            {
                this.$indicator = $indicator;
                this.$action = $action;
                super(1);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final T invoke(@NotNull Job currentJob) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)currentJob, (String)"currentJob");
                CoroutineContext context = ThreadContext.currentThreadContext().plus((CoroutineContext)currentJob).plus((CoroutineContext)new CoroutineName("indicator run blocking")).plus((CoroutineContext)SinkKt.asContextElement(new ProgressIndicatorSink(this.$indicator)));
                AutoCloseable autoCloseable = ThreadContext.replaceThreadContext((CoroutineContext)EmptyCoroutineContext.INSTANCE);
                Function2<CoroutineScope, Continuation<? super T>, Object> function2 = this.$action;
                Throwable throwable = null;
                try {
                    AccessToken it = (AccessToken)autoCloseable;
                    boolean bl = false;
                    object = BuildersKt.runBlocking((CoroutineContext)context, function2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
                return (T)object;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <T> Object blockingContext(@NotNull Function0<? extends T> action, @NotNull Continuation<? super T> $completion) {
        T t;
        CoroutineContext currentContext = $completion.getContext().minusKey((CoroutineContext.Key)ContinuationInterceptor.Key);
        AutoCloseable autoCloseable = ThreadContext.replaceThreadContext(currentContext);
        Throwable throwable = null;
        try {
            AccessToken it = (AccessToken)autoCloseable;
            boolean bl = false;
            t = CancellationKt.withCurrentJob(JobKt.getJob((CoroutineContext)currentContext), action);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return t;
    }

    @ApiStatus.Internal
    @Nullable
    public static final <T> Object runUnderIndicator(@NotNull Function0<? extends T> action, @NotNull Continuation<? super T> $completion) {
        CoroutineContext ctx = $completion.getContext();
        return CoroutinesKt.runUnderIndicator(ctx, action);
    }

    @ApiStatus.Internal
    public static final <T> T runUnderIndicator(@NotNull CoroutineContext ctx, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Job job = JobKt.getJob((CoroutineContext)ctx);
        JobKt.ensureActive((Job)job);
        ProgressIndicator indicator = CoroutinesKt.createIndicator(ctx);
        return CoroutinesKt.runUnderIndicator(job, indicator, action);
    }

    private static final ProgressIndicator createIndicator(CoroutineContext $this$createIndicator) {
        ModalityState modalityState = ModalityKt.contextModality($this$createIndicator);
        if (modalityState == null) {
            ModalityState modalityState2 = ModalityState.NON_MODAL;
            modalityState = modalityState2;
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"NON_MODAL");
        }
        ModalityState contextModality = modalityState;
        ProgressSink progressSink = SinkKt.getProgressSink($this$createIndicator);
        return progressSink == null ? (ProgressIndicator)new EmptyProgressIndicator(contextModality) : (ProgressIndicator)new ProgressSinkIndicator(progressSink, contextModality);
    }

    @ApiStatus.Internal
    public static final <T> T runUnderIndicator(@NotNull Job job, @NotNull ProgressIndicator indicator, @NotNull Function0<? extends T> action) {
        Intrinsics.checkNotNullParameter((Object)job, (String)"job");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        try {
            return (T)ProgressManager.getInstance().runProcess(() -> CoroutinesKt.runUnderIndicator$lambda$1(job, indicator, action), indicator);
        }
        catch (ProcessCanceledException e) {
            if (!indicator.isCanceled()) {
                throw e;
            }
            if (!job.isCancelled()) {
                String string2 = "Check failed.";
                throw new IllegalStateException(string2.toString());
            }
            throw job.getCancellationException();
        }
    }

    @Deprecated(message="Method was renamed", replaceWith=@ReplaceWith(expression="runBlockingCancellable(action)", imports={}), level=DeprecationLevel.ERROR)
    public static final <T> T runSuspendingAction(@NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return CoroutinesKt.runBlockingCancellable(action);
    }

    @Deprecated(message="Method was renamed", replaceWith=@ReplaceWith(expression="runBlockingCancellable(indicator, action)", imports={}), level=DeprecationLevel.ERROR)
    public static final <T> T runSuspendingAction(@NotNull ProgressIndicator indicator, @NotNull Function2<? super CoroutineScope, ? super Continuation<? super T>, ? extends Object> action) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        return CoroutinesKt.runBlockingCancellable(indicator, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object runUnderIndicator$lambda$1(Job $job, ProgressIndicator $indicator, Function0 $action) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$job, (String)"$job");
        Intrinsics.checkNotNullParameter((Object)$indicator, (String)"$indicator");
        Intrinsics.checkNotNullParameter((Object)$action, (String)"$action");
        DisposableHandle completionHandle2 = Job.DefaultImpls.invokeOnCompletion$default((Job)$job, (boolean)true, (boolean)false, (Function1)((Function1)new Function1<Throwable, Unit>($indicator){
            final /* synthetic */ ProgressIndicator $indicator;
            {
                this.$indicator = $indicator;
                super(1);
            }

            public final void invoke(@Nullable Throwable it) {
                if (it instanceof CancellationException) {
                    this.$indicator.cancel();
                }
            }
        }), (int)2, null);
        try {
            $indicator.checkCanceled();
            object = $action.invoke();
        }
        finally {
            completionHandle2.dispose();
        }
        return object;
    }
}

