/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.progress.Cancellation;
import java.util.concurrent.CancellationException;
import kotlinx.coroutines.CompletableJob;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class CancellationRunnable
implements Runnable {
    @NotNull
    private final CompletableJob myJob;
    @NotNull
    private final Runnable myRunnable;

    public CancellationRunnable(@NotNull CompletableJob job, @NotNull Runnable runnable) {
        this.myJob = job;
        this.myRunnable = runnable;
    }

    @Override
    public void run() {
        try {
            Cancellation.withCurrentJob((Job)this.myJob, () -> {
                this.myRunnable.run();
                return null;
            });
            this.myJob.complete();
        }
        catch (CancellationException e) {
            this.myJob.completeExceptionally((Throwable)e);
        }
        catch (Throwable e) {
            this.myJob.completeExceptionally(e);
            throw e;
        }
    }

    public String toString() {
        return this.myRunnable.toString();
    }
}

